/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.MCOFeesWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.agentreport.RefundWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.agentreport.SellWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.agentreport.SummaryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AgentReportRenderHandler
extends BasePoiReportRenderHandler<AgentReportTicket> {
    public static final String SELL_BATCH_ID = "SELL";
    public static final String REFUND_BATCH_ID = "REFUND";
    public static final String MCOFEES_BATCH_ID = "MCOFEES";

    @Override
    protected List<PoiWorksheetData<AgentReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<AgentReportTicket>> result = new ArrayList<PoiWorksheetData<AgentReportTicket>>();
        result.add(new BaseWorksheetData<AgentReportTicket>(){

            @Override
            public String getBatchId() {
                return "SUMMARY";
            }

            @Override
            public PoiWorksheetDefinition<AgentReportTicket> getDefinition() {
                return Definitions.SUMMARY;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        result.add(new BaseWorksheetData<AgentReportTicket>(){

            @Override
            public String getBatchId() {
                return AgentReportRenderHandler.SELL_BATCH_ID;
            }

            @Override
            public PoiWorksheetDefinition<AgentReportTicket> getDefinition() {
                return Definitions.SELL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<AgentReportTicket>(){

            @Override
            public String getBatchId() {
                return AgentReportRenderHandler.REFUND_BATCH_ID;
            }

            @Override
            public PoiWorksheetDefinition<AgentReportTicket> getDefinition() {
                return Definitions.REFUND;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<AgentReportTicket>(){

            @Override
            public String getBatchId() {
                return AgentReportRenderHandler.MCOFEES_BATCH_ID;
            }

            @Override
            public PoiWorksheetDefinition<AgentReportTicket> getDefinition() {
                return Definitions.MCOFEES;
            }

            @Override
            public int getProirity() {
                return 5;
            }
        });
        return result;
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(AgentReportDocument.class);
        ((AgentReportDocument)result.getEntity()).getFiles().add(file);
        List messages = (List)data.get("key-messages");
        ((AgentReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((AgentReportDocument)result.getEntity()).setReportType(ReportType.AGENT);
        AgentReportParameters reportParameters = (AgentReportParameters)data.get("key-report-params");
        reportParameters.getVendors().clear();
        reportParameters.getVendors().addAll((Set)data.get("ACTUAL_VENDORS"));
        ((AgentReportDocument)result.getEntity()).setParameters(reportParameters);
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        byte[] template = (byte[])data.get("REPORT_TEMPLATE");
        if (template == null) {
            File result = IoUtil.url2file((URL)BasePoiReportRenderHandler.class.getResource("/agentreports/AgentReportTemplate.xls"));
            if (!result.exists() || !result.canRead()) {
                throw new IOException(String.format("unable to load agent report template %s", result.getCanonicalPath()));
            }
            return IoUtil.getResourceInputStream((File)result);
        }
        return new ByteArrayInputStream(template);
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportRenderHandler_reportTitle, (Object[])new Object[]{data.get("AGENT_NAME"), data.get("AGENCY_NAME"), data.get("REPORT_PERIOD")}).toString();
    }

    @Override
    public String getId() {
        return "agent-report";
    }

    public static enum Definitions implements PoiWorksheetDefinition<AgentReportTicket>
    {
        SUMMARY{

            @Override
            public PoiWorksheetHandler<AgentReportTicket> getHandler() {
                return new SummaryWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportRenderHandler_summaryWorksheet, (Object[])new Object[0]).toString();
            }
        }
        ,
        SELL{

            @Override
            public PoiWorksheetHandler<AgentReportTicket> getHandler() {
                return new SellWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportRenderHandler_sellWorksheet, (Object[])new Object[0]).toString();
            }
        }
        ,
        REFUND{

            @Override
            public PoiWorksheetHandler<AgentReportTicket> getHandler() {
                return new RefundWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportRenderHandler_refundWorksheet, (Object[])new Object[0]).toString();
            }
        }
        ,
        MCOFEES{

            @Override
            public PoiWorksheetHandler<AgentReportTicket> getHandler() {
                return new MCOFeesWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportRenderHandler_mcofeesWorksheet, (Object[])new Object[0]).toString();
            }
        };

    }
}

