/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentReportTicket
extends BaseReportTicket {
    private static final long serialVersionUID = 4018226892515145825L;
    public static final Comparator<PaymentTypeInfo> paymentTypeInfosComparator = new Comparator<PaymentTypeInfo>(){

        @Override
        public int compare(PaymentTypeInfo o1, PaymentTypeInfo o2) {
            if (MiscUtil.equals((Object)o1, (Object)o2)) {
                return 0;
            }
            int res = paymentTypesComparator.compare(o1.getPaymentType(), o2.getPaymentType());
            if (res != 0) {
                return res;
            }
            return o1.isPayed() ? -1 : 1;
        }
    };
    public static final Comparator<PaymentType> paymentTypesComparator = new Comparator<PaymentType>(){

        @Override
        public int compare(PaymentType o1, PaymentType o2) {
            if (MiscUtil.equals((Object)o1, (Object)o2)) {
                return 0;
            }
            return this.getIndex(o1) - this.getIndex(o2);
        }

        private int getIndex(PaymentType o1) {
            if (o1 == null) {
                return -1;
            }
            switch (o1) {
                case CASH: {
                    return 0;
                }
                case INVOICE: {
                    return 1;
                }
                case PTA: {
                    return 2;
                }
                case CREDIT_CARD: {
                    return 3;
                }
                case CREDIT: {
                    return 4;
                }
            }
            return 5;
        }
    };
    public static final Comparator<AgentReportTicket> ticketComparator = new Comparator<AgentReportTicket>(){

        @Override
        public int compare(AgentReportTicket o1, AgentReportTicket o2) {
            int res = TextUtil.compare((String)o1.getSortingTicketNumber(), (String)o2.getSortingTicketNumber(), (boolean)false, (boolean)true);
            if (res != 0) {
                return res;
            }
            if (o1.isRefundPenaltyMCO() != o2.isRefundPenaltyMCO()) {
                return o1.isRefundPenaltyMCO() ? 1 : -1;
            }
            if (o1.isExchangePenaltyMCO() != o2.isExchangePenaltyMCO()) {
                return o1.isRefundPenaltyMCO() ? 1 : -1;
            }
            if (o1.isRefundReceiptMCO() != o2.isRefundReceiptMCO()) {
                return o1.isRefundReceiptMCO() ? 1 : -1;
            }
            if (o1.isExchangeReceiptMCO() != o2.isExchangeReceiptMCO()) {
                return o1.isExchangeReceiptMCO() ? 1 : -1;
            }
            return TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)true);
        }
    };
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private String sortingTicketNumber;
    private boolean conjunction = false;
    private String routeLine;
    private BigDecimal otherTaxesAmount;
    private BigDecimal ruTaxAmount;
    private BigDecimal penaltyAmount;
    private final HashMap<PaymentTypeInfo, BigDecimal> totals = new HashMap();
    private final HashMap<PaymentTypeInfo, BigDecimal> fees = new HashMap();
    private final HashMap<PaymentTypeInfo, BigDecimal> feesForRefund = new HashMap();
    private boolean exchangePenaltyMCO = false;
    private boolean refundPenaltyMCO = false;
    private boolean refundReceiptMCO = false;
    private boolean exchangeReceiptMCO = false;
    private boolean payedInReportPeriod;
    private boolean refusedInReportPeriod;
    private boolean issuedMCOFeeInReportPeriod = false;
    private String relatedSellNumber;
    protected String remarks;
    private Date sellIssueDate;
    private boolean issuedInReportPeriod;
    private String groupName;
    private String airTicketNumbers;

    static String getName(PaymentTypeInfo info) {
        return info.isPayed() ? AgentReportTicket.getName(info.getPaymentType()) : String.join((CharSequence)" ", AgentReportTicket.getName(info.getPaymentType()), L10nResourcesManager.createL10nMessage((String)Messages.AgentReportTicket_notPayed, (Object[])new Object[0]).toString());
    }

    static String getName(PaymentType info) {
        if (info == null) {
            return "";
        }
        switch (info) {
            case CASH: {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportTicket_cash, (Object[])new Object[0]).toString();
            }
            case PTA: {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportTicket_pta, (Object[])new Object[0]).toString();
            }
            case INVOICE: {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportTicket_invoice, (Object[])new Object[0]).toString();
            }
            case CREDIT: {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportTicket_credit, (Object[])new Object[0]).toString();
            }
            case CREDIT_CARD: {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportTicket_ccSupplier, (Object[])new Object[0]).toString();
            }
            case CREDIT_CARD_AGENCY: {
                return L10nResourcesManager.createL10nMessage((String)Messages.AgentReportTicket_ccAgency, (Object[])new Object[0]).toString();
            }
        }
        return info.toString();
    }

    public void resetFinanceFields(boolean resetEquivalentFare) {
        this.totals.clear();
        this.fees.clear();
        this.feesForRefund.clear();
        this.otherTaxesAmount = BigDecimal.ZERO;
        this.ruTaxAmount = BigDecimal.ZERO;
        this.penaltyAmount = BigDecimal.ZERO;
        if (resetEquivalentFare) {
            this.equivalentFare = BigDecimal.ZERO;
        }
    }

    public String getSortingTicketNumber() {
        return this.sortingTicketNumber;
    }

    public boolean isConjunction() {
        return this.conjunction;
    }

    public String getRouteLine() {
        return this.routeLine;
    }

    public BigDecimal getOtherTaxesAmount() {
        return this.otherTaxesAmount;
    }

    public BigDecimal getRuTaxAmount() {
        return this.ruTaxAmount;
    }

    public BigDecimal getPenaltyAmount() {
        return this.penaltyAmount;
    }

    public Map<PaymentTypeInfo, BigDecimal> getTotals() {
        return this.totals;
    }

    public Map<PaymentTypeInfo, BigDecimal> getFees() {
        return this.fees;
    }

    public Map<PaymentTypeInfo, BigDecimal> getFeesForRefund() {
        return this.feesForRefund;
    }

    public boolean isExchangePenaltyMCO() {
        return this.exchangePenaltyMCO;
    }

    public boolean isRefundPenaltyMCO() {
        return this.refundPenaltyMCO;
    }

    public boolean isRefundReceiptMCO() {
        return this.refundReceiptMCO;
    }

    public boolean isExchangeReceiptMCO() {
        return this.exchangeReceiptMCO;
    }

    public boolean isPayedInReportPeriod() {
        return this.payedInReportPeriod;
    }

    public String getRelatedSellNumber() {
        return this.relatedSellNumber;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public boolean isRefusedInReportPeriod() {
        return this.refusedInReportPeriod;
    }

    public Date getSellIssueDate() {
        return this.sellIssueDate;
    }

    public boolean isIssuedInReportPeriod() {
        return this.issuedInReportPeriod;
    }

    public void setSortingTicketNumber(String value) {
        this.sortingTicketNumber = value;
    }

    public void setRouteLine(String value) {
        this.routeLine = value;
    }

    public void setOtherTaxesAmount(BigDecimal value) {
        this.otherTaxesAmount = value;
    }

    public void setRuTaxAmount(BigDecimal value) {
        this.ruTaxAmount = value;
    }

    public void setPenaltyAmount(BigDecimal value) {
        this.penaltyAmount = value;
    }

    public void setExchangePenaltyMCO(boolean value) {
        this.exchangePenaltyMCO = value;
    }

    public void setRefundPenaltyMCO(boolean value) {
        this.refundPenaltyMCO = value;
    }

    public void setRefundReceiptMCO(boolean value) {
        this.refundReceiptMCO = value;
    }

    public void setExchangeReceiptMCO(boolean value) {
        this.exchangeReceiptMCO = value;
    }

    public void setPayedInReportPeriod(boolean value) {
        this.payedInReportPeriod = value;
    }

    public void setRefusedInReportPeriod(boolean value) {
        this.refusedInReportPeriod = value;
    }

    public void setRelatedSellNumber(String value) {
        this.relatedSellNumber = value;
    }

    public void setRemarks(String value) {
        this.remarks = value;
    }

    public void setSellIssueDate(Date value) {
        this.sellIssueDate = value;
    }

    public void setIssuedInReportPeriod(boolean value) {
        this.issuedInReportPeriod = value;
    }

    public void setConjunction(boolean value) {
        this.conjunction = value;
    }

    public void setGroupName(String value) {
        this.groupName = value;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isIssuedMCOFeeInReportPeriod() {
        return this.issuedMCOFeeInReportPeriod;
    }

    public void setIssuedMCOFeeInReportPeriod(boolean issuedMCOFeeInReportPeriod) {
        this.issuedMCOFeeInReportPeriod = issuedMCOFeeInReportPeriod;
    }

    public String getAirTicketNumbers() {
        return this.airTicketNumbers;
    }

    public void setAirTicketNumbers(String ticketNumbers) {
        this.airTicketNumbers = ticketNumbers;
    }

    public static class PaymentTypeInfo
    implements Serializable {
        private static final long serialVersionUID = 7485141269288545769L;
        private PaymentType paymentType;
        private boolean payed;

        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        public void setPaymentType(PaymentType value) {
            this.paymentType = value;
        }

        public boolean isPayed() {
            return this.payed;
        }

        public void setPayed(boolean value) {
            this.payed = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PaymentTypeInfo)) {
                return false;
            }
            PaymentTypeInfo info = (PaymentTypeInfo)obj;
            return this.payed == info.payed && this.paymentType == info.paymentType;
        }

        public int hashCode() {
            int result = Boolean.valueOf(this.payed).hashCode();
            if (this.paymentType != null) {
                result ^= this.paymentType.hashCode();
            }
            return result;
        }
    }

    public static enum Property {
        status,
        mcoCategory,
        uid,
        productCategory,
        ticketNumber,
        ticketSeries,
        equivalentFare,
        blankOwner,
        issueDate,
        sortingTicketNumber,
        conjunction,
        routeLine,
        otherTaxesAmount,
        ruTaxAmount,
        penaltyAmount,
        totals,
        fees,
        feesForRefund,
        exchangePenaltyMCO,
        refundPenaltyMCO,
        refundReceiptMCO,
        exchangeReceiptMCO,
        payedInReportPeriod,
        refusedInReportPeriod,
        issuedMCOFeeInReportPeriod,
        relatedSellNumber,
        remarks,
        sellIssueDate,
        issuedInReportPeriod,
        groupName,
        airTicketNumbers;

    }
}

