/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineRefusedSummaryData;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineSummaryData;
import com.gridnine.xtrip.common.reports.render.agentreport.TicketsGroupData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

abstract class BaseSellRefundWorksheetHandler
extends BasePoiWorksheetHandler<AgentReportTicket> {
    static final String KEY_SALES_POINTS_NAMES = "SALES_POINTS_NAMES";

    BaseSellRefundWorksheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<AgentReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_NUMBER", (String)((String)globalData.get("REPORT_NUMBER")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)KEY_SALES_POINTS_NAMES, (String)((String)globalData.get("KEY_ACTUAL_SALES_POINTS")));
        this.addColumns(sheet, globalData);
        HashMap<String, TicketsGroupData> section1Groups = new HashMap<String, TicketsGroupData>();
        HashMap<String, TicketsGroupData> section2Groups = new HashMap<String, TicketsGroupData>();
        HashMap<String, TicketsGroupData> section3Groups = new HashMap<String, TicketsGroupData>();
        for (AgentReportTicket ticket : data.getTickets()) {
            String groupName = ticket.getGroupName();
            ArrayList<HashMap<String, TicketsGroupData>> groupsList = new ArrayList<HashMap<String, TicketsGroupData>>();
            if (ticket.isPayedInReportPeriod()) {
                groupsList.add(section2Groups);
            }
            if (ticket.isIssuedInReportPeriod() || ticket.isIssuedMCOFeeInReportPeriod()) {
                groupsList.add(section1Groups);
            }
            if (ticket.isRefusedInReportPeriod()) {
                groupsList.add(section3Groups);
            }
            for (Map map : groupsList) {
                TicketsGroupData tdata = (TicketsGroupData)map.get(groupName);
                if (tdata == null) {
                    tdata = new TicketsGroupData();
                    tdata.groupName = groupName;
                    map.put(groupName, tdata);
                }
                tdata.tickets.add(ticket);
            }
        }
        for (TicketsGroupData tdata : section1Groups.values()) {
            Collections.sort(tdata.tickets, AgentReportTicket.ticketComparator);
        }
        for (TicketsGroupData tdata : section2Groups.values()) {
            Collections.sort(tdata.tickets, AgentReportTicket.ticketComparator);
        }
        for (TicketsGroupData tdata : section3Groups.values()) {
            Collections.sort(tdata.tickets, AgentReportTicket.ticketComparator);
        }
        ArrayList<Integer> totals = new ArrayList<Integer>();
        this.fillSection(sheet, section1Groups, totals, 1, globalData);
        this.fillSection(sheet, section2Groups, totals, 2, globalData);
        this.fillSection(sheet, section3Groups, totals, 3, globalData);
    }

    private void fillSection(HSSFSheet sheet, Map<String, TicketsGroupData> sections, List<Integer> totals, int sectionNumber, Map<String, Object> globalData) throws Exception {
        ArrayList<String> groupNames = new ArrayList<String>(sections.keySet());
        Comparator<String> airlineComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TextUtil.compare((String)o1, (String)o2, (boolean)false, (boolean)true);
            }
        };
        Collections.sort(groupNames, airlineComparator);
        int rowIndex1 = this.getSectionRowNumber(sectionNumber, sheet);
        for (int n = 1; n < groupNames.size(); ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)(rowIndex1 + (n - 1) * 2 - 1), (int)(rowIndex1 + (n - 1) * 2 + 1));
        }
        int currentRow = rowIndex1;
        int startColumn = this.getSectionBeginColumn(sectionNumber, globalData);
        int endColumn = this.getSectionEndColumn(sectionNumber, globalData);
        List<Integer> excludedColumns = this.getExcludedSumColumns(sectionNumber, globalData);
        for (String groupName : groupNames) {
            int n;
            TicketsGroupData group = sections.get(groupName);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)2, (String)groupName);
            int firstRow = ++currentRow;
            for (int n2 = 1; n2 < group.tickets.size(); ++n2) {
                ExcelUtils.copyRows((HSSFSheet)sheet, (int)(currentRow - 1), (int)(currentRow - 1));
            }
            boolean updateSummaryData = false;
            for (n = 0; n < group.tickets.size(); ++n) {
                AgentReportTicket ticket = group.tickets.get(n);
                this.fillRow(sheet, sectionNumber, currentRow, ticket, n, globalData);
                ++currentRow;
                HashMap<AgentReportTicket.PaymentTypeInfo, BigDecimal> map = new HashMap<AgentReportTicket.PaymentTypeInfo, BigDecimal>(ticket.getFees());
                map.putAll(ticket.getFeesForRefund());
                map.putAll(ticket.getTotals());
                for (BigDecimal value : map.values()) {
                    if (value == null || BigDecimal.ZERO.compareTo(value) == 0) continue;
                    updateSummaryData = true;
                }
            }
            for (n = startColumn; n <= endColumn; ++n) {
                if (excludedColumns.contains(n)) continue;
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)n, (String)String.format("SUM(%s%s:%1$s%s)", String.valueOf((char)(64 + n)), Integer.toString(firstRow), Integer.toString(currentRow - 1)));
            }
            totals.add(currentRow);
            if (updateSummaryData) {
                if (sectionNumber == 3) {
                    this.updateAirlineRefusedSummaryData(groupName, currentRow, globalData);
                } else {
                    this.updateAirlineSummaryData(groupName, currentRow, globalData, sectionNumber);
                }
            }
            ++currentRow;
        }
    }

    private void updateAirlineSummaryData(String groupName, int currentRow, Map<String, Object> globalData, int sectionNumber) {
        ArrayList<AirlineSummaryData> summaryDataList = (ArrayList<AirlineSummaryData>)globalData.get("key-airline-summary-data");
        if (summaryDataList == null) {
            summaryDataList = new ArrayList<AirlineSummaryData>();
            globalData.put("key-airline-summary-data", summaryDataList);
        }
        AirlineSummaryData summaryData = null;
        for (AirlineSummaryData sdata : summaryDataList) {
            if (!groupName.equals(sdata.groupName)) continue;
            summaryData = sdata;
            break;
        }
        if (summaryData == null) {
            summaryData = new AirlineSummaryData();
            summaryData.groupName = groupName;
            summaryDataList.add(summaryData);
        }
        this.updateAirlineSummaryData(summaryData, currentRow, globalData, sectionNumber);
    }

    private void updateAirlineRefusedSummaryData(String airline, int currentRow, Map<String, Object> globalData) {
        ArrayList<AirlineRefusedSummaryData> summaryDataList = (ArrayList<AirlineRefusedSummaryData>)globalData.get("key-airline-refused-summary-data");
        if (summaryDataList == null) {
            summaryDataList = new ArrayList<AirlineRefusedSummaryData>();
            globalData.put("key-airline-refused-summary-data", summaryDataList);
        }
        AirlineRefusedSummaryData summaryData = null;
        for (AirlineRefusedSummaryData sdata : summaryDataList) {
            if (!airline.equals(sdata.groupName)) continue;
            summaryData = sdata;
            break;
        }
        if (summaryData == null) {
            summaryData = new AirlineRefusedSummaryData();
            summaryData.groupName = airline;
            summaryDataList.add(summaryData);
        }
        this.updateAirlineRefusedSummaryData(summaryData, currentRow, globalData);
    }

    protected abstract List<Integer> getExcludedSumColumns(int var1, Map<String, Object> var2);

    protected abstract void fillRow(HSSFSheet var1, int var2, int var3, AgentReportTicket var4, int var5, Map<String, Object> var6) throws Exception;

    protected abstract int getSectionEndColumn(int var1, Map<String, Object> var2);

    protected abstract int getSectionBeginColumn(int var1, Map<String, Object> var2);

    protected abstract int getSectionRowNumber(int var1, HSSFSheet var2) throws Exception;

    protected abstract void addColumns(HSSFSheet var1, Map<String, Object> var2) throws Exception;

    protected abstract void updateAirlineSummaryData(AirlineSummaryData var1, int var2, Map<String, Object> var3, int var4);

    protected abstract void updateAirlineRefusedSummaryData(AirlineRefusedSummaryData var1, int var2, Map<String, Object> var3);

    protected String buildNotes(AgentReportTicket ticket) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)ticket.getRemarks())) {
            sb.append(ticket.getRemarks());
        }
        if (ticket.getStatus() == ProductStatus.VOID) {
            sb.append(sb.length() > 0 ? ", " : "").append(L10nResourcesManager.createL10nMessage((String)Messages.BaseSellRefundWorksheetHandler_voided, (Object[])new Object[0]).toString());
        } else if (!TextUtil.isBlank((String)ticket.getRelatedSellNumber())) {
            sb.append(sb.length() > 0 ? ", " : "").append(L10nResourcesManager.createL10nMessage((String)Messages.BaseSellRefundWorksheetHandler_inExchangeFor, (Object[])new Object[]{ticket.getRelatedSellNumber()}).toString());
        }
        return sb.length() > 0 ? sb.toString().trim() : null;
    }

    protected String getFormula(String initFormula, String sheetTitle, int row, int column) {
        return String.format("%s%s!%s%s", !TextUtil.isBlank((String)initFormula) ? initFormula + "+" : "", sheetTitle, String.valueOf((char)(64 + column)), Integer.toString(row));
    }
}

