/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineRefusedSummaryData;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineSummaryData;
import com.gridnine.xtrip.common.reports.render.agentreport.BaseSellRefundWorksheetHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class MCOFeesWorksheetHandler
extends BaseSellRefundWorksheetHandler {
    private static final String SHEET_TITLE = L10nResourcesManager.createL10nMessage((String)Messages.MCOFeesWorksheetHandler_title, (Object[])new Object[0]).toString();

    private List<AgentReportTicket.PaymentTypeInfo> getActualPaymentTypes(Map<String, Object> globalData) {
        ArrayList<AgentReportTicket.PaymentTypeInfo> res = new ArrayList<AgentReportTicket.PaymentTypeInfo>();
        List types = (List)globalData.get("ACTUAL_MCO_FEES_PAYMENT_TYPES");
        for (PaymentType pt : types) {
            AgentReportTicket.PaymentTypeInfo pti = new AgentReportTicket.PaymentTypeInfo();
            pti.setPayed(true);
            pti.setPaymentType(pt);
            res.add(pti);
        }
        return res;
    }

    @Override
    protected List<Integer> getExcludedSumColumns(int sectionNumber, Map<String, Object> globalData) {
        return Collections.emptyList();
    }

    @Override
    protected void fillRow(HSSFSheet sheet, int sectionNumber, int currentRow, AgentReportTicket ticket, int n, Map<String, Object> globalData) throws Exception {
        AgentReportTicket.PaymentTypeInfo key;
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)2, (int)(n + 1));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)3, (String)ticket.getTicketSeries());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)4, (String)ticket.getTicketNumber());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)5, (String)ticket.getAirTicketNumbers());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)6, (String)ticket.getRouteLine());
        String notes = this.buildNotes(ticket);
        boolean notesColumn = false;
        BigDecimal total = BigDecimal.ZERO;
        for (AgentReportTicket.PaymentTypeInfo pti : ticket.getTotals().keySet()) {
            if (ticket.getTotals().get(pti) == null) continue;
            total = total.add(ticket.getTotals().get(pti));
        }
        String fop = "";
        if (ticket.getTotals().keySet().size() == 1 && (key = ticket.getTotals().keySet().iterator().next()).getPaymentType() != null) {
            fop = key.getPaymentType().toString();
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)7, (BigDecimal)total, (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)8, (String)fop);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)9, (String)notes);
    }

    @Override
    protected int getSectionEndColumn(int sectionNumber, Map<String, Object> globalData) {
        return 5 + 2 * this.getActualPaymentTypes(globalData).size();
    }

    @Override
    protected int getSectionBeginColumn(int sectionNumber, Map<String, Object> globalData) {
        return 6;
    }

    @Override
    protected int getSectionRowNumber(int sectionNumber, HSSFSheet sheet) throws Exception {
        String cellName = "SELL_SECTION";
        HSSFCell cell1 = ExcelUtils.findCell((HSSFSheet)sheet, (String)cellName);
        if (cell1 == null) {
            throw new Exception(L10nResourcesManager.createL10nMessage((String)"MCOFeesWorksheet_cellNotFound", (Object[])new Object[]{cellName, SHEET_TITLE}).toString());
        }
        return cell1.getRowIndex() + 1;
    }

    @Override
    protected void addColumns(HSSFSheet sheet, Map<String, Object> globalData) throws Exception {
    }

    @Override
    protected void updateAirlineSummaryData(AirlineSummaryData summaryData, int currentRow, Map<String, Object> globalData, int sectionNumber) {
        List<AgentReportTicket.PaymentTypeInfo> actualPaymentTypes = this.getActualPaymentTypes(globalData);
        for (int n = 0; n < actualPaymentTypes.size(); ++n) {
            AgentReportTicket.PaymentTypeInfo ptype = actualPaymentTypes.get(n);
            summaryData.totalSellFormulas.put(ptype, this.getFormula(summaryData.totalSellFormulas.get(ptype), SHEET_TITLE, currentRow, 7 + n * 2));
        }
    }

    @Override
    protected void updateAirlineRefusedSummaryData(AirlineRefusedSummaryData summaryData, int currentRow, Map<String, Object> globalData) {
    }
}

