/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineRefusedSummaryData;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineSummaryData;
import com.gridnine.xtrip.common.reports.render.agentreport.BaseSellRefundWorksheetHandler;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.util.CellRangeAddress;

class SellWorksheetHandler
extends BaseSellRefundWorksheetHandler {
    private static final String SHEET_TITLE = L10nResourcesManager.createL10nMessage((String)Messages.SellWorksheetHandler_title, (Object[])new Object[0]).toString();

    SellWorksheetHandler() {
    }

    private List<AgentReportTicket.PaymentTypeInfo> getActualPaymentTypes(Map<String, Object> globalData) {
        return (List)globalData.get("ACTUAL_SELL_PAYMENT_TYPES");
    }

    private List<PaymentType> getActualPayedAfterPaymentTypes(Map<String, Object> globalData) {
        return (List)globalData.get("ACTUAL_SELL_PAYED_AFTER_PAYMENT_TYPES");
    }

    private List<PaymentType> getActualRefusedPaymentTypes(Map<String, Object> globalData) {
        return (List)globalData.get("ACTUAL_SELL_REFUSED_PAYMENT_TYPES");
    }

    @Override
    protected void addColumns(HSSFSheet sheet, Map<String, Object> globalData) throws Exception {
        int n;
        int row;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)1, (int)2, (String)"=\u041a\u0430\u0441\u0441\u0430!B1");
        HSSFCell cell = ExcelUtils.findCell((HSSFSheet)sheet, (String)"SELL_SECTION");
        List<AgentReportTicket.PaymentTypeInfo> actualPaymentTypes = this.getActualPaymentTypes(globalData);
        if (actualPaymentTypes.size() > 0) {
            row = cell.getRowIndex();
            for (n = 0; n < actualPaymentTypes.size() - 1; ++n) {
                ExcelUtils.copyColumns((HSSFSheet)sheet, (int)(9 + n * 2), (int)(10 + n * 2), (int)(row - 3), (int)(row + 2));
            }
            for (n = 0; n < actualPaymentTypes.size(); ++n) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(row - 1), (int)(10 + n * 2), (String)AgentReportTicket.getName(actualPaymentTypes.get(n)));
            }
            sheet.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(row - 3, row - 3, 9, 8 + (actualPaymentTypes.size() > 0 ? actualPaymentTypes.size() : 1) * 2));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(row - 2), (int)10, (String)L10nResourcesManager.createL10nMessage((String)Messages.SellWorksheetHandler_totalByFop, (Object[])new Object[0]).toString());
            ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)(row - 2), (int)10).setAlignment((short)2);
        }
        cell = ExcelUtils.findCell((HSSFSheet)sheet, (String)"SELL_ISSUED_BEFORE_SECTION");
        actualPaymentTypes = this.getActualPayedAfterPaymentTypes(globalData);
        row = cell.getRowIndex();
        for (n = 0; n < actualPaymentTypes.size() - 1; ++n) {
            ExcelUtils.copyColumns((HSSFSheet)sheet, (int)(10 + n * 2), (int)(10 + n * 2), (int)(row - 4), (int)(row + 2));
        }
        for (n = 0; n < actualPaymentTypes.size(); ++n) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(row - 1), (int)(11 + n * 2), (String)AgentReportTicket.getName((PaymentType)actualPaymentTypes.get(n)));
        }
        sheet.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(row - 3, row - 3, 10, 9 + (actualPaymentTypes.size() > 0 ? actualPaymentTypes.size() : 1) * 2));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(row - 2), (int)11, (String)L10nResourcesManager.createL10nMessage((String)Messages.SellWorksheetHandler_totalByFop, (Object[])new Object[0]).toString());
        ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)(row - 2), (int)11).setAlignment((short)2);
        if (actualPaymentTypes.size() == 0) {
            for (n = row - 4; n <= row + 2; ++n) {
                sheet.getRow(n).setHeight((short)0);
            }
        }
        cell = ExcelUtils.findCell((HSSFSheet)sheet, (String)"SELL_REFUSED_SECTION");
        actualPaymentTypes = this.getActualRefusedPaymentTypes(globalData);
        row = cell.getRowIndex();
        for (n = 0; n < actualPaymentTypes.size() - 1; ++n) {
            ExcelUtils.copyColumns((HSSFSheet)sheet, (int)(10 + n * 2), (int)(10 + n * 2), (int)(row - 4), (int)(row + 2));
        }
        for (n = 0; n < actualPaymentTypes.size(); ++n) {
            PaymentType paymentType = (PaymentType)actualPaymentTypes.get(n);
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(false);
            info.setPaymentType(paymentType);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(row - 1), (int)(11 + n * 2), (String)AgentReportTicket.getName(info));
        }
        sheet.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(row - 3, row - 3, 10, 9 + (actualPaymentTypes.size() > 0 ? actualPaymentTypes.size() : 1) * 2));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(row - 2), (int)11, (String)L10nResourcesManager.createL10nMessage((String)Messages.SellWorksheetHandler_totalByFop, (Object[])new Object[0]).toString());
        ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)(row - 2), (int)11).setAlignment((short)2);
        if (actualPaymentTypes.size() == 0) {
            for (n = row - 4; n <= row + 2; ++n) {
                sheet.getRow(n).setHeight((short)0);
            }
        }
    }

    @Override
    protected void fillRow(HSSFSheet sheet, int sectionNumber, int currentRow, AgentReportTicket ticket, int n, Map<String, Object> globalData) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)2, (int)(n + 1));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)3, (String)ticket.getTicketSeries());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)4, (String)ticket.getTicketNumber());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)5, (String)ticket.getRouteLine());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)6, (BigDecimal)ticket.getEquivalentFare(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)7, (BigDecimal)ticket.getOtherTaxesAmount(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)8, (BigDecimal)ticket.getRuTaxAmount(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)9, (BigDecimal)ticket.getPenaltyAmount(), (boolean)true);
        String notes = this.buildNotes(ticket);
        int notesColumn = 0;
        switch (sectionNumber) {
            case 1: {
                List<AgentReportTicket.PaymentTypeInfo> paymentTypes = this.getActualPaymentTypes(globalData);
                for (int m = 0; m < paymentTypes.size(); ++m) {
                    AgentReportTicket.PaymentTypeInfo ptype = paymentTypes.get(m);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(10 + m * 2), (BigDecimal)ticket.getTotals().get(ptype), (boolean)true);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(10 + m * 2 + 1), (BigDecimal)ticket.getFees().get(ptype), (boolean)true);
                }
                notesColumn = 10 + 2 * (paymentTypes.size() > 0 ? paymentTypes.size() : 1);
                break;
            }
            case 2: {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)10, (Date)ticket.getIssueDate());
                List<PaymentType> paymentTypes = this.getActualPayedAfterPaymentTypes(globalData);
                for (int m = 0; m < paymentTypes.size(); ++m) {
                    PaymentType pType = paymentTypes.get(m);
                    AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
                    info.setPayed(true);
                    info.setPaymentType(pType);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(11 + m * 2), (BigDecimal)ticket.getTotals().get(info), (boolean)true);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(12 + m * 2), (BigDecimal)ticket.getFees().get(info), (boolean)true);
                }
                notesColumn = 11 + (paymentTypes.size() > 0 ? paymentTypes.size() : 1) * 2;
                break;
            }
            default: {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)10, (Date)ticket.getIssueDate());
                List<PaymentType> paymentTypes = this.getActualRefusedPaymentTypes(globalData);
                for (int m = 0; m < paymentTypes.size(); ++m) {
                    PaymentType pType = paymentTypes.get(m);
                    AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
                    info.setPayed(false);
                    info.setPaymentType(pType);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(11 + m * 2), (BigDecimal)ticket.getTotals().get(info), (boolean)true);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(12 + m * 2), (BigDecimal)ticket.getFees().get(info), (boolean)true);
                }
                notesColumn = 11 + (paymentTypes.size() > 0 ? paymentTypes.size() : 1) * 2;
            }
        }
        if (notes != null) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)notesColumn, (String)notes);
        }
    }

    @Override
    protected List<Integer> getExcludedSumColumns(int sectionNumber, Map<String, Object> globalData) {
        switch (sectionNumber) {
            case 1: {
                return Collections.emptyList();
            }
        }
        return Collections.singletonList(10);
    }

    @Override
    protected int getSectionBeginColumn(int sectionNumber, Map<String, Object> globalData) {
        return 6;
    }

    @Override
    protected int getSectionEndColumn(int sectionNumber, Map<String, Object> globalData) {
        switch (sectionNumber) {
            case 1: {
                return 9 + 2 * this.getActualPaymentTypes(globalData).size();
            }
            case 2: {
                return 10 + this.getActualPayedAfterPaymentTypes(globalData).size() * 2;
            }
        }
        return 10 + this.getActualRefusedPaymentTypes(globalData).size() * 2;
    }

    @Override
    protected int getSectionRowNumber(int sectionNumber, HSSFSheet sheet) throws Exception {
        String cellName = null;
        switch (sectionNumber) {
            case 1: {
                cellName = "SELL_SECTION";
                break;
            }
            case 2: {
                cellName = "SELL_ISSUED_BEFORE_SECTION";
                break;
            }
            default: {
                cellName = "SELL_REFUSED_SECTION";
            }
        }
        HSSFCell cell1 = ExcelUtils.findCell((HSSFSheet)sheet, (String)cellName);
        if (cell1 == null) {
            throw new Exception(L10nResourcesManager.createL10nMessage((String)Messages.SellWorksheet_cellNotFound, (Object[])new Object[]{cellName, SHEET_TITLE}).toString());
        }
        return cell1.getRowIndex() + 1;
    }

    @Override
    protected void updateAirlineRefusedSummaryData(AirlineRefusedSummaryData summaryData, int currentRow, Map<String, Object> globalData) {
        List<PaymentType> actualPaymentTypes = this.getActualRefusedPaymentTypes(globalData);
        for (int n = 0; n < actualPaymentTypes.size(); ++n) {
            PaymentType ptype = actualPaymentTypes.get(n);
            summaryData.totalSellRefusedFormulas.put(ptype, this.getFormula(summaryData.totalSellRefusedFormulas.get(ptype), SHEET_TITLE, currentRow, 11 + n * 2));
            summaryData.feesSellRefusedFormulas.put(ptype, this.getFormula(summaryData.feesSellRefusedFormulas.get(ptype), SHEET_TITLE, currentRow, 12 + n * 2));
        }
    }

    @Override
    protected void updateAirlineSummaryData(AirlineSummaryData summaryData, int currentRow, Map<String, Object> globalData, int sectionNumber) {
        switch (sectionNumber) {
            case 1: {
                List<AgentReportTicket.PaymentTypeInfo> actualPaymentTypes = this.getActualPaymentTypes(globalData);
                for (int n = 0; n < actualPaymentTypes.size(); ++n) {
                    AgentReportTicket.PaymentTypeInfo ptype = actualPaymentTypes.get(n);
                    summaryData.totalSellFormulas.put(ptype, this.getFormula(summaryData.totalSellFormulas.get(ptype), SHEET_TITLE, currentRow, 10 + n * 2));
                    summaryData.feesSellFormulas.put(ptype, this.getFormula(summaryData.feesSellFormulas.get(ptype), SHEET_TITLE, currentRow, 10 + n * 2 + 1));
                }
                break;
            }
            default: {
                List<PaymentType> actualPaymentTypes = this.getActualPayedAfterPaymentTypes(globalData);
                for (int n = 0; n < actualPaymentTypes.size(); ++n) {
                    PaymentType ptype = actualPaymentTypes.get(n);
                    summaryData.totalSellIssuedBeforeFormulas.put(ptype, this.getFormula(summaryData.totalSellIssuedBeforeFormulas.get(ptype), SHEET_TITLE, currentRow, 11 + n * 2));
                    summaryData.feesSellIssuedBeforeFormulas.put(ptype, this.getFormula(summaryData.feesSellIssuedBeforeFormulas.get(ptype), SHEET_TITLE, currentRow, 12 + n * 2));
                }
            }
        }
    }
}

