/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineRefusedSummaryData;
import com.gridnine.xtrip.common.reports.render.agentreport.AirlineSummaryData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;

class SummaryWorksheetHandler
extends BasePoiWorksheetHandler<AgentReportTicket> {
    SummaryWorksheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<AgentReportTicket> data, Map<String, Object> globalData) throws Exception {
        int n;
        super.fill(wb, sheet, data, globalData);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_NUMBER", (String)((String)globalData.get("REPORT_NUMBER")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"SALES_POINTS_NAMES", (String)((String)globalData.get("KEY_ACTUAL_SALES_POINTS")));
        HSSFCell cell1 = ExcelUtils.findCell((HSSFSheet)sheet, (String)"SUMMARY_PAYED_SECTION");
        if (cell1 == null) {
            throw new Exception(L10nResourcesManager.createL10nMessage((String)Messages.SummaryWorksheet_cellNotFound1, (Object[])new Object[0]).toString());
        }
        List actualSellPaymentTypes = (List)globalData.get("ACTUAL_SELL_PAYMENT_TYPES");
        List actualRefundPaymentTypes = (List)globalData.get("ACTUAL_REFUND_PAYMENT_TYPES");
        HashSet<AgentReportTicket.PaymentTypeInfo> types = new HashSet<AgentReportTicket.PaymentTypeInfo>();
        types.addAll(actualRefundPaymentTypes);
        types.addAll(actualSellPaymentTypes);
        List actualSellPayedAfterPaymentTypes = (List)globalData.get("ACTUAL_SELL_PAYED_AFTER_PAYMENT_TYPES");
        for (Object pType : actualSellPayedAfterPaymentTypes) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(true);
            info.setPaymentType((PaymentType)pType);
            types.add(info);
        }
        List actualRefundPayedAfterPaymentTypes = (List)globalData.get("ACTUAL_REFUND_PAYED_AFTER_PAYMENT_TYPES");
        for (Object pType : actualRefundPayedAfterPaymentTypes) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(true);
            info.setPaymentType((PaymentType)pType);
            types.add(info);
        }
        List actualSellRefusedPaymentTypes = (List)globalData.get("ACTUAL_SELL_REFUSED_PAYMENT_TYPES");
        for (Object pType : actualSellRefusedPaymentTypes) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(false);
            info.setPaymentType((PaymentType)pType);
            types.add(info);
        }
        List actualRefundRefusedPaymentTypes = (List)globalData.get("ACTUAL_SELL_REFUSED_PAYMENT_TYPES");
        for (PaymentType pType : actualRefundRefusedPaymentTypes) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(false);
            info.setPaymentType(pType);
            types.add(info);
        }
        ArrayList<AgentReportTicket.PaymentTypeInfo> actualPaymentTypes = new ArrayList<AgentReportTicket.PaymentTypeInfo>(types);
        Collections.sort(actualPaymentTypes, AgentReportTicket.paymentTypeInfosComparator);
        HSSFCell totalSectionCell = ExcelUtils.findCell((HSSFSheet)sheet, (String)"SUMMARY_TOTAL_SECTION");
        if (totalSectionCell == null) {
            throw new Exception(L10nResourcesManager.createL10nMessage((String)Messages.SummaryWorksheet_cellNotFound1, (Object[])new Object[0]).toString());
        }
        int totalSectonFirstRowIndex = totalSectionCell.getRowIndex();
        for (n = 0; n < actualPaymentTypes.size() - 1; ++n) {
            ExcelUtils.copyColumns((HSSFSheet)sheet, (int)(4 + 2 * n), (int)(5 + 2 * n), (int)9, (int)(totalSectonFirstRowIndex + 1));
        }
        for (n = 10; n <= totalSectonFirstRowIndex + 2; ++n) {
            if (n == 25) continue;
            ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)n, (int)(4 + actualPaymentTypes.size() * 2)).setBorderRight((short)2);
        }
        StringBuilder sbPlus = new StringBuilder();
        StringBuilder sbMinus = new StringBuilder();
        StringBuilder cashed = new StringBuilder();
        for (int n2 = 0; n2 < actualPaymentTypes.size(); ++n2) {
            AgentReportTicket.PaymentTypeInfo info = (AgentReportTicket.PaymentTypeInfo)actualPaymentTypes.get(n2);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)11, (int)(5 + n2 * 2), (String)AgentReportTicket.getName(info));
            if (!info.isPayed()) continue;
            sbPlus.append("+" + String.valueOf((char)(69 + 2 * n2)) + (totalSectonFirstRowIndex + 1));
            sbPlus.append("+" + String.valueOf((char)(70 + 2 * n2)) + (totalSectonFirstRowIndex + 1));
            sbMinus.append("+" + String.valueOf((char)(69 + 2 * n2)) + (totalSectonFirstRowIndex + 2));
            sbMinus.append("+" + String.valueOf((char)(70 + 2 * n2)) + (totalSectonFirstRowIndex + 2));
            if (info.getPaymentType() != PaymentType.CASH) continue;
            cashed.append(String.valueOf((char)(69 + 2 * n2)) + (totalSectonFirstRowIndex + 1));
            cashed.append("+");
            cashed.append(String.valueOf((char)(70 + 2 * n2)) + (totalSectonFirstRowIndex + 1));
            cashed.append("+");
            cashed.append(String.valueOf((char)(69 + 2 * n2)) + (totalSectonFirstRowIndex + 2));
            cashed.append("+");
            cashed.append(String.valueOf((char)(70 + 2 * n2)) + (totalSectonFirstRowIndex + 2));
        }
        sheet.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(9, 9, 4, 3 + actualPaymentTypes.size() * 2));
        sheet.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(25, 25, 4, 3 + actualPaymentTypes.size() * 2));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)10, (int)5, (String)L10nResourcesManager.createL10nMessage((String)Messages.SummaryWorksheetHandler_sumByFop, (Object[])new Object[0]).toString());
        ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)10, (int)5).setAlignment((short)2);
        if (types.size() == 1) {
            sheet.getRow(9).setHeight((short)(2 * sheet.getRow(9).getHeight()));
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)26, (int)5, (String)L10nResourcesManager.createL10nMessage((String)Messages.SummaryWorksheetHandler_including, (Object[])new Object[0]).toString());
        ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)26, (int)5).setAlignment((short)2);
        if (sbPlus.length() > 0) {
            HSSFCell cell = sheet.getRow(totalSectonFirstRowIndex).getCell(3);
            String prefix = "=";
            if (cell != null && cell.getCellType() == 2) {
                prefix = cell.getCellFormula();
            }
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)(totalSectonFirstRowIndex + 1), (int)4, (String)(prefix + sbPlus.toString()));
        }
        if (sbMinus.length() > 0) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)(totalSectonFirstRowIndex + 2), (int)4, (String)("=" + sbMinus.toString()));
        }
        if (cashed.length() > 0) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)(totalSectonFirstRowIndex + 4), (int)5, (String)("=" + cashed.toString()));
        }
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)(totalSectonFirstRowIndex + 5), (int)5, (String)String.format("=E7%s-E%s", cashed.length() > 0 ? "+" + cashed.toString() : "", Integer.toString(totalSectonFirstRowIndex + 4)));
        int rowIndex = cell1.getRowIndex();
        int currentRow = rowIndex + 1;
        ArrayList<Integer> sellTotals = new ArrayList<Integer>();
        ArrayList<Integer> refundTotals = new ArrayList<Integer>();
        List summaryDataList = (List)globalData.get("key-airline-summary-data");
        if (summaryDataList != null) {
            for (int n3 = 1; n3 < summaryDataList.size(); ++n3) {
                ExcelUtils.copyRows((HSSFSheet)sheet, (int)rowIndex, (int)(rowIndex + 6));
            }
            for (AirlineSummaryData summaryData : summaryDataList) {
                int index;
                AgentReportTicket.PaymentTypeInfo info;
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)2, (String)summaryData.groupName);
                ++currentRow;
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.totalSellFormulas.entrySet()) {
                    info = entry.getKey();
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2), (String)entry.getValue());
                }
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.feesSellFormulas.entrySet()) {
                    info = entry.getKey();
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2 + 1), (String)entry.getValue());
                }
                ++currentRow;
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.totalSellIssuedBeforeFormulas.entrySet()) {
                    info = new AgentReportTicket.PaymentTypeInfo();
                    info.setPayed(true);
                    info.setPaymentType((PaymentType)entry.getKey());
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2), (String)entry.getValue());
                }
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.feesSellIssuedBeforeFormulas.entrySet()) {
                    info = new AgentReportTicket.PaymentTypeInfo();
                    info.setPayed(true);
                    info.setPaymentType((PaymentType)entry.getKey());
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2 + 1), (String)entry.getValue());
                }
                sellTotals.add(++currentRow);
                for (int n4 = 5; n4 <= 4 + actualPaymentTypes.size() * 2; ++n4) {
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)n4, (String)String.format("%s%s+%1$s%s", String.valueOf((char)(64 + n4)), Integer.toString(currentRow - 2), Integer.toString(currentRow - 1)));
                }
                ++currentRow;
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.totalRefundFormulas.entrySet()) {
                    info = entry.getKey();
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2), (String)entry.getValue());
                }
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.feesRefundFormulas.entrySet()) {
                    info = entry.getKey();
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2 + 1), (String)entry.getValue());
                }
                ++currentRow;
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.totalRefundIssuedBeforeFormulas.entrySet()) {
                    info = new AgentReportTicket.PaymentTypeInfo();
                    info.setPayed(true);
                    info.setPaymentType((PaymentType)entry.getKey());
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2), (String)entry.getValue());
                }
                for (Map.Entry<AgentReportTicket.PaymentTypeInfo, String> entry : summaryData.feesRefundIssuedBeforeFormulas.entrySet()) {
                    info = new AgentReportTicket.PaymentTypeInfo();
                    info.setPayed(true);
                    info.setPaymentType((PaymentType)entry.getKey());
                    index = actualPaymentTypes.indexOf(info);
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2 + 1), (String)entry.getValue());
                }
                ++currentRow;
                for (int n5 = 5; n5 <= 4 + actualPaymentTypes.size() * 2; ++n5) {
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)n5, (String)String.format("%s%s+%1$s%s", String.valueOf((char)(64 + n5)), Integer.toString(currentRow - 2), Integer.toString(currentRow - 1)));
                }
                refundTotals.add(currentRow);
                ++currentRow;
            }
        }
        this.fillRefusedSection(sheet, globalData, actualPaymentTypes);
        currentRow = totalSectionCell.getRowIndex() + 1;
        this.updateTotals(sheet, currentRow, sellTotals, actualPaymentTypes.size());
        this.updateTotals(sheet, ++currentRow, refundTotals, actualPaymentTypes.size());
    }

    private void fillRefusedSection(HSSFSheet sheet, Map<String, Object> globalData, ArrayList<AgentReportTicket.PaymentTypeInfo> actualPaymentTypes) throws Exception {
        HSSFCell cell3 = ExcelUtils.findCell((HSSFSheet)sheet, (String)"SUMMARY_REFUSED_SECTION");
        if (cell3 == null) {
            throw new Exception(L10nResourcesManager.createL10nMessage((String)Messages.SummaryWorksheet_cellNotFound3, (Object[])new Object[0]).toString());
        }
        List summaryDataList = (List)globalData.get("key-airline-refused-summary-data");
        if (summaryDataList == null || summaryDataList.size() == 0) {
            for (int n = cell3.getRowIndex() - 1; n <= cell3.getRowIndex() + 3; ++n) {
                sheet.getRow(n).setHeight((short)0);
            }
            return;
        }
        int currentRow = cell3.getRowIndex() + 1;
        for (int n = 1; n < summaryDataList.size(); ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)currentRow, (int)(currentRow + 3));
        }
        for (AirlineRefusedSummaryData summaryData : summaryDataList) {
            int index;
            AgentReportTicket.PaymentTypeInfo info;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)2, (String)summaryData.groupName);
            ++currentRow;
            for (Map.Entry<PaymentType, String> entry : summaryData.totalSellRefusedFormulas.entrySet()) {
                info = new AgentReportTicket.PaymentTypeInfo();
                info.setPayed(false);
                info.setPaymentType(entry.getKey());
                index = actualPaymentTypes.indexOf(info);
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2), (String)entry.getValue());
            }
            for (Map.Entry<PaymentType, String> entry : summaryData.feesSellRefusedFormulas.entrySet()) {
                info = new AgentReportTicket.PaymentTypeInfo();
                info.setPayed(false);
                info.setPaymentType(entry.getKey());
                index = actualPaymentTypes.indexOf(info);
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2 + 1), (String)entry.getValue());
            }
            ++currentRow;
            for (Map.Entry<PaymentType, String> entry : summaryData.totalRefundRefusedFormulas.entrySet()) {
                info = new AgentReportTicket.PaymentTypeInfo();
                info.setPayed(false);
                info.setPaymentType(entry.getKey());
                index = actualPaymentTypes.indexOf(info);
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2), (String)entry.getValue());
            }
            for (Map.Entry<PaymentType, String> entry : summaryData.feesRefundRefusedFormulas.entrySet()) {
                info = new AgentReportTicket.PaymentTypeInfo();
                info.setPayed(false);
                info.setPaymentType(entry.getKey());
                index = actualPaymentTypes.indexOf(info);
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)(5 + index * 2 + 1), (String)entry.getValue());
            }
            ++currentRow;
            for (int n = 5; n <= 4 + actualPaymentTypes.size() * 2; ++n) {
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)n, (String)String.format("%s%s+%1$s%s", String.valueOf((char)(64 + n)), Integer.toString(currentRow - 2), Integer.toString(currentRow - 1)));
            }
            ++currentRow;
        }
    }

    private void updateTotals(HSSFSheet sheet, int currentRow, List<Integer> sellTotals, int paymentTypesCount) throws Exception {
        for (int n = 5; n <= 4 + 2 * paymentTypesCount; ++n) {
            StringBuilder totalExpression = new StringBuilder();
            for (Integer index : sellTotals) {
                totalExpression.append(totalExpression.length() == 0 ? "" : "+");
                totalExpression.append(String.format("%s%s", String.valueOf((char)(64 + n)), Integer.toString(index)));
            }
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)n, (String)totalExpression.toString());
        }
    }
}

