/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport.clientdebt;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportDocument;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.ReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.agentreport.clientdebt.WorksheetHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ClientDebtReportRenderHandler
implements ReportRenderHandler {
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ClientDebtReportDocument.class);
        ((ClientDebtReportDocument)result.getEntity()).setFile(file);
        List messages = (List)data.get("key-messages");
        ((ClientDebtReportDocument)result.getEntity()).getMessages().addAll(messages);
        ClientDebtReportParameters reportParameters = (ClientDebtReportParameters)data.get("key-report-params");
        reportParameters.getVendors().clear();
        reportParameters.getVendors().addAll((Set)data.get("ACTUAL_VENDORS"));
        ((ClientDebtReportDocument)result.getEntity()).setParameters(reportParameters);
        return result;
    }

    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        File result = IoUtil.url2file((URL)BasePoiReportRenderHandler.class.getResource("/agentreports/ClientDebtReportTemplate.xls"));
        if (!result.exists() || !result.canRead()) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.ClientDebtReportRenderHandler_unableToLoadTemplate, (Object[])new Object[]{result.getCanonicalPath()}).toString());
        }
        return IoUtil.getResourceInputStream((File)result);
    }

    protected String getReportTitle(Map<String, Object> data) {
        String postfix = (String)data.get("KEY_REPORT_FILENAME");
        return L10nResourcesManager.createL10nMessage((String)Messages.ClientDebtReportRenderHandler_reportTitle, (Object[])new Object[]{postfix}).toString();
    }

    @Override
    public String getId() {
        return "agent-client-debt-report";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityContainer<? extends BaseReportDocument> renderReport(Map<String, Object> data) throws Exception {
        try (InputStream is = this.getInputStream(data);){
            EntityContainer<? extends BaseReportDocument> entityContainer;
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                this.prepareReport(wb, data);
                wb.write((OutputStream)os);
                ReportFile file = new ReportFile();
                String reportTitle = this.getReportTitle(data);
                file.setTitle("" + reportTitle);
                file.setContentType(ContentType.EXCEL);
                file.setContent(os.toByteArray());
                String value = "" + reportTitle + ".xls";
                file.setName(value.replaceAll("\"", ""));
                EntityContainer<? extends BaseReportDocument> result = this.createContainer(file, data);
                ((BaseReportDocument)result.getEntity()).setCreated(new Date());
                entityContainer = result;
            }
            catch (Throwable throwable) {
                os.close();
                throw throwable;
            }
            os.close();
            return entityContainer;
        }
    }

    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        List messages = (List)data.get("key-messages");
        WorksheetHandler handler = new WorksheetHandler();
        if (wb.getNumberOfSheets() > 0) {
            HSSFSheet sheet = wb.getSheetAt(0);
            handler.fill(wb, sheet, null, data);
            wb.setActiveSheet(0);
            wb.setSelectedTab(0);
        } else {
            SystemHelper.addMessage((Collection)messages, (String)Messages.ClientDebtReportRenderHandler_noSheetsInTemplate, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
        }
    }
}

