/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport.clientdebt;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.agentreport.clientdebt.ClientDebtData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class WorksheetHandler
extends BasePoiWorksheetHandler<BaseReportTicket> {
    private HSSFSheet sheet;
    private final PaymentType[] eligiblePaymentTypes = new PaymentType[]{PaymentType.CASH, PaymentType.INVOICE, PaymentType.CREDIT_CARD};
    private static final int FirstRow = 10;
    private int currentRow;
    private int currentSectionStartRow;
    private final String[][] grandTotalSumFormulas = new String[this.eligiblePaymentTypes.length][3];
    private final Comparator<ClientDebtData> clientDebtComp = new Comparator<ClientDebtData>(){

        @Override
        public int compare(ClientDebtData o1, ClientDebtData o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (!TextUtil.isBlank((String)o1.getVendorName()) && TextUtil.isBlank((String)o2.getVendorName())) {
                return 1;
            }
            if (TextUtil.isBlank((String)o1.getVendorName()) && !TextUtil.isBlank((String)o2.getVendorName())) {
                return -1;
            }
            int vendorComp = 0;
            vendorComp = TextUtil.isBlank((String)o1.getVendorName()) && TextUtil.isBlank((String)o2.getVendorName()) ? 0 : o1.getVendorName().compareTo(o2.getVendorName());
            if (vendorComp == 0) {
                if (!TextUtil.isBlank((String)o1.getClientName()) && TextUtil.isBlank((String)o2.getClientName())) {
                    return 1;
                }
                if (TextUtil.isBlank((String)o1.getClientName()) && !TextUtil.isBlank((String)o2.getClientName())) {
                    return -1;
                }
                if (TextUtil.isBlank((String)o1.getClientName()) && TextUtil.isBlank((String)o2.getClientName())) {
                    return 0;
                }
                int clientComp = o1.getClientName().compareTo(o2.getClientName());
                if (clientComp == 0) {
                    return o1.getSign() - o2.getSign();
                }
                return clientComp;
            }
            return vendorComp;
        }
    };

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        this.sheet = sheet;
        ExcelUtils.replace((HSSFSheet)sheet, (String)"SUBAGENCY_TITLE", (String)((String)globalData.get("SUBAGENCY_TITLE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"SALEPOINT_ADDRESS", (String)((String)globalData.get("SALEPOINT_ADDRESS")));
        Map clientDebtDataList = (Map)globalData.get("key-batch-data-list");
        if (clientDebtDataList == null || clientDebtDataList.values().isEmpty()) {
            return;
        }
        ArrayList workingList = new ArrayList(clientDebtDataList.values());
        Collections.sort(workingList, this.clientDebtComp);
        String currentVendor = ((ClientDebtData)workingList.get(0)).getVendorName();
        this.addNewSection(currentVendor, 10);
        for (ClientDebtData item : workingList) {
            if (!item.getVendorName().equals(currentVendor)) {
                currentVendor = item.getVendorName();
                this.removeCurrentRow();
                this.addSubTotalSum();
                this.addNewSection(currentVendor, this.currentRow + 2);
            }
            this.addRow(sheet, item);
        }
        this.removeCurrentRow();
        this.addSubTotalSum();
        this.removeTempSection();
        this.addGrandTotalSum(sheet);
    }

    private void addNewSection(String vendor, int sectionStart) throws Exception {
        this.currentSectionStartRow = sectionStart;
        ExcelUtils.copyRows((HSSFSheet)this.sheet, (int)(this.currentSectionStartRow - 1), (int)(this.currentSectionStartRow + 1));
        ExcelUtils.setCellValue((HSSFSheet)this.sheet, (int)this.currentSectionStartRow, (int)1, (int)1, (int)1, (String)vendor);
        this.currentRow = this.currentSectionStartRow + 1;
    }

    private void removeTempSection() {
        int tempSectionStartRow = this.currentRow + 2;
        ArrayList<Integer> mergedRegionsIndexes = new ArrayList<Integer>();
        for (int n = 0; n < this.sheet.getNumMergedRegions(); ++n) {
            CellRangeAddress mergedRegion = this.sheet.getMergedRegion(n);
            if (mergedRegion.getFirstRow() < tempSectionStartRow - 1 || mergedRegion.getLastRow() > tempSectionStartRow + 2) continue;
            mergedRegionsIndexes.add(n);
        }
        for (Integer index : mergedRegionsIndexes) {
            this.sheet.removeMergedRegion(index.intValue());
        }
        for (int i = 0; i < 3; ++i) {
            ExcelUtils.removeRow((HSSFSheet)this.sheet, (int)(tempSectionStartRow - 1));
        }
    }

    private void addRow(HSSFSheet sheet, ClientDebtData debtData) throws Exception {
        ExcelUtils.copyRows((HSSFSheet)sheet, (int)(this.currentRow - 1), (int)(this.currentRow - 1));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)1, (String)debtData.getClientName());
        for (int i = 0; i < this.eligiblePaymentTypes.length; ++i) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)(2 + i * 3), (Double)debtData.getTicketSum(this.eligiblePaymentTypes[i]));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)(3 + i * 3), (Double)debtData.getFeeSum(this.eligiblePaymentTypes[i]));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)(4 + i * 3), (String)String.format("%1$c%3$d+%2$c%3$d", 66 + i * 3, 67 + i * 3, this.currentRow));
        }
        ++this.currentRow;
    }

    private void removeCurrentRow() {
        ExcelUtils.removeRow((HSSFSheet)this.sheet, (int)(--this.currentRow));
    }

    private void addSubTotalSum() throws Exception {
        int formulasRow = this.currentRow + 1;
        for (int i = 0; i < this.eligiblePaymentTypes.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                String currentColumnId = String.valueOf((char)(66 + j + i * 3));
                ExcelUtils.setCellFormula((HSSFSheet)this.sheet, (int)formulasRow, (int)1, (int)1, (int)(2 + j + i * 3), (String)SalesReportHelper.getColumnSumFormula(currentColumnId, this.currentSectionStartRow + 1, this.currentRow));
                String grandTotalFormula = this.grandTotalSumFormulas[i][j];
                if (grandTotalFormula == null) {
                    this.grandTotalSumFormulas[i][j] = currentColumnId + formulasRow;
                    continue;
                }
                String[] stringArray = this.grandTotalSumFormulas[i];
                int n = j;
                stringArray[n] = stringArray[n] + "+" + currentColumnId + formulasRow;
            }
        }
    }

    private void addGrandTotalSum(HSSFSheet sheet) throws Exception {
        for (int i = 0; i < this.eligiblePaymentTypes.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(this.currentRow + 2), (int)1, (int)1, (int)(2 + j + i * 3), (String)this.grandTotalSumFormulas[i][j]);
            }
        }
    }
}

