/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.aviacentr;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportDocument;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportRenderHandler
extends BasePoiReportRenderHandler<AviacentrConsolidatedReportTicket> {
    public static final String SELL_BATCH_ID = "SELL";

    @Override
    public String getId() {
        return "aviacentr-consolidated-report";
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(AviacentrConsolidatedReportDocument.class);
        ((AviacentrConsolidatedReportDocument)result.getEntity()).setFile(file);
        List messages = (List)data.get("key-messages");
        ((AviacentrConsolidatedReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((AviacentrConsolidatedReportDocument)result.getEntity()).setReportType(ReportType.AGENT);
        AviacentrConsolidatedReportParameters reportParameters = (AviacentrConsolidatedReportParameters)data.get("key-report-params");
        ((AviacentrConsolidatedReportDocument)result.getEntity()).setParameters(reportParameters);
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        byte[] template = (byte[])data.get("REPORT_TEMPLATE");
        if (template == null) {
            File result = IoUtil.url2file((URL)BasePoiReportRenderHandler.class.getResource("/agentreports/AviacentrConsolidatedReportTemplate.xls"));
            if (!result.exists() || !result.canRead()) {
                throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.AviacentrConsolidatedReportRenderHandler_unableToLoadTemplate, (Object[])new Object[]{result.getCanonicalPath()}).toString());
            }
            return IoUtil.getResourceInputStream((File)result);
        }
        return new ByteArrayInputStream(template);
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.AviacentrConsolidatedReportRenderHandler_reportTitle, (Object[])new Object[]{data.get("REPORTNUMBER"), data.get("AGENCYNAME"), data.get("REPORT_PERIOD")}).toString();
    }

    @Override
    protected List<PoiWorksheetData<AviacentrConsolidatedReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<AviacentrConsolidatedReportTicket>> result = new ArrayList<PoiWorksheetData<AviacentrConsolidatedReportTicket>>();
        result.add(new BaseWorksheetData<AviacentrConsolidatedReportTicket>(){

            @Override
            public String getBatchId() {
                return AviacentrConsolidatedReportRenderHandler.SELL_BATCH_ID;
            }

            @Override
            public PoiWorksheetDefinition<AviacentrConsolidatedReportTicket> getDefinition() {
                return Definitions.SELL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        return result;
    }

    public static enum Definitions implements PoiWorksheetDefinition<AviacentrConsolidatedReportTicket>
    {
        SELL{

            @Override
            public PoiWorksheetHandler<AviacentrConsolidatedReportTicket> getHandler() {
                return new AviacentrConsolidatedReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.AviacentrConsolidatedReportRenderHandler_reportName, (Object[])new Object[0]).toString();
            }
        };

    }
}

