/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.bsp;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class LHBSPReportTicket
extends BaseSalesReportTicket {
    private static final long serialVersionUID = 8235207809652993670L;
    private BigDecimal total = BigDecimal.ZERO;
    private String nextProductNumber;
    private BigDecimal commissionValue = BigDecimal.ZERO;
    private double commissionRate = 0.0;

    public LHBSPReportTicket(Product ticketObj, Map<String, Object> data) throws Exception {
        super(ticketObj, (List<Message>)((List)data.get("key-messages")));
        BigDecimal fare;
        if (ticketObj.getBspCommissionRate() != null) {
            this.commissionRate = ticketObj.getBspCommissionRate();
        }
        if (ticketObj.getBspCommissionValue() != null) {
            this.commissionValue = ticketObj.getBspCommissionValue().getValue();
        }
        if ((fare = this.getEquivalentFare()) != null) {
            this.total = this.total.add(fare);
        }
        if (ticketObj.getPenalty() != null) {
            if (ticketObj.getStatus() == ProductStatus.REFUND) {
                this.total = this.total.subtract(ticketObj.getPenalty());
            }
            if (ticketObj.getStatus() == ProductStatus.EXCHANGE && (ticketObj.getNextProduct() == null || ticketObj.getNextProduct().getPenalty() == null || BigDecimal.ZERO.compareTo(ticketObj.getNextProduct().getPenalty()) == 0)) {
                this.total = this.total.subtract(ticketObj.getPenalty());
            }
            if (ticketObj.getStatus() == ProductStatus.SELL && ticketObj.getPreviousProduct() != null && ticketObj.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                this.total = this.total.add(ticketObj.getPenalty());
            }
        }
        this.total = this.total.add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)ticketObj));
        if (this.getConjunctions().length > 0) {
            this.ticketNumber = this.ticketNumber + "/" + this.getConjunctions().length;
        }
        if (ticketObj.getStatus() == ProductStatus.EXCHANGE && ticketObj.getNextProduct() != null) {
            this.nextProductNumber = ticketObj.getNextProduct().getSystemNumber();
        }
        if (ticketObj.getStatus() == ProductStatus.REFUND || ticketObj.getStatus() == ProductStatus.EXCHANGE) {
            this.commissionValue = this.commissionValue.negate();
            this.total = this.total.negate();
        }
        if (ticketObj.getStatus() == ProductStatus.VOID || ticketObj.getStatus() == ProductStatus.VOID_BOOKING) {
            this.commissionValue = BigDecimal.ZERO;
            this.total = BigDecimal.ZERO;
        }
    }

    public String getNextProductNumber() {
        return this.nextProductNumber;
    }

    public double getCommissionRate() {
        return this.commissionRate;
    }

    public BigDecimal getCommissionValue() {
        return this.commissionValue;
    }

    public BigDecimal getTotal() {
        return this.total;
    }
}

