/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.bsp;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.LHBSPReportData;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.LHBSPReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class LHBSPSheetHandler
extends BasePoiWorksheetHandler<LHBSPReportTicket> {
    LHBSPSheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<LHBSPReportTicket> data, Map<String, Object> globalData) throws Exception {
        LHBSPReportData reportData = (LHBSPReportData)globalData.get("KEY_LH_BSP_REPORT_DATA");
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_ISSUE_DATE", (String)reportData.getContractIssueDateStr());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)reportData.getAgencyName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENT_NAME", (String)reportData.getAgentName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)reportData.getAgencyDirectorName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)reportData.getReportPeriodStr());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_MONTH", (String)reportData.getReportMonth());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_YEAR", (String)reportData.getReportYear());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"TOTAL_SUM_STRING", (String)reportData.getTotalStr());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"TOTAL_COMMISSION_STR", (String)reportData.getTotalCommissionStr());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CURRENT_DATE", (String)reportData.getCurrentDateStr());
        List<LHBSPReportTicket> tickets = data.getTickets();
        Collections.sort(tickets, new Comparator<LHBSPReportTicket>(){

            @Override
            public int compare(LHBSPReportTicket o1, LHBSPReportTicket o2) {
                int res = MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate());
                if (res != 0) {
                    return res;
                }
                return TextUtil.compare((String)this.getSortingNumber(o1), (String)this.getSortingNumber(o2), (boolean)false, (boolean)true);
            }

            private String getSortingNumber(LHBSPReportTicket o1) {
                if (o1.getStatus() == ProductStatus.EXCHANGE) {
                    return o1.getNextProductNumber();
                }
                return o1.getTicketNumber();
            }
        });
        int size = tickets.size();
        for (int n = 1; n < size; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)8, (int)8);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd'.'MM'.'yyyy");
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        for (int n = 0; n < size; ++n) {
            LHBSPReportTicket ticket = tickets.get(n);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)9, (int)1, (int)(n + 1), (int)1, (int)(n + 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)9, (int)1, (int)(n + 1), (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)9, (int)1, (int)(n + 1), (int)3, (String)sdf.format(ticket.getIssueDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)9, (int)1, (int)(n + 1), (int)4, (BigDecimal)ticket.getTotal());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)9, (int)1, (int)(n + 1), (int)5, (String)String.format("%s%%", decimalFormat.format(ticket.getCommissionRate())));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)9, (int)1, (int)(n + 1), (int)6, (BigDecimal)ticket.getCommissionValue());
        }
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)10, (int)6, (int)(size == 0 ? 1 : size), (int)1, (String)String.format("=SUM(F9:F%s)", Integer.toString(8 + (size == 0 ? 1 : size))));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)10, (int)4, (int)(size == 0 ? 1 : size), (int)1, (String)String.format("=SUM(D9:D%s)", Integer.toString(8 + (size == 0 ? 1 : size))));
    }
}

