/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.bsp;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.UNBSPReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class UNBSPRegistrySheetHandler
extends BasePoiWorksheetHandler<UNBSPReportTicket> {
    UNBSPRegistrySheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<UNBSPReportTicket> data, Map<String, Object> globalData) throws Exception {
        int n;
        List<UNBSPReportTicket> tickets = data.getTickets();
        Collections.sort(tickets, new Comparator<UNBSPReportTicket>(){

            @Override
            public int compare(UNBSPReportTicket o1, UNBSPReportTicket o2) {
                int res = TextUtil.compare((String)o1.getSortingTicketNumber(), (String)o2.getSortingTicketNumber(), (boolean)false, (boolean)true);
                if (res != 0) {
                    return res;
                }
                res = this.getCategory(o1) - this.getCategory(o2);
                if (res != 0) {
                    return res;
                }
                return this.getStatus(o1) - this.getStatus(o2);
            }

            private int getCategory(UNBSPReportTicket o1) {
                if (o1.getMcoCategory() == MCOCategory.INFORMATION) {
                    return 0;
                }
                if (o1.getMcoCategory() == MCOCategory.PENALTY) {
                    return 1;
                }
                return 2;
            }

            private int getStatus(UNBSPReportTicket o1) {
                ProductStatus status = o1.getStatus();
                switch (status) {
                    case VOID: {
                        return 0;
                    }
                    case EXCHANGE: {
                        return 1;
                    }
                    case REFUND: {
                        return 2;
                    }
                }
                return 3;
            }
        });
        for (n = 1; n < tickets.size(); ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)2, (int)2);
        }
        for (n = 0; n < tickets.size(); ++n) {
            UNBSPReportTicket ticket = tickets.get(n);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)1, (int)(n + 1));
            String ticketNumber = ticket.getTicketNumber();
            if (ticket.getConjunctions().length != 0) {
                ticketNumber = ticketNumber + "/" + ticket.getConjunctions().length;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)2, (String)ticketNumber);
            boolean negative = ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)3, (BigDecimal)(negative ? ticket.getFareCash().negate() : ticket.getFareCash()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)4, (BigDecimal)(negative ? ticket.getTaxCA().negate() : ticket.getTaxCA()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)5, (BigDecimal)ticket.getPenaltyCA());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)6, (BigDecimal)(negative ? ticket.getVendorEquivalentCommission().negate() : ticket.getVendorEquivalentCommission()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)7, (BigDecimal)(negative ? ticket.getFareCC().negate() : ticket.getFareCC()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)8, (BigDecimal)(negative ? ticket.getTaxCC().negate() : ticket.getTaxCC()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + 1), (int)9, (BigDecimal)ticket.getPenaltyCC());
        }
        int row = 3 + (tickets.size() > 0 ? tickets.size() : 1);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)3, (String)String.format("=SUM(C3:C%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)4, (String)String.format("=SUM(D3:D%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)5, (String)String.format("=SUM(E3:E%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)6, (String)String.format("=SUM(F3:F%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)7, (String)String.format("=SUM(G3:G%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)8, (String)String.format("=SUM(H3:H%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)9, (String)String.format("=SUM(I3:I%s)", Integer.toString(row - 1)));
    }
}

