/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.bsp;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class UNBSPReportTicket
extends TchTicket {
    private static final long serialVersionUID = 5143359083991349852L;
    private final String transportationTypeStr = this.isVatIncluded() ? L10nResourcesManager.createL10nMessage((String)Messages.UNBSPReportTicket_transpTypeMvl, (Object[])new Object[0]).toString() : L10nResourcesManager.createL10nMessage((String)Messages.UNBSPReportTicket_transpTypeVvl, (Object[])new Object[0]).toString();
    private final BigDecimal taxCA;
    private BigDecimal penaltyCA = this.getFareCash() != null && this.getFareCash().doubleValue() > 0.0 ? this.getPenalty() : null;
    private final BigDecimal commissionCA;
    private final BigDecimal taxCC;
    private BigDecimal penaltyCC = this.getFareCC() != null && this.getFareCC().doubleValue() > 0.0 ? this.getPenalty() : null;
    private String sortingTicketNumber = null;

    public UNBSPReportTicket(Product ticketObj, Map<String, Object> data) throws Exception {
        super(ticketObj, (List<Message>)((List)data.get("key-messages")));
        Product product;
        this.taxCA = this.getTchTaxCash().add(this.getXtTaxCash());
        this.taxCC = this.getTchTaxCC().add(this.getXtTaxCC());
        this.commissionCA = this.getVendorEquivalentCommission();
        this.sortingTicketNumber = this.getTicketNumber();
        if ((ticketObj.getMcoCategory() == MCOCategory.PENALTY || ticketObj.getMcoCategory() == MCOCategory.INFORMATION) && (product = AirProductHelper.findRelatedAirProduct((Product)ticketObj, null, (boolean)false)) != null) {
            this.sortingTicketNumber = product.getSystemNumber();
            ProductStatus productStatus = this.status = product.getStatus() == ProductStatus.EXCHANGE ? ProductStatus.EXCHANGE : ProductStatus.REFUND;
        }
        if (ticketObj.getStatus() == ProductStatus.VOID || ticketObj.getStatus() == ProductStatus.VOID_BOOKING) {
            this.sortingTicketNumber = "!" + this.sortingTicketNumber;
        }
        for (Product mco : AirProductHelper.getMcoByRelatedProduct((Product)ticketObj)) {
            if (mco.getMcoCategory() != MCOCategory.PENALTY) continue;
            this.penaltyCA = BigDecimal.ZERO;
            this.penaltyCC = BigDecimal.ZERO;
            break;
        }
        if (ticketObj.getStatus() == ProductStatus.EXCHANGE && ticketObj.getNextProduct() != null) {
            this.sortingTicketNumber = ticketObj.getNextProduct().getSystemNumber();
        }
    }

    public String getTransportationTypeStr() {
        return this.transportationTypeStr;
    }

    public BigDecimal getTaxCA() {
        return this.taxCA;
    }

    public BigDecimal getPenaltyCA() {
        return this.penaltyCA == null ? BigDecimal.ZERO : this.penaltyCA;
    }

    public BigDecimal getCommissionCA() {
        return this.commissionCA == null ? BigDecimal.ZERO : this.commissionCA;
    }

    public BigDecimal getTaxCC() {
        return this.taxCC;
    }

    @Override
    public BigDecimal getPenaltyCC() {
        return this.penaltyCC == null ? BigDecimal.ZERO : this.penaltyCC;
    }

    public String getSortingTicketNumber() {
        return this.sortingTicketNumber;
    }
}

