/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.bsp;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.BaseUNBSPSummarySheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.UNBSPReportData;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.UNBSPReportTicket;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class UNBSPVVLSummarySheetHandler
extends BaseUNBSPSummarySheetHandler {
    UNBSPVVLSummarySheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<UNBSPReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        UNBSPReportData reportData = (UNBSPReportData)globalData.get("KEY_UN_BSP_REPORT_DATA");
        BigDecimal commission = BigDecimal.ZERO;
        UNBSPReportData.UNBSPSubBatchKey key = new UNBSPReportData.UNBSPSubBatchKey();
        key.setMvl(false);
        key.setPaymentType(PaymentType.CASH);
        key.setRefund(false);
        UNBSPReportData.UNBSPSubBatchData subBatchData = reportData.getBatches().get(key);
        if (subBatchData != null) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)12, (int)6, (BigDecimal)subBatchData.getFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)13, (int)6, (BigDecimal)subBatchData.getTax());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)14, (int)6, (BigDecimal)subBatchData.getPenalty());
            commission = commission.add(subBatchData.getCommission());
        }
        key = new UNBSPReportData.UNBSPSubBatchKey();
        key.setMvl(false);
        key.setPaymentType(PaymentType.CASH);
        key.setRefund(true);
        subBatchData = reportData.getBatches().get(key);
        if (subBatchData != null) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)15, (int)6, (BigDecimal)subBatchData.getFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)16, (int)6, (BigDecimal)subBatchData.getTax());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)17, (int)6, (BigDecimal)subBatchData.getPenalty());
            commission = commission.subtract(subBatchData.getCommission());
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)18, (int)6, (BigDecimal)commission);
        key = new UNBSPReportData.UNBSPSubBatchKey();
        key.setMvl(false);
        key.setPaymentType(PaymentType.CREDIT_CARD);
        key.setRefund(false);
        subBatchData = reportData.getBatches().get(key);
        if (subBatchData != null) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)26, (int)6, (BigDecimal)subBatchData.getFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)27, (int)6, (BigDecimal)subBatchData.getTax());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)28, (int)6, (BigDecimal)subBatchData.getPenalty());
        }
        key = new UNBSPReportData.UNBSPSubBatchKey();
        key.setMvl(false);
        key.setPaymentType(PaymentType.CREDIT_CARD);
        key.setRefund(true);
        subBatchData = reportData.getBatches().get(key);
        if (subBatchData != null) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)29, (int)6, (BigDecimal)subBatchData.getFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)30, (int)6, (BigDecimal)subBatchData.getTax());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)31, (int)6, (BigDecimal)subBatchData.getPenalty());
        }
    }
}

