/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.ComparisonResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class DivergenceSegmentsReportTicket
extends BaseReportTicket {
    private static final long serialVersionUID = -7405501878502038968L;
    public static final String CCC = "CCC";
    private String segmentAirlineCode;
    private String transactionType;
    private String datacode = "";
    private String errcode = "";
    private int itemNum;
    private String classOfService;
    private String fareBasis;
    private String arriveCityCode;
    private String departCityCode;
    private Date startDate;
    private String flightNo;
    private String transferNum;
    private String blankTypeCode;
    private String partNum;
    private String packNum;
    private Date abcPeriod;
    private BigDecimal commissionAmount = null;
    private Double commissionRate;
    private String validatingAirlineNumber;
    private BigDecimal penalty = null;
    private BigDecimal agsTax = null;
    private BigDecimal tchTax = null;
    private PaymentType paymentType;
    public static final String cccDataCode = L10nResourcesManager.createL10nMessage((String)Messages.DivergenceSegmentsReportTicket_Tch, (Object[])new Object[0]).toString();
    public static final String ticketDataCode = L10nResourcesManager.createL10nMessage((String)Messages.DivergenceSegmentsReportTicket_ticketDataCode, (Object[])new Object[0]).toString();

    public DivergenceSegmentsReportTicket(Product ticket, List<Message> message) {
        super(ticket, message);
        this.datacode = ticketDataCode;
        this.transactionType = this.getTransactionType(ticket);
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(ticket.getBlankType());
        if (blankType != null) {
            this.blankTypeCode = blankType.getName();
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(ticket.getStatus())) {
            return;
        }
        this.validatingAirlineNumber = ticket.getCarrierNumber();
        this.initializePaymentType(ticket, message);
        this.initializeFinancialFields(ticket, null, message);
        this.cleanupFinancialFields();
    }

    private void cleanupFinancialFields() {
        if (this.equivalentFare != null && BigDecimal.ZERO.compareTo(this.equivalentFare) == 0) {
            this.equivalentFare = null;
        }
        if (this.penalty != null && BigDecimal.ZERO.compareTo(this.penalty) == 0) {
            this.penalty = null;
        }
        if (this.agsTax != null && BigDecimal.ZERO.compareTo(this.agsTax) == 0) {
            this.agsTax = null;
        }
        if (this.tchTax != null && BigDecimal.ZERO.compareTo(this.tchTax) == 0) {
            this.tchTax = null;
        }
        if (this.commissionAmount != null && BigDecimal.ZERO.compareTo(this.commissionAmount) == 0) {
            this.commissionAmount = null;
        }
        if (this.commissionRate != null && Math.abs(this.commissionRate) < 0.001) {
            this.commissionRate = null;
        }
    }

    private void initializePaymentType(Product ticket, List<Message> message) {
        for (ProductFop fop : AirProductHelper.getVendorFops((Product)ticket)) {
            if (fop.getType() == PaymentType.CREDIT_CARD) {
                this.paymentType = PaymentType.CREDIT_CARD;
                return;
            }
            if (fop.getType() != PaymentType.CREDIT_CARD_TCH) continue;
            this.paymentType = PaymentType.CREDIT_CARD_TCH;
            return;
        }
        this.paymentType = PaymentType.CASH;
    }

    private void initializeFinancialFields(final Product ticket, ComparisonResult comparisonResult, final List<Message> message) {
        if (comparisonResult == null || comparisonResult.isDiffersInEquivalentFare()) {
            this.equivalentFare = DivergenceSegmentsReportTicket.calculate(ticket, new CCCCalculateCallback(){

                @Override
                public BigDecimal calculate(Product prod) {
                    return AirProductHelper.getEquivalentFare((Product)prod);
                }
            });
        }
        if (comparisonResult == null || comparisonResult.isDiffersInPenalty()) {
            boolean hasRelatedPenaltyMco = false;
            for (Product prod : AirProductHelper.getMcoByRelatedProduct((Product)ticket)) {
                if (prod.getMcoCategory() != MCOCategory.PENALTY) continue;
                hasRelatedPenaltyMco = true;
                break;
            }
            if (!hasRelatedPenaltyMco) {
                this.penalty = ticket.getPenalty();
            }
        }
        if ((comparisonResult == null || comparisonResult.isDiffersInPenalty() || comparisonResult.isDiffersInEquivalentFare()) && ticket.getProductCategory() == ProductCategory.MCO && (ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING)) {
            this.penalty = AirProductHelper.getEquivalentFare((Product)ticket);
            this.equivalentFare = null;
        }
        if (comparisonResult == null || comparisonResult.isDiffersInAgsTax()) {
            this.agsTax = DivergenceSegmentsReportTicket.calculate(ticket, new CCCCalculateCallback(){

                @Override
                public BigDecimal calculate(Product prod) {
                    BigDecimal result = AirProductTaxHelper.getEquivalentTaxesAmount((Product)prod).subtract(AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)prod));
                    for (OBFee obFee : prod.getObFees()) {
                        if (obFee.getAmount() == null) continue;
                        result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, obFee.getAmount().getValue()});
                    }
                    return result;
                }
            });
        }
        if (comparisonResult == null || comparisonResult.isDiffersInTchTax()) {
            this.tchTax = DivergenceSegmentsReportTicket.calculate(ticket, new CCCCalculateCallback(){

                @Override
                public BigDecimal calculate(Product prod) {
                    return AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)prod);
                }
            });
        }
        if (comparisonResult == null || comparisonResult.isDiffersInCommission()) {
            this.commissionAmount = DivergenceSegmentsReportTicket.calculate(ticket, new CCCCalculateCallback(){

                @Override
                public BigDecimal calculate(Product prod) {
                    try {
                        return AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)prod, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, null, null));
                    }
                    catch (Exception e) {
                        SystemHelper.addExceptionMessage((List)message, (String)Messages.DivergenceSegmentsReportTicket_failedCalculateCommission, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
                        return null;
                    }
                }
            });
            try {
                this.commissionRate = AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)ticket, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, null, null), (boolean)true);
            }
            catch (Exception e) {
                SystemHelper.addExceptionMessage(message, (String)Messages.DivergenceSegmentsReportTicket_failedCalculateCommission, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
            }
        }
    }

    public DivergenceSegmentsReportTicket(CCCExchangeDocument cccDoc, ComparisonResult comparisonResult, List<Message> message) {
        this.equivalentFare = null;
        this.ticketNumber = cccDoc.getTicketNumber();
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(cccDoc.getBlankType());
        this.blankTypeCode = blankType != null ? blankType.getName() : null;
        this.partNum = cccDoc.getPartNum();
        this.packNum = cccDoc.getPackNum();
        this.abcPeriod = cccDoc.getAbcPeriod();
        this.datacode = cccDataCode;
        String string = this.transactionType = cccDoc.getTransaction() != null ? cccDoc.getTransaction().toString() : null;
        if (cccDoc.getTransaction() == TransactionType.CANCEL || cccDoc.getTransaction() == TransactionType.REFERENCE) {
            return;
        }
        this.classOfService = cccDoc.getClassOfService();
        this.fareBasis = cccDoc.getFareBasis();
        this.arriveCityCode = this.getArriveCityCode();
        this.departCityCode = this.getDepartCityCode();
        this.startDate = cccDoc.getStartDate();
        this.flightNo = cccDoc.getFlightNo();
        this.transferNum = cccDoc.getTransferSegment();
        this.segmentAirlineCode = cccDoc.getSegmentCarrierCode();
        this.validatingAirlineNumber = cccDoc.getValidatingCarrierNumber();
        if (comparisonResult == null || comparisonResult.isDiffersInCommission()) {
            this.commissionAmount = cccDoc.getCommissionValue();
            this.commissionRate = cccDoc.getCommissionRate();
        }
        if (comparisonResult == null || comparisonResult.isDiffersInEquivalentFare()) {
            this.equivalentFare = cccDoc.getEquivalentFare();
        }
        if (comparisonResult == null || comparisonResult.isDiffersInPenalty()) {
            this.penalty = cccDoc.getPenalty();
        }
        if (comparisonResult == null || comparisonResult.isDiffersInAgsTax()) {
            this.agsTax = cccDoc.getAgsTax();
        }
        if (comparisonResult == null || comparisonResult.isDiffersInTchTax()) {
            this.tchTax = cccDoc.getTchTax();
        }
        if (comparisonResult == null || comparisonResult.isDiffersInPaymentType()) {
            this.paymentType = cccDoc.getPaymentType();
        }
        this.cleanupFinancialFields();
    }

    public DivergenceSegmentsReportTicket(Product ticket, Segment segment, CCCExchangeDocument cccDoc, ComparisonResult comparisonResult, boolean ignoreFinancialFields, List<Message> message) {
        super(ticket, message);
        Airline carrier;
        Airline docCarrier;
        DictionaryReference airline;
        this.equivalentFare = null;
        this.datacode = ticketDataCode;
        this.transactionType = this.getTransactionType(ticket);
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(ticket.getBlankType());
        if (blankType != null) {
            this.blankTypeCode = blankType.getName();
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(ticket.getStatus())) {
            return;
        }
        this.validatingAirlineNumber = ticket.getCarrierNumber();
        DictionaryReference dictionaryReference = airline = segment != null ? segment.getAirline() : ticket.getCarrier();
        if (cccDoc != null && (docCarrier = DictHelper.findAirlineByAnyCode((String)cccDoc.getSegmentCarrierCode())) != null && docCarrier.toReference().equals((Object)airline)) {
            this.segmentAirlineCode = cccDoc.getSegmentCarrierCode();
        }
        if (TextUtil.isBlank((String)this.segmentAirlineCode) && (carrier = (Airline)DictionaryCache.get().resolveReference(airline)) != null) {
            if (!carrier.getCodeVariants().isEmpty()) {
                this.segmentAirlineCode = (String)carrier.getCodeVariants().get(CodeSystem.CRT.name());
                if (this.segmentAirlineCode == null) {
                    this.segmentAirlineCode = (String)carrier.getCodeVariants().values().iterator().next();
                }
            } else {
                this.segmentAirlineCode = carrier.getCode();
            }
        }
        if (ticket.getMcoCategory() == MCOCategory.REBOOKING) {
            this.segmentAirlineCode = null;
        }
        if (cccDoc != null) {
            this.classOfService = cccDoc.getClassOfService();
            this.fareBasis = cccDoc.getFareBasis();
            this.arriveCityCode = cccDoc.getArrivalCityCode();
            this.departCityCode = cccDoc.getDepartureCityCode();
            this.startDate = cccDoc.getStartDate();
            this.flightNo = cccDoc.getFlightNo();
            this.transferNum = cccDoc.getTransferSegment();
            this.partNum = cccDoc.getPartNum();
            this.packNum = cccDoc.getPackNum();
            this.abcPeriod = cccDoc.getAbcPeriod();
        } else if (segment != null) {
            this.classOfService = segment.getClassOfService();
            this.fareBasis = segment.getFareBasis();
            this.arriveCityCode = segment.getArriveCityCode();
            this.departCityCode = segment.getDepartCityCode();
            this.startDate = segment.getStartDate();
            this.flightNo = segment.getFlightNo();
            this.transferNum = Integer.toString(segment.getRecordNumber());
        }
        if (comparisonResult == null || comparisonResult.isDiffersInPaymentType()) {
            this.initializePaymentType(ticket, message);
        }
        if (!ignoreFinancialFields) {
            this.initializeFinancialFields(ticket, comparisonResult, message);
        }
        this.cleanupFinancialFields();
    }

    private String getTransactionType(Product ticket) {
        if (ticket.getStatus() == null) {
            return TransactionType.SELL.toString();
        }
        switch (ticket.getStatus()) {
            case SELL: {
                if (ticket.getMcoCategory() == MCOCategory.PENALTY) {
                    return TransactionType.MCO_PENALTY.toString();
                }
                if (ticket.getMcoCategory() == MCOCategory.REBOOKING) {
                    return TransactionType.MCO_PENALTY.toString();
                }
                if (ticket.getMcoCategory() == MCOCategory.INFORMATION) {
                    return TransactionType.REFERENCE.toString();
                }
                if (ticket.getProductCategory() == ProductCategory.EXCESS_BAGAGE) {
                    return TransactionType.EXCESS_BAGGAGE.toString();
                }
                return TransactionType.SELL.toString();
            }
            case REFUND: {
                return TransactionType.REFUND.toString();
            }
            case EXCHANGE: {
                return TransactionType.EXCHANGE.toString();
            }
            case VOID: 
            case VOID_BOOKING: {
                if (ticket.getMcoCategory() == MCOCategory.INFORMATION) {
                    return TransactionType.REFERENCE.toString();
                }
                return TransactionType.CANCEL.toString();
            }
        }
        return TransactionType.SELL.toString();
    }

    public String getSegmentAirlineCode() {
        return this.segmentAirlineCode;
    }

    public void setSegmentAirlineCode(String value) {
        this.segmentAirlineCode = value;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String value) {
        this.transactionType = value;
    }

    public String getDatacode() {
        return this.datacode;
    }

    public void setDatacode(String value) {
        this.datacode = value;
    }

    public int getItemNum() {
        return this.itemNum;
    }

    public void setItemNum(int value) {
        this.itemNum = value;
    }

    public String getClassOfService() {
        return this.classOfService;
    }

    public void setClassOfService(String value) {
        this.classOfService = value;
    }

    public String getFareBasis() {
        return this.fareBasis;
    }

    public void setFareBasis(String value) {
        this.fareBasis = value;
    }

    public String getArriveCityCode() {
        return this.arriveCityCode;
    }

    public void setArriveCityCode(String value) {
        this.arriveCityCode = value;
    }

    public String getDepartCityCode() {
        return this.departCityCode;
    }

    public void setDepartCityCode(String value) {
        this.departCityCode = value;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public String getFlightNo() {
        return this.flightNo;
    }

    public void setFlightNo(String value) {
        this.flightNo = value;
    }

    public String getTransferNum() {
        return this.transferNum;
    }

    public void setTransferNum(String value) {
        this.transferNum = value;
    }

    public String getBlankTypeCode() {
        return this.blankTypeCode;
    }

    public void setBlankTypeCode(String value) {
        this.blankTypeCode = value;
    }

    public String getPartNum() {
        return this.partNum;
    }

    public void setPartNum(String value) {
        this.partNum = value;
    }

    public String getPackNum() {
        return this.packNum;
    }

    public void setPackNum(String value) {
        this.packNum = value;
    }

    public Date getAbcPeriod() {
        return this.abcPeriod;
    }

    public void setAbcPeriod(Date value) {
        this.abcPeriod = value;
    }

    public String getErrcode() {
        return this.errcode;
    }

    public void setErrcode(String value) {
        this.errcode = value;
    }

    public BigDecimal getCommissionAmount() {
        return this.commissionAmount;
    }

    public void setCommissionAmount(BigDecimal value) {
        this.commissionAmount = value;
    }

    public Double getCommissionRate() {
        return this.commissionRate;
    }

    public void setCommissionRate(Double value) {
        this.commissionRate = value;
    }

    public String getValidatingAirlineNumber() {
        return this.validatingAirlineNumber;
    }

    public void setValidatingAirlineNumber(String value) {
        this.validatingAirlineNumber = value;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public BigDecimal getAgsTax() {
        return this.agsTax;
    }

    public BigDecimal getTchTax() {
        return this.tchTax;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public static BigDecimal calculate(Product prod, CCCCalculateCallback callback) {
        BigDecimal result = callback.calculate(prod);
        if (prod.getStatus() == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            BigDecimal exchangeValue = callback.calculate(prod.getPreviousProduct());
            if (exchangeValue != null) {
                result = result == null ? exchangeValue.negate() : result.subtract(exchangeValue);
            }
        } else if (prod.getStatus() == ProductStatus.EXCHANGE) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public static interface CCCCalculateCallback {
        public BigDecimal calculate(Product var1);
    }
}

