/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.common;

import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.parsers.model.BaseSsodExchangeDocument;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.common.BaseSsodDivergenceReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.common.BaseSsodDivergenceTicketWrapper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public abstract class BaseSsodDivergencePoiWorksheetHandler<E extends BaseSsodExchangeDocument, W extends BaseSsodDivergenceTicketWrapper<E>, T extends BaseSsodDivergenceReportTicket<E, W>>
extends BasePoiWorksheetHandler<T> {
    private final NumberFormat nf = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH));

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<T> data, Map<String, Object> globalData) throws Exception {
        int n;
        super.fill(wb, sheet, data, globalData);
        sheet.setForceFormulaRecalculation(true);
        List<T> tickets = data.getTickets();
        int rowsCount = 0;
        for (BaseSsodDivergenceReportTicket ticket : tickets) {
            if (ticket.documentWrapper != null) {
                ++rowsCount;
            }
            if (ticket.ticketWrapper == null) continue;
            ++rowsCount;
        }
        int currentRow = 5;
        for (n = 0; n < rowsCount - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)(currentRow - 1), (int)(currentRow - 1));
        }
        for (n = 0; n < tickets.size(); ++n) {
            BaseSsodDivergenceReportTicket ticket = (BaseSsodDivergenceReportTicket)tickets.get(n);
            if (ticket.documentWrapper != null) {
                this.addRow(ticket.documentWrapper, ticket.ticketWrapper, n + 1, currentRow, sheet);
                ++currentRow;
            }
            if (ticket.ticketWrapper == null) continue;
            this.addRow(ticket.ticketWrapper, ticket.documentWrapper, n + 1, currentRow, sheet);
            ++currentRow;
        }
    }

    private void addRow(W item, W pair, int itemNumber, int currentRow, HSSFSheet sheet) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)1, (int)itemNumber);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)2, (String)(((BaseSsodDivergenceTicketWrapper)item).isFromRet() ? this.getFileType() : "AGENCY"));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)3, (String)((BaseSsodDivergenceTicketWrapper)item).getValidatingCarrierNumber());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)4, (String)((BaseSsodDivergenceTicketWrapper)item).getTicketNumber());
        if (pair == null || !((BaseSsodDivergenceTicketWrapper)item).isEqualsByIssueDate(pair)) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)5, (Date)((BaseSsodDivergenceTicketWrapper)item).getIssued());
        }
        if (pair == null || !((BaseSsodDivergenceTicketWrapper)item).isEqualsByTravellerName(pair)) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)6, (String)((BaseSsodDivergenceTicketWrapper)item).getTravellerName());
        }
        if (!(pair != null && ((BaseSsodDivergenceTicketWrapper)item).isEqualsByBaseFare(pair) || ((BaseSsodDivergenceTicketWrapper)item).getBaseFare() == null)) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)7, (String)String.format("%s %s", this.format(((BaseSsodDivergenceTicketWrapper)item).getBaseFare().getValue()), ((BaseSsodDivergenceTicketWrapper)item).getBaseFare().getCurrency()));
        }
        if (pair == null || !((BaseSsodDivergenceTicketWrapper)item).isEqualsByEquivalentFare(pair)) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)8, (BigDecimal)((BaseSsodDivergenceTicketWrapper)item).getEquivalentFare());
        }
        if (pair == null || !((BaseSsodDivergenceTicketWrapper)item).isEqualsByPenalty(pair)) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)9, (BigDecimal)((BaseSsodDivergenceTicketWrapper)item).getPenalty());
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)10, (String)((BaseSsodDivergenceTicketWrapper)item).getItemType().toString());
        List<Tax> taxes = ((BaseSsodDivergenceTicketWrapper)item).getTaxes();
        if (!(pair != null && ((BaseSsodDivergenceTicketWrapper)item).isEqualsByTaxes(pair) || taxes.isEmpty())) {
            StringBuilder taxesString = new StringBuilder();
            for (int n = 0; n < taxes.size(); ++n) {
                if (n > 0) {
                    taxesString.append(" ");
                }
                Tax tax = taxes.get(n);
                taxesString.append(String.format("%s: %s", tax.getCode(), this.format(tax.getEquivalentAmount())));
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)11, (String)taxesString.toString());
        }
    }

    protected abstract String getFileType();

    private String format(BigDecimal value) {
        return value == null ? "???" : this.nf.format(value.doubleValue());
    }
}

