/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.common;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.BaseSsodExchangeDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class BaseSsodDivergenceTicketWrapper<E extends BaseSsodExchangeDocument>
implements Serializable {
    private static final long serialVersionUID = 8910181071195066859L;
    protected static final Locale ruLocale = new Locale("ru");
    protected static final String[] GENDERS = new String[]{"MR", "\u0413\u041d", "\u0413-\u041d", "MRS", "MS", "\u0413-\u0416\u0410", "MIS", "MSTR", "INF", "MSS", "G-N", "G-ZHA"};
    protected Money baseFare;
    protected BigDecimal equivalentFare;
    protected BigDecimal penalty;
    private String travellerName;
    private final List<Tax> taxes = new ArrayList<Tax>();
    private String validatingCarrierNumber;
    private boolean fromRet;
    private String ticketNumber;
    private ItemType itemType;
    private boolean conjunction;
    private boolean it;
    private Date issued;

    public BaseSsodDivergenceTicketWrapper(Product ticket, boolean conj, String systemNumber, List<Message> messages) {
        this.itemType = ticket.getStatus() == ProductStatus.VOID || ticket.getStatus() == ProductStatus.VOID_BOOKING ? ItemType.VOID : (ticket.getStatus() == ProductStatus.SELL && ticket.getPreviousProduct() != null && ticket.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE ? ItemType.EXCHANGE : (ticket.getStatus() == ProductStatus.REFUND ? ItemType.REFUND : (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION ? ItemType.MCO_REFERENCE : ItemType.SELL)));
        this.conjunction = conj;
        this.issued = ticket.getIssueDate();
        this.ticketNumber = systemNumber;
        this.fromRet = false;
        this.validatingCarrierNumber = ticket.getCarrierNumber();
        if (ticket.getTraveller() != null) {
            this.travellerName = this.getTravellerName(ticket.getTraveller().getName());
        }
        if (this.conjunction) {
            this.equivalentFare = BigDecimal.ZERO;
            this.baseFare = SystemHelper.getMoney((double)0.0, (String)"RUB");
            this.penalty = BigDecimal.ZERO;
            return;
        }
        if (this.itemType == ItemType.VOID) {
            this.equivalentFare = BigDecimal.ZERO;
            this.baseFare = SystemHelper.getMoney((double)0.0, (String)"RUB");
            this.penalty = BigDecimal.ZERO;
            return;
        }
        this.baseFare = this.calculateBaseFare(ticket);
        this.equivalentFare = this.calculateEquivalentFare(ticket);
        this.penalty = BigDecimal.ZERO;
        for (Product mco : AirProductHelper.getMcoByRelatedProduct((Product)ticket)) {
            BigDecimal ef;
            if (mco.getMcoCategory() != MCOCategory.PENALTY || (ef = AirProductHelper.getEquivalentFare((Product)mco)) == null) continue;
            this.penalty = this.penalty.add(ef);
        }
        if (ticket.getPenalty() != null) {
            this.penalty = this.penalty.add(ticket.getPenalty());
        }
        this.taxes.addAll(this.extractTaxes(ticket, messages));
        if (this.itemType == ItemType.EXCHANGE) {
            Product previousProduct = ticket.getPreviousProduct();
            this.baseFare.setValue(this.baseFare.getValue().subtract(this.calculateBaseFare(previousProduct).getValue()));
            this.equivalentFare = this.equivalentFare.subtract(this.calculateEquivalentFare(previousProduct));
            ArrayList<Tax> additionalTaxes = new ArrayList<Tax>();
            block1: for (Tax etax : this.extractTaxes(previousProduct, messages)) {
                for (Tax tax : this.taxes) {
                    if (!tax.getCode().equals(etax.getCode())) continue;
                    tax.setEquivalentAmount(tax.getEquivalentAmount().subtract(etax.getEquivalentAmount()));
                    continue block1;
                }
                etax.setEquivalentAmount(etax.getEquivalentAmount().negate());
                additionalTaxes.add(etax);
            }
            this.taxes.addAll(additionalTaxes);
        }
        this.updateTaxes();
    }

    private void updateTaxes() {
        for (Tax tax : this.taxes) {
            if (tax.getCode() == null || !tax.getCode().toLowerCase().matches("[\u0430-\u044f]+")) continue;
            tax.setCode(TextUtil.translit((String)tax.getCode(), (boolean)true));
        }
        Collections.sort(this.taxes, new Comparator<Tax>(){

            @Override
            public int compare(Tax o1, Tax o2) {
                return TextUtil.compare((String)o1.getCode(), (String)o2.getCode(), (boolean)false, (boolean)true);
            }
        });
    }

    private Collection<? extends Tax> extractTaxes(Product ticket, List<Message> messages) {
        LinkedHashMap<String, BigDecimal> taxAmounts = new LinkedHashMap<String, BigDecimal>();
        for (Tax tax : ticket.getTaxes()) {
            if (tax.getCode() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseSsodDivergence_noCodeForTax, (Object[])new Object[]{this.ticketNumber}));
                continue;
            }
            if (tax.getEquivalentAmount() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseSsodDivergence_noAmountForTax, (Object[])new Object[]{this.ticketNumber, tax.getCode()}));
                continue;
            }
            BigDecimal taxAmount = (BigDecimal)taxAmounts.get(tax.getCode());
            taxAmounts.put(tax.getCode(), taxAmount == null ? tax.getEquivalentAmount() : taxAmount.add(tax.getEquivalentAmount()));
        }
        ArrayList taxesCodes = new ArrayList(taxAmounts.keySet());
        Collections.sort(taxesCodes);
        ArrayList<Tax> result = new ArrayList<Tax>();
        for (String taxCode : taxesCodes) {
            Tax cTax = new Tax();
            cTax.setCode(taxCode);
            cTax.setEquivalentAmount((BigDecimal)taxAmounts.get(taxCode));
            result.add(cTax);
        }
        return result;
    }

    protected Money calculateBaseFare(Product ticket) {
        Money result = AirProductHelper.getBaseFare((Product)ticket);
        return result == null ? SystemHelper.getMoney((double)0.0, (String)"RUB") : result;
    }

    protected BigDecimal calculateEquivalentFare(Product ticket) {
        BigDecimal result = AirProductHelper.getEquivalentFare((Product)ticket);
        return result == null ? BigDecimal.ZERO : result;
    }

    public BaseSsodDivergenceTicketWrapper(E document, List<Message> messages) {
        if (document.getTransaction() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseSsodDivergence_transactionTypeNotSet, (Object[])new Object[]{document.getTicketNumber()}));
            this.baseFare = SystemHelper.getMoney((double)0.0, (String)"RUB");
            this.equivalentFare = BigDecimal.ZERO;
            this.penalty = BigDecimal.ZERO;
            this.travellerName = null;
            this.validatingCarrierNumber = null;
            this.fromRet = true;
            this.ticketNumber = null;
            this.itemType = null;
            this.conjunction = false;
            this.issued = null;
            return;
        }
        switch (document.getTransaction()) {
            case EXCHANGE: {
                this.itemType = ItemType.EXCHANGE;
                break;
            }
            case REFUND: {
                this.itemType = ItemType.REFUND;
                break;
            }
            case REFERENCE: {
                this.itemType = ItemType.MCO_REFERENCE;
                break;
            }
            case CANCEL: {
                this.itemType = ItemType.VOID;
                break;
            }
            default: {
                this.itemType = ItemType.SELL;
            }
        }
        this.conjunction = document.isConjuction();
        this.it = document.isIt();
        this.issued = document.getIssued();
        this.ticketNumber = document.getTicketNumber();
        this.fromRet = true;
        Airline validatingAirline = (Airline)DictionaryCache.get().resolveReference(document.getValidatingAirline());
        this.validatingCarrierNumber = validatingAirline == null ? null : validatingAirline.getAirlineNumber();
        this.travellerName = this.getTravellerName(document.getTravellerName());
        if (this.conjunction) {
            this.equivalentFare = BigDecimal.ZERO;
            this.baseFare = SystemHelper.getMoney((double)0.0, (String)"RUB");
            this.penalty = BigDecimal.ZERO;
            return;
        }
        if (this.itemType == ItemType.VOID) {
            this.equivalentFare = BigDecimal.ZERO;
            this.baseFare = SystemHelper.getMoney((double)0.0, (String)"RUB");
            this.penalty = BigDecimal.ZERO;
            return;
        }
        this.baseFare = document.getBaseFare();
        if (this.baseFare == null) {
            this.baseFare = SystemHelper.getMoney((double)0.0, (String)"RUB");
        }
        this.equivalentFare = document.getEquivalentFare();
        if (this.equivalentFare == null) {
            this.equivalentFare = BigDecimal.ZERO;
        }
        this.penalty = document.getPenalty();
        if (this.penalty == null) {
            this.penalty = BigDecimal.ZERO;
        }
        this.taxes.addAll(document.getTaxes());
        this.updateTaxes();
    }

    protected String getTravellerName(String prodTravellerName) {
        if (TextUtil.isBlank((String)prodTravellerName)) {
            return null;
        }
        prodTravellerName = prodTravellerName.trim().toUpperCase(ruLocale);
        prodTravellerName = this.cleanupSuffix(prodTravellerName);
        prodTravellerName = prodTravellerName.replaceAll("/", " ");
        prodTravellerName = prodTravellerName.replaceAll("\\s+", " ");
        return prodTravellerName;
    }

    private String cleanupSuffix(String value) {
        String prodTravellerName = value;
        boolean matched = false;
        for (String gender : GENDERS) {
            if (!prodTravellerName.endsWith(" " + gender)) continue;
            prodTravellerName = prodTravellerName.substring(0, prodTravellerName.length() - (" " + gender).length()).trim();
            matched = true;
        }
        if (matched) {
            prodTravellerName = this.cleanupSuffix(prodTravellerName);
        }
        return prodTravellerName;
    }

    public Money getBaseFare() {
        return this.baseFare;
    }

    public BigDecimal getEquivalentFare() {
        return this.equivalentFare;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public List<Tax> getTaxes() {
        return this.taxes;
    }

    public boolean isConjunction() {
        return this.conjunction;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public String getValidatingCarrierNumber() {
        return this.validatingCarrierNumber;
    }

    public boolean isFromRet() {
        return this.fromRet;
    }

    public String getTravellerName() {
        return this.travellerName;
    }

    public boolean isEqualsByBaseFare(BaseSsodDivergenceTicketWrapper<E> other) {
        return this.itemType == ItemType.REFUND || this.itemType == ItemType.VOID || other.baseFare.getValue().compareTo(this.baseFare.getValue()) == 0 && other.baseFare.getCurrency().equals(this.baseFare.getCurrency());
    }

    public boolean isEqualsByEquivalentFare(BaseSsodDivergenceTicketWrapper<E> other) {
        return this.itemType == ItemType.REFUND || this.itemType == ItemType.VOID || other.equivalentFare.compareTo(this.equivalentFare) == 0;
    }

    public boolean isEqualsByPenalty(BaseSsodDivergenceTicketWrapper<E> other) {
        return this.itemType == ItemType.REFUND || this.itemType == ItemType.VOID || other.penalty.compareTo(this.penalty) == 0;
    }

    public boolean isEqualsByTravellerName(BaseSsodDivergenceTicketWrapper<E> other) {
        return this.itemType == ItemType.VOID || MiscUtil.equals((Object)other.travellerName, (Object)this.travellerName);
    }

    public boolean isEqualsByValidatingCarrierNumber(BaseSsodDivergenceTicketWrapper<E> other) {
        return MiscUtil.equals((Object)other.validatingCarrierNumber, (Object)this.validatingCarrierNumber);
    }

    public boolean isEqualsByIssueDate(BaseSsodDivergenceTicketWrapper<E> other) {
        return MiscUtil.equals((Object)MiscUtil.clearTime((Date)other.issued), (Object)MiscUtil.clearTime((Date)this.issued));
    }

    public Date getIssued() {
        return this.issued;
    }

    public boolean isEqualsByTaxes(BaseSsodDivergenceTicketWrapper<E> other) {
        if (this.itemType == ItemType.REFUND) {
            return true;
        }
        if (this.itemType == ItemType.VOID) {
            return true;
        }
        return this.isEquals(this.taxes, other.taxes);
    }

    protected boolean isEquals(List<Tax> sourceTaxes, List<Tax> otherTaxes) {
        Map<String, BigDecimal> sourceTaxesMap = sourceTaxes.stream().collect(Collectors.toMap(Tax::getCode, Tax::getEquivalentAmount, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})));
        Map<String, BigDecimal> otherTaxesMap = otherTaxes.stream().collect(Collectors.toMap(Tax::getCode, Tax::getEquivalentAmount, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})));
        if (sourceTaxesMap.size() != otherTaxesMap.size()) {
            return false;
        }
        for (Map.Entry<String, BigDecimal> sourceTax : sourceTaxesMap.entrySet()) {
            BigDecimal otherTaxValue;
            if (!otherTaxesMap.containsKey(sourceTax.getKey())) {
                return false;
            }
            BigDecimal sourceTaxValue = sourceTax.getValue();
            if (MiscUtil.equals((Object)sourceTaxValue, (Object)(otherTaxValue = otherTaxesMap.get(sourceTax.getKey())))) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualsByAllParameters(BaseSsodDivergenceTicketWrapper<E> other, DivergenceReportParameters divParam) {
        if (divParam.isExcludeNullableTickets() && this.isNullableTickets(other)) {
            return true;
        }
        if (divParam.isExcludeIT() && other.it) {
            return true;
        }
        boolean id = divParam.isExcludeDate() ? true : this.isEqualsByIssueDate(other);
        boolean tn = divParam.isExcludeName() ? true : this.isEqualsByTravellerName(other);
        boolean fr = this.isEqualsByEquivalentFare(other);
        boolean pt = this.isEqualsByPenalty(other);
        boolean tx = this.isEqualsByTaxes(other);
        boolean cn = this.isEqualsByValidatingCarrierNumber(other);
        boolean bf = this.conjunction ? true : this.isEqualsByBaseFare(other);
        return tn && cn && id && bf && fr && pt && tx;
    }

    private boolean isNullableTickets(BaseSsodDivergenceTicketWrapper<E> other) {
        return MiscUtil.isZero((BigDecimal)other.equivalentFare, (boolean)true) && MiscUtil.isZero((BigDecimal)other.penalty, (boolean)true) && MiscUtil.isZero((BigDecimal)AirProductTaxHelper.getEquivalentTaxesAmountByCodes(other.taxes, (boolean)false, (String[])new String[0]), (boolean)true) && MiscUtil.isZero((BigDecimal)this.equivalentFare, (boolean)true) && MiscUtil.isZero((BigDecimal)this.penalty, (boolean)true) && MiscUtil.isZero((BigDecimal)AirProductTaxHelper.getEquivalentTaxesAmountByCodes(this.taxes, (boolean)false, (String[])new String[0]), (boolean)true);
    }

    public static enum ItemType {
        SELL{

            public String toString() {
                return "SELL";
            }
        }
        ,
        REFUND{

            public String toString() {
                return "REFUND";
            }
        }
        ,
        EXCHANGE{

            public String toString() {
                return "EXCHANGE";
            }
        }
        ,
        MCO_REFERENCE{

            public String toString() {
                return "REF";
            }
        }
        ,
        VOID{

            public String toString() {
                return "VOID";
            }
        };

    }
}

