/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocument;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DivergenceObjectsReportTicket
extends BaseReportTicket {
    private static final long serialVersionUID = -5647906063349000652L;
    public static final String SALE = "SALE";
    private static final String[] GENDERS = new String[]{"mr", "\u0433\u043d", "\u0433-\u043d", "mrs", "ms", "\u0433-\u0436\u0430"};
    private Money baseFare;
    private BigDecimal bspCommissionAmount;
    private Double bspCommissionRate;
    private String travellerName;
    private final List<Tax> taxes = new ArrayList<Tax>();
    private String airlineCode;
    private String airlineNumber;
    private String transactionType;
    private String datacode = "";
    private int itemNum;
    public static final Locale ruLocale = new Locale("ru");
    public static final String hotDataCode = "HOT";
    public static final String ticketDataCode = "Ticket";
    private BigDecimal penalty;

    public DivergenceObjectsReportTicket() {
    }

    public DivergenceObjectsReportTicket(Product ticket, Double commissionRate, BigDecimal commissionAmount, List<Message> messages) throws Exception {
        super(ticket, messages);
        this.baseFare = AirProductHelper.getBaseFare((Product)ticket);
        if (this.baseFare == null) {
            this.baseFare = SystemHelper.getMoney((double)0.0, (String)"RUB");
        }
        if (this.equivalentFare == null) {
            this.equivalentFare = BigDecimal.ZERO;
        }
        if (ticket.getTraveller() != null) {
            this.travellerName = DivergenceObjectsReportTicket.getTraveller(ticket.getTraveller().getName());
        }
        this.bspCommissionAmount = commissionAmount;
        if (this.bspCommissionAmount == null) {
            this.bspCommissionAmount = BigDecimal.ZERO;
        }
        this.setBspCommissionRate(commissionRate == null ? Double.valueOf(0.0) : commissionRate);
        this.airlineCode = this.getAirlineCode((DictionaryReference<Airline>)ticket.getCarrier());
        this.airlineNumber = this.getAirlineNumber((DictionaryReference<Airline>)ticket.getCarrier());
        for (Tax tax : ticket.getTaxes()) {
            if (tax.getCode() == null) {
                tax.setCode("");
            }
            if (tax.getEquivalentAmount() == null) {
                tax.setEquivalentAmount(BigDecimal.ZERO);
            }
            this.taxes.add(tax);
        }
        this.transactionType = ticket.getPreviousProduct() != null && ticket.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE ? ProductStatus.EXCHANGE.toString() : (ticket.getStatus() != null ? ticket.getStatus().toString() : null);
        this.penalty = ticket.getPenalty();
        if (this.penalty == null && ticket.getStatus() == ProductStatus.REFUND) {
            this.penalty = this.getPenaltyFromMCO(ticket);
        }
        if (this.penalty == null && ticket.getStatus() == ProductStatus.SELL && ticket.getPreviousProduct() != null && ticket.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            this.penalty = this.getPenaltyFromMCO(ticket.getPreviousProduct());
        }
        if (this.penalty == null) {
            this.penalty = BigDecimal.ZERO;
        }
        this.datacode = ticketDataCode;
        if (ticket.getStatus() == ProductStatus.SELL && ticket.getPreviousProduct() != null && ticket.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            BigDecimal ef;
            Commission productCommission = BookingHelper.getTotalBspCommission((Product)ticket.getPreviousProduct());
            Double rate2 = null;
            if (productCommission != null && (rate2 = productCommission.getRate()) == null && productCommission.getEquivalentAmount() != null && (ef = AirProductHelper.getEquivalentFare((Product)ticket.getPreviousProduct())) != null && BigDecimal.ZERO.compareTo(ef) != 0) {
                rate2 = productCommission.getEquivalentAmount().divide(ef, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue();
            }
            DivergenceObjectsReportTicket exchangeTicket = new DivergenceObjectsReportTicket(ticket.getPreviousProduct(), rate2, productCommission == null ? BigDecimal.ZERO : productCommission.getEquivalentAmount(), messages);
            this.equivalentFare = this.equivalentFare.subtract(exchangeTicket.getEquivalentFare());
            block1: for (Tax tax : exchangeTicket.getTaxes()) {
                for (Tax tax2 : this.taxes) {
                    if (!tax2.getCode().equals(tax.getCode())) continue;
                    tax2.setEquivalentAmount(tax2.getEquivalentAmount().subtract(tax.getEquivalentAmount()));
                    continue block1;
                }
                tax.setEquivalentAmount(tax.getEquivalentAmount().negate());
                this.taxes.add(tax);
            }
        }
    }

    private BigDecimal getPenaltyFromMCO(Product ticket) {
        BigDecimal result = null;
        for (Product prod : AirProductHelper.getMcoByRelatedProduct((Product)ticket)) {
            BigDecimal ef;
            if (prod.getMcoCategory() != MCOCategory.PENALTY || (ef = AirProductHelper.getEquivalentFare((Product)prod)) == null) continue;
            result = result == null ? ef : result.add(ef);
        }
        return result;
    }

    public DivergenceObjectsReportTicket(HotExchangeDocument doc, List<Message> messages) {
        this.setUid(doc.getUid());
        this.ticketNumber = doc.getTicketNumber();
        this.airlineCode = this.getAirlineCode((DictionaryReference<Airline>)doc.getTicketingAirline());
        this.airlineNumber = this.getAirlineNumber((DictionaryReference<Airline>)doc.getTicketingAirline());
        this.issueDate = doc.getIssued();
        this.baseFare = doc.getBaseFare();
        this.bspCommissionAmount = doc.getBSPCommissionValue();
        this.setBspCommissionRate(doc.getBSPCommissionRate());
        this.equivalentFare = doc.getEquivalentFare();
        this.travellerName = DivergenceObjectsReportTicket.getTraveller(doc.getTravellerName());
        this.taxes.addAll(doc.getTaxes());
        this.transactionType = doc.getTransaction() != null ? doc.getTransaction().toString() : null;
        this.datacode = hotDataCode;
    }

    private String getAirlineCode(DictionaryReference<Airline> carrier) {
        if (carrier == null) {
            return null;
        }
        Airline airline = (Airline)DictionaryCache.get().resolveReference(carrier);
        if (airline == null) {
            return carrier.getCode();
        }
        String code = (String)airline.getCodeVariants().get(CodeSystem.IATA.name());
        if (code != null) {
            return code;
        }
        return airline.getCodeVariants().isEmpty() ? airline.getCode() : (String)airline.getCodeVariants().entrySet().iterator().next().getValue();
    }

    private String getAirlineNumber(DictionaryReference<Airline> carrier) {
        if (carrier == null) {
            return null;
        }
        Airline airline = (Airline)DictionaryCache.get().resolveReference(carrier);
        return airline != null ? airline.getAirlineNumber() : null;
    }

    public Money getBaseFare() {
        return this.baseFare;
    }

    public void setBaseFare(Money value) {
        this.baseFare = value;
    }

    public BigDecimal getBspCommissionAmount() {
        return this.bspCommissionAmount;
    }

    public void setBspCommissionAmount(BigDecimal value) {
        this.bspCommissionAmount = value;
    }

    public Double getBspCommissionRate() {
        return this.bspCommissionRate;
    }

    public void setBspCommissionRate(Double value) {
        this.bspCommissionRate = value == null || Double.isInfinite(value) || Double.isNaN(value) ? null : value;
    }

    public String getTravellerName() {
        return this.travellerName;
    }

    public void setTravellerName(String value) {
        this.travellerName = value;
    }

    public Collection<Tax> getTaxes() {
        return this.taxes;
    }

    public String getAirlineCode() {
        return this.airlineCode;
    }

    public String getAirlineNumber() {
        return this.airlineNumber;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String value) {
        this.transactionType = value;
    }

    public String getDatacode() {
        return this.datacode;
    }

    public int getItemNum() {
        return this.itemNum;
    }

    public void setItemNum(int value) {
        this.itemNum = value;
    }

    @Override
    public void setIssueDate(Date value) {
        this.issueDate = value;
    }

    @Override
    public void setEquivalentFare(BigDecimal value) {
        this.equivalentFare = value;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public void setPenalty(BigDecimal value) {
        this.penalty = value;
    }

    public static String getTraveller(String prodTravellerName) {
        if (TextUtil.isBlank((String)prodTravellerName)) {
            return null;
        }
        prodTravellerName = prodTravellerName.trim().toLowerCase(ruLocale);
        for (String gender : GENDERS) {
            if (prodTravellerName.endsWith(" " + gender)) {
                prodTravellerName = prodTravellerName.substring(0, prodTravellerName.length() - (" " + gender).length()).trim();
            }
            if (prodTravellerName.startsWith(gender + " ")) {
                prodTravellerName = prodTravellerName.substring((gender + " ").length()).trim();
            }
            prodTravellerName = prodTravellerName.replaceAll(" " + gender + " ", "");
        }
        prodTravellerName = prodTravellerName.replaceAll("/", " ");
        PersonalName result = new PersonalName(){
            private String firstName;
            private String lastName;
            private String middleName;

            public String getFirstName() {
                return this.firstName;
            }

            public String getLastName() {
                return this.lastName;
            }

            public String getMiddleName() {
                return this.middleName;
            }

            public void setFirstName(String value) {
                this.firstName = value;
            }

            public void setLastName(String value) {
                this.lastName = value;
            }

            public void setMiddleName(String value) {
                this.middleName = value;
            }
        };
        TextUtil.splitFullName((String)prodTravellerName, (PersonalName)result);
        return TextUtil.buildFullName((PersonalName)result, (boolean)false);
    }
}

