/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot;

import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot.DivergenceObjectsReportTicket;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class DivergencePoiWorksheetHandler
extends BasePoiWorksheetHandler<DivergenceObjectsReportTicket> {
    private static final int START_ROW_INDEX = 6;
    private static final int ROW_SHIFT_AMOUNT = 7;
    private static final int COLUMN_AMOUNT = 17;
    private HSSFSheet currentSheet;
    private int currentRow;
    private final NumberFormat numFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH));

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<DivergenceObjectsReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        this.currentSheet = sheet;
        this.currentSheet.setForceFormulaRecalculation(true);
        this.currentRow = 6;
        List<DivergenceObjectsReportTicket> tickets = data.getTickets();
        if (!tickets.isEmpty()) {
            for (int n = 0; n < tickets.size(); ++n) {
                DivergenceObjectsReportTicket ticket = tickets.get(n);
                this.addRow(ticket, n != 0);
            }
        }
    }

    private void addRow(DivergenceObjectsReportTicket ticket, boolean insertRow) throws Exception {
        if (insertRow) {
            ExcelUtils.insertRow((HSSFSheet)this.currentSheet, (int)(this.currentRow - 1), (int)17, (int)7);
        }
        String dataCode = ticket.getDatacode();
        for (Column column : Column.values()) {
            this.setFieldValue(ticket, dataCode, column);
        }
        ++this.currentRow;
    }

    private void setFieldValue(DivergenceObjectsReportTicket ticket, String dataCode, Column column) throws Exception {
        switch (column) {
            case ITEM_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (int)ticket.getItemNum());
                break;
            }
            case DATA_CODE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)dataCode);
                break;
            }
            case CARRIER_CODE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)(ticket.getAirlineCode() + " " + ticket.getAirlineNumber()));
                break;
            }
            case TICKET_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketNumber());
                break;
            }
            case TICKET_ISSUE_DATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (Date)ticket.getIssueDate());
                break;
            }
            case TICKET_PASSENGER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTravellerName());
                break;
            }
            case COMMISSION_RATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), ticket.getBspCommissionRate() != null ? BigDecimal.valueOf(ticket.getBspCommissionRate()) : null);
                break;
            }
            case COMMISSION_AMOUNT: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), ticket.getBspCommissionAmount() != null ? this.formatDecimal(ticket.getBspCommissionAmount()) : null);
                break;
            }
            case BASE_FARE: {
                if (ticket.getBaseFare() != null) {
                    Money baseFare = ticket.getBaseFare();
                    double fare = baseFare.getValue() != null ? baseFare.getValue().doubleValue() : 0.0;
                    String strCellVal = fare + "";
                    if (baseFare.getCurrency() != null) {
                        strCellVal = strCellVal + " " + baseFare.getCurrency();
                    }
                    ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)strCellVal);
                    break;
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)null);
                break;
            }
            case EQUIVALENT_FARE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getEquivalentFare());
                break;
            }
            case Transaction_TYPE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTransactionType());
                break;
            }
            case TAXES: {
                StringBuilder strTaxes = new StringBuilder();
                Collection<Tax> taxes = ticket.getTaxes();
                for (Tax tax : taxes) {
                    strTaxes.append((strTaxes.length() > 0 ? "; " : "") + tax.getCode() + " " + this.formatDecimal(tax.getEquivalentAmount()));
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)strTaxes.toString());
                break;
            }
        }
    }

    private String formatDecimal(BigDecimal val) {
        String result = "";
        if (val != null) {
            result = this.numFormat.format(val.doubleValue());
        }
        return result;
    }

    private static enum Column {
        ITEM_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        DATA_CODE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        CARRIER_CODE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        }
        ,
        TICKET_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.D;
            }
        }
        ,
        TICKET_ISSUE_DATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.E;
            }
        }
        ,
        TICKET_PASSENGER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.F;
            }
        }
        ,
        COMMISSION_RATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.G;
            }
        }
        ,
        COMMISSION_AMOUNT{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.H;
            }
        }
        ,
        BASE_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        EQUIVALENT_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.J;
            }
        }
        ,
        Transaction_TYPE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.K;
            }
        }
        ,
        TAXES{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.L;
            }
        };


        public abstract ExcelColumn getExcelColumn();
    }
}

