/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot.DivergenceObjectsReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot.DivergencePoiWorksheetHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HOTFilesDivergenceReportRenderHandler
extends BasePoiReportRenderHandler<DivergenceObjectsReportTicket> {
    private static final long serialVersionUID = -8062732866286052829L;

    protected String getTemplateFileName() {
        return "Divergence_HOT.xls";
    }

    @Override
    protected List<PoiWorksheetData<DivergenceObjectsReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<DivergenceObjectsReportTicket>> result = new ArrayList<PoiWorksheetData<DivergenceObjectsReportTicket>>();
        result.add(new BaseWorksheetData<DivergenceObjectsReportTicket>(){

            @Override
            public String getBatchId() {
                return "SALE";
            }

            @Override
            public PoiWorksheetDefinition<DivergenceObjectsReportTicket> getDefinition() {
                return Definitions.SALE;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        return result;
    }

    @Override
    public String getId() {
        return "hot-files-report";
    }

    @Override
    protected EntityContainer<DivergenceReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(DivergenceReportDocument.class);
        ((DivergenceReportDocument)result.getEntity()).getFiles().add(file);
        ((DivergenceReportDocument)result.getEntity()).setReportType(ReportType.HOT);
        List messages = (List)data.get("key-messages");
        ((DivergenceReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((DivergenceReportDocument)result.getEntity()).setParameters((DivergenceReportParameters)data.get("key-report-params"));
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        return IoUtil.getResourceInputStream((File)this.getTemplateFile());
    }

    protected File getTemplateFile() throws IOException {
        File result = IoUtil.url2file((URL)this.getClass().getResource("/salesreports/" + this.getTemplateFileName()));
        if (!result.exists() || !result.canRead()) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.HOTFilesDivergenceReportRender_templateNotFound, (Object[])new Object[]{result.getCanonicalPath()}).toString());
        }
        return result;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        DivergenceReportParameters params = (DivergenceReportParameters)data.get("key-report-params");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        StringBuilder sb = new StringBuilder();
        sb.append(params.getPeriodBegin() != null ? sdf.format(params.getPeriodBegin()) : "null");
        sb.append("-");
        sdf = new SimpleDateFormat("dd.MM.yyyy");
        sb.append(params.getPeriodEnd() != null ? sdf.format(params.getPeriodEnd()) : "null");
        return L10nResourcesManager.createL10nMessage((String)Messages.HOTFilesDivergenceReportRender_reportTitle, (Object[])new Object[]{sb.toString()}).toString();
    }

    public static enum Definitions implements PoiWorksheetDefinition<DivergenceObjectsReportTicket>
    {
        SALE{

            @Override
            public PoiWorksheetHandler<DivergenceObjectsReportTicket> getHandler() {
                return new DivergencePoiWorksheetHandler();
            }
        };


        @Override
        public String getWorksheetTemplateName() {
            return this.name();
        }

        @Override
        public PoiWorksheetHandler<DivergenceObjectsReportTicket> getHandler() {
            return null;
        }
    }
}

