/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.j2;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.j2.J2SalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.j2.J2SalesSummaryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.j2.J2TicketRefundRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.j2.J2TicketSalesRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class J2SalesReportRenderHandler
extends BasePoiReportRenderHandler<J2SalesReportTicket> {
    @Override
    public String getId() {
        return "j2-sales-report";
    }

    @Override
    protected List<PoiWorksheetData<J2SalesReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<J2SalesReportTicket>> result = new ArrayList<PoiWorksheetData<J2SalesReportTicket>>();
        result.add(new BaseWorksheetData<J2SalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SUMMARY_INFO";
            }

            @Override
            public PoiWorksheetDefinition<J2SalesReportTicket> getDefinition() {
                return Definitions.SUMMARY;
            }

            @Override
            public int getProirity() {
                return 0;
            }
        });
        result.add(new BaseWorksheetData<J2SalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SALE";
            }

            @Override
            public PoiWorksheetDefinition<J2SalesReportTicket> getDefinition() {
                return Definitions.SELL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<J2SalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "REFUND";
            }

            @Override
            public PoiWorksheetDefinition<J2SalesReportTicket> getDefinition() {
                return Definitions.REFUND;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        return result;
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).getFiles().add(file);
        ((ReportDocument)result.getEntity()).setReportType(ReportType.VENDOR);
        List messages = (List)data.get("key-messages");
        ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((ReportDocument)result.getEntity()).setParameters((ReportParameters)data.get("key-report-params"));
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        return IoUtil.getResourceInputStream((URL)BasePoiSalesReportRenderHandler.class.getResource("/salesreports/J2SalesReport.xls"));
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.J2ReportRenderHandler_reportTitle, (Object[])new Object[]{data.get("AGENCY_NAME"), data.get("KEY_REPORT_FILENAME")}).toString();
    }

    public static enum Definitions implements PoiWorksheetDefinition<J2SalesReportTicket>
    {
        SUMMARY{

            @Override
            public PoiWorksheetHandler<J2SalesReportTicket> getHandler() {
                return new J2SalesSummaryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "Pismo";
            }
        }
        ,
        SELL{

            @Override
            public PoiWorksheetHandler<J2SalesReportTicket> getHandler() {
                return new J2TicketSalesRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "Sell";
            }
        }
        ,
        REFUND{

            @Override
            public PoiWorksheetHandler<J2SalesReportTicket> getHandler() {
                return new J2TicketRefundRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "Refund";
            }
        };

    }
}

