/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.j2;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class J2SalesReportTicket
extends BaseSalesReportTicket
implements Comparable<J2SalesReportTicket> {
    private Commission commission = null;
    private BigDecimal fees = BigDecimal.ZERO;
    private String scn = null;
    private boolean duplicate = false;
    private String fopCodes = null;
    private int conjunctionCount = 0;
    private final Product product;
    private static final long serialVersionUID = -3254657649204276389L;

    public J2SalesReportTicket(Product aProduct, List<Message> messages) throws Exception {
        super(aProduct, messages);
        this.product = aProduct;
        if (this.product.getStatus() != ProductStatus.VOID) {
            Iterator iterator = AirProductHelper.getUnmodifiableCommissions((Product)this.product, (ContractType)ContractType.VENDOR).iterator();
            while (iterator.hasNext()) {
                Commission aCommission;
                this.commission = aCommission = (Commission)iterator.next();
            }
            for (Tax tax : this.product.getTaxes()) {
                if (tax.getCode() == null || tax.getCode().equalsIgnoreCase("CP") || tax.getEquivalentAmount() == null) continue;
                this.fees = this.fees.add(tax.getEquivalentAmount());
            }
        }
        if (aProduct.getProductCategory() == ProductCategory.AIR) {
            if (aProduct.getStatus() == ProductStatus.REFUND || aProduct.getStatus() == ProductStatus.EXCHANGE) {
                this.equivalentFare = this.equivalentFare.subtract(this.relatedProductEquivalentFare);
            }
            if (this.isExchangeTicket() || this.isRefundTicket()) {
                Collection mcos = AirProductHelper.getMcoByRelatedProduct((Product)this.product);
                for (Product mco : mcos) {
                    if (mco.getMcoCategory() != MCOCategory.REBOOKING && mco.getMcoCategory() != MCOCategory.PENALTY) continue;
                    this.penalty = AirProductHelper.getEquivalentFare((Product)mco);
                    break;
                }
                if (this.isExchangeTicket() && this.penalty == null) {
                    for (Tax tax : aProduct.getTaxes()) {
                        if (tax.getCode() == null || !tax.getCode().equalsIgnoreCase("CP")) continue;
                        this.penalty = tax.getEquivalentAmount();
                        break;
                    }
                }
            }
        }
        this.duplicate = this.product.isDuplicate();
        this.status = this.product.getStatus();
        if (this.product.getScns() != null && !this.product.getScns().isEmpty()) {
            this.scn = (String)this.product.getScns().get(0);
        }
        this.conjunctionCount = this.product.getConjCount();
    }

    public Commission getCommission() {
        return this.commission;
    }

    public BigDecimal getFee() {
        return this.fees;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean isVoidTicket() {
        return this.status == ProductStatus.VOID;
    }

    public boolean isSellTicket() {
        return this.status == ProductStatus.SELL && this.product.getPreviousProduct() == null;
    }

    public boolean isExchangeTicket() {
        return this.status == ProductStatus.SELL && this.product.getPreviousProduct() != null && this.product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
    }

    public boolean isRefundTicket() {
        return this.status == ProductStatus.REFUND;
    }

    public boolean isPenaltyMCO() {
        return this.status == ProductStatus.SELL && this.product.getProductCategory() == ProductCategory.MCO && this.product.getMcoCategory() == MCOCategory.PENALTY;
    }

    public boolean isVVL() {
        return AirProductHelper.getTransportationType((Product)this.product) == TransportationType.DOMESTIC;
    }

    public boolean isMVL() {
        return AirProductHelper.getTransportationType((Product)this.product) == TransportationType.INTERNATIONAL;
    }

    public String getScn() {
        return this.scn;
    }

    public String getFopCodes() {
        if (this.fops == null) {
            return null;
        }
        if (this.fopCodes == null) {
            StringBuilder result = new StringBuilder();
            for (ProductFop fop : this.fops) {
                if (fop == null || fop.getType() == null) continue;
                String fopType = fop.getType().name().substring(0, 2);
                if (result.toString().indexOf(fopType) >= 0) continue;
                result.append(fopType).append(";");
            }
            this.fopCodes = result.toString();
            if (this.fopCodes.endsWith(";")) {
                this.fopCodes = this.fopCodes.substring(0, this.fopCodes.length() - 1);
            }
        }
        return this.fopCodes;
    }

    public int getConjunctionCount() {
        return this.conjunctionCount;
    }

    @Override
    public int compareTo(J2SalesReportTicket o) {
        return this.getTicketNumber().compareTo(o.getTicketNumber());
    }

    public int hashCode() {
        return MiscUtil.hash((Object[])new Object[]{this.ticketNumber});
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof J2SalesReportTicket)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        J2SalesReportTicket item2 = (J2SalesReportTicket)obj;
        return TextUtil.isSame((String)this.ticketNumber, (String)item2.getTicketNumber());
    }
}

