/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.j2;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.j2.BaseJ2ReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.j2.J2SalesReportTicket;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class J2TicketRefundRegistryReportWorksheetHandler
extends BaseJ2ReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<J2SalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        int startRow = 8;
        int endRow = 13;
        int rowCounter = 0;
        if (data.getTickets().size() > 1) {
            sheet.shiftRows(startRow - 1, endRow - 1, data.getTickets().size() - 1);
        }
        int currentRow = startRow;
        String transactionName = null;
        HSSFCellStyle cellStyle = this.createCellStyle(wb);
        for (J2SalesReportTicket ticket : data.getTickets()) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)1, (int)(++rowCounter));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getTicketNumber());
            if (ticket.getConjunctionCount() > 0) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)3, (String)"\u0414\u0410");
            }
            if (ticket.isRefundTicket()) {
                transactionName = L10nResourcesManager.createL10nMessage((String)Messages.J2TicketRefundRegistry_refund, (Object[])new Object[0]).toString();
            } else if (ticket.isPenaltyMCO()) {
                transactionName = "MCO";
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)transactionName);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (BigDecimal)(ticket.isRefundTicket() ? ticket.getEquivalentFare().negate() : ticket.getEquivalentFare()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (BigDecimal)(ticket.isRefundTicket() ? ticket.getFee().negate() : ticket.getFee()));
            if (ticket.getCommission() != null && ticket.getCommission().getRate() != null) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (Double)ticket.getCommission().getRate());
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (String)ticket.getFopCodes());
            if (ticket.isEticket()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)"E");
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)ticket.getScn());
            }
            this.formatRow(sheet, currentRow, cellStyle);
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (String)String.format("=SUM(E%s:E%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (String)String.format("=SUM(F%s:F%s)", startRow, endRow));
    }

    private void formatRow(HSSFSheet sheet, int currentRow, HSSFCellStyle cellStyle) {
        HSSFRow row = sheet.getRow(currentRow - 1);
        for (int i = 0; i < 10; ++i) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            cell.setCellStyle(cellStyle);
        }
    }
}

