/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.kv;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVSalesSummaryBreakDownReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVSalesSummaryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVTicketExchangeRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVTicketRefundRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVTicketSalesRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KVSalesReportRenderHandler
extends BasePoiReportRenderHandler<KVSalesReportTicket> {
    @Override
    public String getId() {
        return "kv-sales-report";
    }

    @Override
    protected List<PoiWorksheetData<KVSalesReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<KVSalesReportTicket>> result = new ArrayList<PoiWorksheetData<KVSalesReportTicket>>();
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SUMMARY_INFO";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.SUMMARY;
            }

            @Override
            public int getProirity() {
                return 0;
            }
        });
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SUMMARY_INFO";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.SUMMARY_BREAKDOWN;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "VVL_SALE";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.VVL_SELL;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MVL_SALE";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.MVL_SELL;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "VVL_EXCHANGE";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.VVL_EXCHANGE;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MVL_EXCHANGE";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.MVL_EXCHANGE;
            }

            @Override
            public int getProirity() {
                return 5;
            }
        });
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "VVL_REFUND";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.VVL_REFUND;
            }

            @Override
            public int getProirity() {
                return 6;
            }
        });
        result.add(new BaseWorksheetData<KVSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MVL_REFUND";
            }

            @Override
            public PoiWorksheetDefinition<KVSalesReportTicket> getDefinition() {
                return Definitions.MVL_REFUND;
            }

            @Override
            public int getProirity() {
                return 7;
            }
        });
        return result;
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).getFiles().add(file);
        ((ReportDocument)result.getEntity()).setReportType(ReportType.VENDOR);
        List messages = (List)data.get("key-messages");
        ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((ReportDocument)result.getEntity()).setParameters((ReportParameters)data.get("key-report-params"));
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        return IoUtil.getResourceInputStream((URL)BasePoiSalesReportRenderHandler.class.getResource("/salesreports/KVSalesReport.xls"));
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRender_reportTitle, (Object[])new Object[]{data.get("AGENCY_NAME"), data.get("KEY_REPORT_FILENAME")}).toString();
    }

    public static enum Definitions implements PoiWorksheetDefinition<KVSalesReportTicket>
    {
        SUMMARY{

            public KVSalesSummaryReportWorksheetHandler getHandler() {
                return new KVSalesSummaryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_summary, (Object[])new Object[0]).toString();
            }
        }
        ,
        SUMMARY_BREAKDOWN{

            public KVSalesSummaryBreakDownReportWorksheetHandler getHandler() {
                return new KVSalesSummaryBreakDownReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_summaryBreakdown, (Object[])new Object[0]).toString();
            }
        }
        ,
        VVL_SELL{

            @Override
            public PoiWorksheetHandler<KVSalesReportTicket> getHandler() {
                return new KVTicketSalesRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_vvlSell, (Object[])new Object[0]).toString();
            }
        }
        ,
        MVL_SELL{

            @Override
            public PoiWorksheetHandler<KVSalesReportTicket> getHandler() {
                return new KVTicketSalesRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_mvlSell, (Object[])new Object[0]).toString();
            }
        }
        ,
        VVL_EXCHANGE{

            @Override
            public PoiWorksheetHandler<KVSalesReportTicket> getHandler() {
                return new KVTicketExchangeRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_vvlExchange, (Object[])new Object[0]).toString();
            }
        }
        ,
        MVL_EXCHANGE{

            @Override
            public PoiWorksheetHandler<KVSalesReportTicket> getHandler() {
                return new KVTicketExchangeRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_mvlExchange, (Object[])new Object[0]).toString();
            }
        }
        ,
        VVL_REFUND{

            @Override
            public PoiWorksheetHandler<KVSalesReportTicket> getHandler() {
                return new KVTicketRefundRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_vvlRefund, (Object[])new Object[0]).toString();
            }
        }
        ,
        MVL_REFUND{

            @Override
            public PoiWorksheetHandler<KVSalesReportTicket> getHandler() {
                return new KVTicketRefundRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.KVSalesReportRenderHandler_mvlRefund, (Object[])new Object[0]).toString();
            }
        };

    }
}

