/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.kv;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class KVSalesReportTicket
extends BaseSalesReportTicket {
    private String route = null;
    private Commission commission = null;
    private BigDecimal fees = BigDecimal.ZERO;
    private BigDecimal airlineFees = BigDecimal.ZERO;
    private BigDecimal mcoPenalty = BigDecimal.ZERO;
    private boolean duplicate = false;
    private TransportationType transportationType = null;
    private Date flightDate = null;
    private Date sellDate = null;
    private Product product = null;
    private KVSalesReportTicket exchangedProduct = null;
    private static String[] airlineTaxes = new String[]{"YQ", "YR", "RU"};
    private static final long serialVersionUID = -3254657649204276389L;

    public KVSalesReportTicket(Product aProduct, List<Message> messages) throws Exception {
        super(aProduct, messages);
        this.product = aProduct;
        this.transportationType = AirProductHelper.getTransportationType((Product)aProduct);
        this.route = AirProductHelper.getRouteLine((Product)aProduct);
        if (this.product.getStatus() != ProductStatus.VOID) {
            Iterator iterator = AirProductHelper.getUnmodifiableCommissions((Product)this.product, (ContractType)ContractType.VENDOR).iterator();
            while (iterator.hasNext()) {
                Commission aCommission;
                this.commission = aCommission = (Commission)iterator.next();
            }
            for (Object tax : this.product.getTaxes()) {
                if (tax.getCode() == null || tax.getEquivalentAmount() == null) continue;
                if (Arrays.asList(airlineTaxes).contains(tax.getCode())) {
                    this.fees = this.fees.add(tax.getEquivalentAmount());
                    continue;
                }
                this.airlineFees = this.airlineFees.add(tax.getEquivalentAmount());
            }
        }
        if (aProduct.getProductCategory() == ProductCategory.AIR && (aProduct.getStatus() == ProductStatus.REFUND || aProduct.getStatus() == ProductStatus.EXCHANGE) && this.mcoPenalty != null && this.mcoPenalty.equals(BigDecimal.ZERO)) {
            Collection mcos = AirProductHelper.getMcoByRelatedProduct((Product)this.product);
            for (Product mco : mcos) {
                if (mco.getMcoCategory() != MCOCategory.PENALTY && mco.getMcoCategory() != MCOCategory.REBOOKING) continue;
                this.mcoPenalty = AirProductHelper.getBaseFare((Product)mco).getValue();
            }
        }
        this.duplicate = this.product.isDuplicate();
        this.status = this.product.getStatus();
        block3: for (SegmentTariff segmentTariff : this.product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (this.flightDate != null) continue;
                this.flightDate = segment.getStartDate();
                continue block3;
            }
        }
        if (this.status == ProductStatus.SELL) {
            this.sellDate = this.issueDate;
            if (this.product.getPreviousProduct() != null && this.product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                this.exchangedProduct = new KVSalesReportTicket(this.product.getPreviousProduct(), messages);
            }
        } else if (this.status == ProductStatus.REFUND && this.product.getPreviousProduct() != null && this.product.getPreviousProduct().getIssueDate() != null) {
            this.sellDate = this.product.getPreviousProduct().getIssueDate();
        }
    }

    public String getRoute() {
        return this.route;
    }

    public Commission getCommission() {
        return this.commission;
    }

    public BigDecimal getFee() {
        return this.fees;
    }

    public BigDecimal getAirlineFee() {
        return this.airlineFees;
    }

    public BigDecimal getMcoPenalty() {
        return this.mcoPenalty;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean isVoidTicket() {
        return this.status == ProductStatus.VOID;
    }

    public boolean isSellTicket() {
        return this.status == ProductStatus.SELL;
    }

    public boolean isExchangeTicket() {
        return this.status == ProductStatus.SELL && this.product.getPreviousProduct() != null && this.product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
    }

    public boolean isRefundTicket() {
        return this.status == ProductStatus.REFUND;
    }

    public boolean isVVL() {
        return this.transportationType != null && this.transportationType == TransportationType.DOMESTIC;
    }

    public boolean isMVL() {
        return this.transportationType != null && this.transportationType == TransportationType.INTERNATIONAL;
    }

    public Date getFlightDate() {
        return this.flightDate;
    }

    public Date getSellDate() {
        return this.sellDate;
    }

    public KVSalesReportTicket getExchangedProduct() {
        return this.exchangedProduct;
    }
}

