/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.na;

import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSalesReportBaseWorksheetHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class NaSalesReportRefundWorksheetHandler
extends NaSalesReportBaseWorksheetHandler {
    static DictionaryReference<Airline> airlineRef = DictHelper.findAirlineByAnyCode((String)"5N").toReference();

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        String currentValidatorCode = null;
        String previousValidatorCode = null;
        int currentRow = 0;
        int index = 0;
        for (BaseSalesReportTicket ticket : data.getTickets()) {
            BigDecimal penaltyTaxesEquivalentAmount;
            currentValidatorCode = ticket.getValidatorCode();
            if (previousValidatorCode == null || !currentValidatorCode.equals(previousValidatorCode)) {
                previousValidatorCode = currentValidatorCode;
                currentRow = currentRow == 0 ? 20 : (currentRow += 2);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)currentValidatorCode);
                index = 0;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(++currentRow), (int)1, (int)(++index));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)ticket.getCouponsList());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (Date)ticket.getIssueDate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (BigDecimal)ticket.getEquivalentFare());
            Collection<Tax> taxes = ticket.getTaxes();
            BigDecimal penalty = penaltyTaxesEquivalentAmount = AirProductTaxHelper.getEquivalentTaxesAmount(taxes, (String[])AirProductTaxHelper.getPenaltyTaxesCodes(airlineRef));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (BigDecimal)penalty);
            BigDecimal taxesEquivalentAmount = null;
            taxesEquivalentAmount = AirProductTaxHelper.getEquivalentTaxesAmount(taxes).subtract(penaltyTaxesEquivalentAmount);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (BigDecimal)taxesEquivalentAmount);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (Double)ticket.getVendorCommissionRate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (BigDecimal)ticket.getVendorEquivalentCommission());
            StringBuilder formula = new StringBuilder();
            formula.append(ExcelUtils.indexToLetter((int)6) + String.valueOf(currentRow));
            formula.append("+");
            formula.append(ExcelUtils.indexToLetter((int)7) + String.valueOf(currentRow));
            formula.append("+");
            formula.append(ExcelUtils.indexToLetter((int)8) + String.valueOf(currentRow));
            formula.append("-");
            formula.append(ExcelUtils.indexToLetter((int)10) + String.valueOf(currentRow));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (String)String.format("=%s", formula.toString()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)12, (String)ticket.getFopsName());
        }
    }

    @Override
    protected int[] getColumnsNumber() {
        return new int[]{6, 7, 8, 10, 11};
    }
}

