/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.na;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSummaryReportItem;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class NaSummaryReportWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    private static int BEGIN_ROW = 17;

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.updateGlobalData(sheet, globalData);
        TreeMap items = (TreeMap)globalData.get("key-registry-letters-data");
        if (items == null) {
            return;
        }
        String psSell = ProductStatus.SELL.name();
        String psRef = ProductStatus.REFUND.name();
        this.updateLine(sheet, BEGIN_ROW, items, psSell + NaSummaryReportItem.FieldDefinition.Fare.name());
        this.updateLine(sheet, BEGIN_ROW + 1, items, psSell + NaSummaryReportItem.FieldDefinition.YqTax.name());
        this.updateLine(sheet, BEGIN_ROW + 2, items, psSell + NaSummaryReportItem.FieldDefinition.RuTax.name());
        this.updateLine(sheet, BEGIN_ROW + 3, items, psSell + NaSummaryReportItem.FieldDefinition.OtherTax.name());
        this.updateLine(sheet, BEGIN_ROW + 4, items, psSell + NaSummaryReportItem.FieldDefinition.Comm.name());
        this.updateLine(sheet, BEGIN_ROW + 6, items, psRef + NaSummaryReportItem.FieldDefinition.Fare.name());
        this.updateLine(sheet, BEGIN_ROW + 7, items, psRef + NaSummaryReportItem.FieldDefinition.YqTax.name());
        this.updateLine(sheet, BEGIN_ROW + 8, items, psRef + NaSummaryReportItem.FieldDefinition.RuTax.name());
        this.updateLine(sheet, BEGIN_ROW + 9, items, psRef + NaSummaryReportItem.FieldDefinition.OtherTax.name());
        this.updateLine(sheet, BEGIN_ROW + 10, items, psRef + NaSummaryReportItem.FieldDefinition.Penalty.name());
        this.updateLine(sheet, BEGIN_ROW + 11, items, psRef + NaSummaryReportItem.FieldDefinition.Comm.name());
        this.updateLine(sheet, BEGIN_ROW + 13, items, psSell + NaSummaryReportItem.FieldDefinition.CashFop.name());
        this.updateLine(sheet, BEGIN_ROW + 20, items, psSell + NaSummaryReportItem.FieldDefinition.Penalty.name());
        this.updateLine(sheet, BEGIN_ROW + 32, items, psSell + NaSummaryReportItem.FieldDefinition.Tickets.name());
        this.updateLine(sheet, BEGIN_ROW + 33, items, psRef + NaSummaryReportItem.FieldDefinition.Tickets.name());
    }

    private void updateLine(HSSFSheet sheet, int lineNo, Map<String, NaSummaryReportItem> items, String key) throws Exception {
        NaSummaryReportItem itemMvl = items.get(TransportationType.INTERNATIONAL.name() + key);
        NaSummaryReportItem itemVvl = items.get(TransportationType.DOMESTIC.name() + key);
        if (itemMvl == null && itemVvl == null) {
            return;
        }
        if (itemMvl == null) {
            itemMvl = new NaSummaryReportItem();
            itemMvl.fieldDef = itemVvl.fieldDef;
        }
        if (itemVvl == null) {
            itemVvl = new NaSummaryReportItem();
        }
        switch (itemMvl.fieldDef) {
            case Tickets: {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)3, (int)itemVvl.cnt);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)5, (int)itemMvl.cnt);
                break;
            }
            default: {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)3, (BigDecimal)BigDecimal.valueOf(itemVvl.sum));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)5, (BigDecimal)BigDecimal.valueOf(itemMvl.sum));
            }
        }
    }
}

