/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.s7;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.finance.VendorReportPaymentType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.support.reports.ReportCreditBankTransferOrderInfo;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7RegistryLetterItem;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class S7RegistryPismoWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    private static final Comparator<ReportCreditBankTransferOrderInfo> transferOrdersComparator = new Comparator<ReportCreditBankTransferOrderInfo>(){

        @Override
        public int compare(ReportCreditBankTransferOrderInfo o1, ReportCreditBankTransferOrderInfo o2) {
            int res = MiscUtil.compare((Date)MiscUtil.clearTime((Date)o1.getDate()), (Date)MiscUtil.clearTime((Date)o2.getDate()));
            if (res != 0) {
                return res;
            }
            return TextUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)false, (boolean)false);
        }
    };
    private static int BEGIN_ROW = 12;

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        ArrayList transferOrders;
        TreeMap agencyMemoItems;
        this.updateGlobalData(sheet, globalData);
        this.updateGlobalDataS7(sheet, globalData);
        sheet.setForceFormulaRecalculation(true);
        TreeMap items = (TreeMap)globalData.get("key-registry-letters-data");
        if (items != null) {
            String sellKey = ProductStatus.SELL.name();
            String refundKey = ProductStatus.REFUND.name();
            this.updateProductLine(sheet, BEGIN_ROW, items, Arrays.asList(sellKey + S7RegistryLetterItem.FieldDefinition.Fare.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 1, items, Arrays.asList(sellKey + S7RegistryLetterItem.FieldDefinition.Penalty.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 2, items, Arrays.asList(sellKey + S7RegistryLetterItem.FieldDefinition.RuTax.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 3, items, Arrays.asList(sellKey + S7RegistryLetterItem.FieldDefinition.YqTax.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 4, items, Arrays.asList(sellKey + S7RegistryLetterItem.FieldDefinition.OtherTax.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 5, items, Arrays.asList(sellKey + S7RegistryLetterItem.FieldDefinition.Comm.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 7, items, Arrays.asList(refundKey + S7RegistryLetterItem.FieldDefinition.Fare.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 8, items, Arrays.asList(refundKey + S7RegistryLetterItem.FieldDefinition.RuTax.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 9, items, Arrays.asList(refundKey + S7RegistryLetterItem.FieldDefinition.YqTax.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 10, items, Arrays.asList(refundKey + S7RegistryLetterItem.FieldDefinition.OtherTax.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 11, items, Arrays.asList(refundKey + S7RegistryLetterItem.FieldDefinition.Penalty.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 12, items, Arrays.asList(refundKey + S7RegistryLetterItem.FieldDefinition.Comm.name()));
            this.updateProductLine(sheet, BEGIN_ROW + 16, items, Arrays.asList(sellKey + S7RegistryLetterItem.FieldDefinition.OtherFop.name(), refundKey + S7RegistryLetterItem.FieldDefinition.OtherFop.name()));
        }
        if ((agencyMemoItems = (TreeMap)globalData.get("key-agency-memos-registry-letter-data")) != null) {
            this.updateAgencyMemoLine(sheet, BEGIN_ROW + 18, agencyMemoItems, S7RegistryLetterItem.FieldDefinition.Fare.name());
            this.updateAgencyMemoLine(sheet, BEGIN_ROW + 19, agencyMemoItems, S7RegistryLetterItem.FieldDefinition.RuTax.name());
            this.updateAgencyMemoLine(sheet, BEGIN_ROW + 20, agencyMemoItems, S7RegistryLetterItem.FieldDefinition.YqTax.name());
            this.updateAgencyMemoLine(sheet, BEGIN_ROW + 21, agencyMemoItems, S7RegistryLetterItem.FieldDefinition.OtherTax.name());
            this.updateAgencyMemoLine(sheet, BEGIN_ROW + 22, agencyMemoItems, S7RegistryLetterItem.FieldDefinition.Penalty.name());
            this.updateAgencyMemoLine(sheet, BEGIN_ROW + 23, agencyMemoItems, S7RegistryLetterItem.FieldDefinition.Comm.name());
        }
        if ((transferOrders = (ArrayList)globalData.get("key-bank-transfer-orders-list")) != null) {
            int n;
            transferOrders = new ArrayList(transferOrders);
            Collections.sort(transferOrders, transferOrdersComparator);
            if (transferOrders.size() > 6) {
                for (n = 0; n < transferOrders.size() - 6; ++n) {
                    ExcelUtils.copyRows((HSSFSheet)sheet, (int)(BEGIN_ROW + 28), (int)(BEGIN_ROW + 28));
                }
                for (n = 1; n <= transferOrders.size(); ++n) {
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(BEGIN_ROW + 27), (int)1, (int)n, (int)1, (String)String.format("8.%s", Integer.toString(n)));
                }
            }
            for (n = 1; n <= transferOrders.size(); ++n) {
                ReportCreditBankTransferOrderInfo transferOrder = (ReportCreditBankTransferOrderInfo)transferOrders.get(n - 1);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(BEGIN_ROW + 27), (int)1, (int)n, (int)2, (String)transferOrder.getName());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(BEGIN_ROW + 27), (int)1, (int)n, (int)7, (BigDecimal)transferOrder.getAmount());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(BEGIN_ROW + 27), (int)1, (int)n, (int)8, (BigDecimal)(transferOrder.getPaymentType() == VendorReportPaymentType.MVL ? transferOrder.getAmount() : BigDecimal.ZERO));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(BEGIN_ROW + 27), (int)1, (int)n, (int)9, (BigDecimal)(transferOrder.getPaymentType() == VendorReportPaymentType.MVL ? BigDecimal.ZERO : transferOrder.getAmount()));
            }
        }
    }

    private void updateGlobalDataS7(HSSFSheet sheet, Map<String, Object> data) {
        Date contractDate = (Date)data.get("CONTRACT_ISSUE_DATE");
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_ISSUE_DATE", contractDate != null ? this.df.format(contractDate) : null);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_EMAIL", (String)((String)data.get("AGENCY_EMAIL")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DIRECTOR", (String)((String)data.get("DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"ACCOUNTANT", (String)((String)data.get("ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"EQ_CUR_CODE", (String)DictHelper.getLocalCurrency());
    }

    private void updateProductLine(HSSFSheet sheet, int lineNo, Map<String, S7RegistryLetterItem> items, List<String> keys) throws Exception {
        BigDecimal amountMvl = BigDecimal.ZERO;
        BigDecimal amountVvl = BigDecimal.ZERO;
        for (String key : keys) {
            S7RegistryLetterItem itemMvl = items.get(TransportationType.INTERNATIONAL.name() + key);
            S7RegistryLetterItem itemVvl = items.get(TransportationType.DOMESTIC.name() + key);
            if (itemMvl != null) {
                amountMvl = amountMvl.add(BigDecimal.valueOf(itemMvl.sum));
            }
            if (itemVvl == null) continue;
            amountVvl = amountVvl.add(BigDecimal.valueOf(itemVvl.sum));
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)8, (BigDecimal)amountMvl);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)9, (BigDecimal)amountVvl);
    }

    private void updateAgencyMemoLine(HSSFSheet sheet, int lineNo, Map<String, S7RegistryLetterItem> items, String key) throws Exception {
        BigDecimal amountMvl = BigDecimal.ZERO;
        BigDecimal amountVvl = BigDecimal.ZERO;
        S7RegistryLetterItem itemMvl = items.get(TransportationType.INTERNATIONAL.name() + key);
        S7RegistryLetterItem itemVvl = items.get(TransportationType.DOMESTIC.name() + key);
        if (itemMvl != null) {
            amountMvl = BigDecimal.valueOf(itemMvl.sum);
        }
        if (itemVvl != null) {
            amountVvl = BigDecimal.valueOf(itemVvl.sum);
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)8, (BigDecimal)amountMvl);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)9, (BigDecimal)amountVvl);
    }
}

