/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.s7;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class S7Ticket
extends SuTicket {
    private static final long serialVersionUID = -3672899468325668815L;

    public S7Ticket() {
    }

    public S7Ticket(Product product, List<Message> messages) throws Exception {
        super(product, messages);
    }

    @Override
    protected void setupDuplicate(Product product, List<Message> messages) throws Exception {
        Product firstProduct = null;
        Product mco = null;
        for (Product relProd : product.getRelatedProducts()) {
            if (relProd.getStatus() != ProductStatus.SELL || relProd.getProductCategory() != ProductCategory.AIR) continue;
            firstProduct = relProd;
            break;
        }
        for (Product mcoProd : AirProductHelper.getMcoByRelatedProduct((Product)product)) {
            if (mcoProd.getMcoCategory() != MCOCategory.DUPLICATE_TICKET) continue;
            mco = mcoProd;
            break;
        }
        if (firstProduct != null) {
            ArrayList<Message> msgs;
            SuTicket firstTicket;
            Money firstBaseFare = AirProductHelper.getBaseFare(firstProduct);
            BigDecimal firstEquivFare = AirProductHelper.getEquivalentFare((Product)firstProduct);
            if (this.baseFare != null && firstBaseFare != null && this.baseFare.getValue() != null && firstBaseFare.getValue() != null) {
                this.baseFare.setValue(this.baseFare.getValue().subtract(firstBaseFare.getValue()));
            }
            if (this.equivalentFare != null && firstEquivFare != null) {
                this.equivalentFare = this.equivalentFare.subtract(firstEquivFare);
            }
            this.retainTaxes(firstProduct.getTaxes());
            if (this.vendorEquivalentCommission != null && (firstTicket = new SuTicket(firstProduct, msgs = new ArrayList<Message>())).getVendorEquivalentCommission() != null) {
                this.vendorEquivalentCommission = this.vendorEquivalentCommission.subtract(firstTicket.getVendorEquivalentCommission());
            }
        }
        if (mco != null) {
            for (Tax tax : mco.getTaxes()) {
                Tax newTax = (Tax)XCloneHelper.clone((XCloneable)tax);
                this.taxes.add(newTax);
            }
            BigDecimal mcoPenalty = AirProductHelper.getEquivalentFare((Product)mco);
            if (mcoPenalty != null) {
                Tax tax;
                tax = new Tax();
                tax.setCode("P4");
                tax.setEquivalentAmount(mcoPenalty);
                tax.setAmount(new Money());
                tax.getAmount().setValue(mcoPenalty);
                tax.getAmount().setCurrency(DictHelper.getLocalCurrency());
                this.taxes.add(tax);
            }
            this.fops.clear();
            for (ProductFop fop : AirProductHelper.getVendorContractRelation((Product)mco).getFops()) {
                this.fops.add(XCloneHelper.clone((XCloneable)fop));
            }
        }
        if (firstProduct != null) {
            ProductFop fop = new ProductFop();
            fop.setAmount(new Money());
            fop.getAmount().setValue(BigDecimal.ZERO);
            fop.getAmount().setCurrency(DictHelper.getLocalCurrency());
            fop.setRelatedTicketNumber(firstProduct.getSystemNumber());
            fop.setType(PaymentType.TICKET);
            this.fops.add(fop);
        }
    }

    private String getTaxMapKey(Tax tax) {
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank((String)tax.getCode())) {
            result.append(tax.getCode());
        }
        if (tax.getSegmentTariff() != null) {
            if (result.length() > 0) {
                result.append("_");
            }
            for (Segment seg : tax.getSegmentTariff().getSegments()) {
                result.append(seg.getRecordNumber());
            }
        }
        return result.toString();
    }

    private void retainTaxes(Collection<Tax> taxesToRemove) {
        String key;
        HashMap<String, Tax> mapedTaxes = new HashMap<String, Tax>();
        for (Tax tax : this.taxes) {
            key = this.getTaxMapKey(tax);
            mapedTaxes.put(key, tax);
        }
        for (Tax tax : taxesToRemove) {
            key = this.getTaxMapKey(tax);
            Tax t = (Tax)mapedTaxes.get(key);
            if (t == null || t.getEquivalentAmount() == null || tax.getEquivalentAmount() == null) continue;
            if (t.getEquivalentAmount().compareTo(tax.getEquivalentAmount()) == 0) {
                this.taxes.remove(t);
                continue;
            }
            t.setEquivalentAmount(t.getEquivalentAmount().subtract(tax.getEquivalentAmount()));
        }
    }
}

