/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.s7.tripartite;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;

public class S7TripartiteReportTicket
extends BaseSalesReportTicket {
    private static final long serialVersionUID = 8224848454180862306L;
    private final String traveller;
    private final LinkedHashSet<String> flightNumbers = new LinkedHashSet();
    private final LinkedHashSet<Date> flightDates = new LinkedHashSet();
    private final String routeLine;
    private String fareBasis;
    private final String contractCode;
    private final BigDecimal discountValue;
    private BigDecimal taxesTotal;

    public S7TripartiteReportTicket(Product ticket, List<Message> messages) throws Exception {
        super(ticket, messages);
        this.traveller = ticket.getTraveller().getName();
        this.contractCode = ticket.getTripartiteContractDetails().getContractCode();
        this.discountValue = ticket.getTripartiteContractDetails().getDiscountValue();
        this.routeLine = AirProductHelper.getRouteLine((Product)ticket, (Locale)new Locale("ru"), (boolean)true, (CodeSystem)CodeSystem.IATA);
        for (SegmentTariff st : ticket.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!TextUtil.isBlank((String)seg.getFareBasis())) {
                    this.fareBasis = seg.getFareBasis();
                }
                if (!TextUtil.isBlank((String)seg.getFlightNo())) {
                    this.flightNumbers.add(seg.getFlightNo());
                }
                if (seg.getStartDate() == null) continue;
                this.flightDates.add(MiscUtil.clearTime((Date)seg.getStartDate()));
            }
        }
        if (this.equivalentFare == null) {
            this.equivalentFare = BigDecimal.ZERO;
        }
        this.taxesTotal = BigDecimal.ZERO;
        for (Tax tax : ticket.getTaxes()) {
            if (tax.getEquivalentAmount() == null) continue;
            this.taxesTotal = this.taxesTotal.add(tax.getEquivalentAmount());
        }
        if (this.penalty == null) {
            this.penalty = BigDecimal.ZERO;
        }
    }

    public String getFlightNumbers() {
        StringBuilder sb = new StringBuilder();
        for (String fn : this.flightNumbers) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(fn.trim());
        }
        return sb.toString();
    }

    public String getFlightDates() {
        if (this.flightDates.isEmpty()) {
            return null;
        }
        if (this.flightDates.size() == 1) {
            return new SimpleDateFormat("dd.MM.yy").format((Date)this.flightDates.iterator().next());
        }
        Date firstDate = (Date)this.flightDates.iterator().next();
        Date lastDate = new ArrayList<Date>(this.flightDates).get(this.flightDates.size() - 1);
        return String.format("%s-%s", new SimpleDateFormat("dd.MM").format(firstDate), new SimpleDateFormat("dd.MM.yy").format(lastDate));
    }

    public String getFormatedIssueDate() {
        return this.issueDate == null ? null : new SimpleDateFormat("dd.MM.yy").format(this.issueDate);
    }

    public String getRouteLine() {
        return this.routeLine;
    }

    public String getContractCode() {
        return this.contractCode;
    }

    public BigDecimal getFullFare() {
        if (this.discountValue != null) {
            return this.equivalentFare.add(this.discountValue);
        }
        return this.equivalentFare;
    }

    public BigDecimal getTaxesTotal() {
        return this.taxesTotal;
    }

    public BigDecimal getProductTotal() {
        return this.taxesTotal.add(this.equivalentFare);
    }

    public String getFareBasis() {
        return this.fareBasis;
    }

    public String getTraveller() {
        return this.traveller;
    }
}

