/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuPaymentCardSalesBaseWorksheetHandler
extends BasePoiWorksheetHandler<SuTicket> {
    private final Map<String, BigDecimal> totals = new HashMap<String, BigDecimal>();

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SuTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, null, globalData);
        int rowCounter = 0;
        int currentRow = 5;
        int currentColumn = 6;
        String previousSecurityCode = null;
        boolean fillAllRow = false;
        this.calculateTotals(data.getTickets());
        for (SuTicket ticket : data.getTickets()) {
            if (currentRow > sheet.getLastRowNum() + 1) {
                sheet.createRow(currentRow);
            }
            if (fillAllRow = previousSecurityCode == null || !ticket.getPaymentCardSecurityCode().equals(previousSecurityCode)) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)1, (int)1, (int)1, (int)(++rowCounter));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)2, (int)1, (int)1, (String)this.getPaymentCardVendorCode(ticket.getPaymentCardVendor()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)3, (int)1, (int)1, (String)ticket.getCreditCardNo());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)4, (int)1, (int)1, (String)ticket.getValidatorCode());
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)5, (int)1, (int)1, (String)String.format("%s %s", ticket.getProduct().getBlankOwnerNumber(), ticket.getTicketNumber()));
            if (ticket.getPrevTicket() != null && ticket.getPrevTicket().getStatus() == ProductStatus.EXCHANGE) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)6, (int)1, (int)1, (String)String.format("%s %s", ticket.getPrevTicket().getBlankOwnerNumber(), ticket.getPrevTicket().getSystemNumber()));
                currentColumn = 7;
            } else {
                currentColumn = 6;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)currentColumn, (int)1, (int)1, (Date)ticket.getIssueDate());
            ++currentColumn;
            if (fillAllRow) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)currentColumn, (int)1, (int)1, (BigDecimal)this.totals.get(ticket.getPaymentCardSecurityCode()));
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)currentColumn, (int)1, (int)1, (int)0);
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)(++currentColumn), (int)1, (int)1, (int)0);
            ++currentColumn;
            if (fillAllRow) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)currentColumn, (int)1, (int)1, (String)ticket.getPaymentCardSecurityCode());
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentRow, (int)currentColumn, (int)1, (int)1, (String)"00");
            }
            ++currentRow;
            previousSecurityCode = ticket.getPaymentCardSecurityCode();
        }
    }

    private String getPaymentCardVendorCode(CardVendor cardVendor) {
        String result = "";
        if (cardVendor != null) {
            switch (cardVendor) {
                case VISA: {
                    result = "VI";
                    break;
                }
                case MASTERCARD: {
                    result = "MC";
                    break;
                }
                case AMEX: {
                    result = "AX";
                    break;
                }
                case JCB: {
                    result = "JB";
                    break;
                }
                case DINERS_CLUB: {
                    result = "DC";
                    break;
                }
                case AIR_TRAVEL_CARD: {
                    result = "TP";
                    break;
                }
                case MIR: {
                    result = "MR";
                }
            }
        }
        return result;
    }

    private void calculateTotals(List<SuTicket> tickets) {
        for (SuTicket ticket : tickets) {
            if (this.totals.containsKey(ticket.getPaymentCardSecurityCode())) {
                this.totals.put(ticket.getPaymentCardSecurityCode(), this.totals.get(ticket.getPaymentCardSecurityCode()).add(ticket.getCreditCardValue()));
                continue;
            }
            this.totals.put(ticket.getPaymentCardSecurityCode(), ticket.getCreditCardValue());
        }
    }
}

