/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.SuPaymentCardSalesBaseWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.SuPaymentCardSalesTotalWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SuPaymentCardSalesReportRenderHandler
extends BasePoiReportRenderHandler<SuTicket> {
    @Override
    public String getId() {
        return "su-payment-card-sales-report";
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).getFiles().add(file);
        List messages = (List)data.get("key-messages");
        ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((ReportDocument)result.getEntity()).setReportType(ReportType.VENDOR);
        ReportParameters reportParameters = (ReportParameters)data.get("key-report-params");
        ((ReportDocument)result.getEntity()).setParameters(reportParameters);
        return result;
    }

    @Override
    protected List<PoiWorksheetData<SuTicket>> createDataList() {
        ArrayList<PoiWorksheetData<SuTicket>> list = new ArrayList<PoiWorksheetData<SuTicket>>();
        list.add(new BaseWorksheetData<SuTicket>(){

            @Override
            public String getBatchId() {
                return "CANCEL";
            }

            @Override
            public PoiWorksheetDefinition<SuTicket> getDefinition() {
                return Definitions.TOTAL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        list.add(new BaseWorksheetData<SuTicket>(){

            @Override
            public String getBatchId() {
                return "SALE";
            }

            @Override
            public PoiWorksheetDefinition<SuTicket> getDefinition() {
                return Definitions.SELL;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        list.add(new BaseWorksheetData<SuTicket>(){

            @Override
            public String getBatchId() {
                return "REFUND";
            }

            @Override
            public PoiWorksheetDefinition<SuTicket> getDefinition() {
                return Definitions.REFUND;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        list.add(new BaseWorksheetData<SuTicket>(){

            @Override
            public String getBatchId() {
                return "EXC";
            }

            @Override
            public PoiWorksheetDefinition<SuTicket> getDefinition() {
                return Definitions.EX\u0421HANGE;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        return list;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        File result = IoUtil.url2file((URL)SuPaymentCardSalesReportRenderHandler.class.getResource("/salesreports/SuPaymentCardSalesReport.xls"));
        if (!result.exists() || !result.canRead()) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.SuPaymentCard_failedToLoadTemplate, (Object[])new Object[]{result.getCanonicalPath()}).toString());
        }
        return IoUtil.getResourceInputStream((File)result);
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        return String.format("CCR_%s_%s-%s_%s", data.get("AGENCY_IATA_CODE"), new SimpleDateFormat("dd").format(params.getPeriodBegin()), new SimpleDateFormat("dd").format(params.getPeriodEnd()), new SimpleDateFormat("MMyyyy").format(params.getPeriodEnd()));
    }

    public static enum Definitions implements PoiWorksheetDefinition<SuTicket>
    {
        TOTAL{

            @Override
            public PoiWorksheetHandler<SuTicket> getHandler() {
                return new SuPaymentCardSalesTotalWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.SuPaymentCard_total, (Object[])new Object[0]).toString();
            }
        }
        ,
        SELL{

            @Override
            public PoiWorksheetHandler<SuTicket> getHandler() {
                return new SuPaymentCardSalesBaseWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.SuPaymentCard_sell, (Object[])new Object[0]).toString();
            }
        }
        ,
        REFUND{

            @Override
            public PoiWorksheetHandler<SuTicket> getHandler() {
                return new SuPaymentCardSalesBaseWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.SuPaymentCard_refund, (Object[])new Object[0]).toString();
            }
        }
        ,
        EX\u0421HANGE{

            @Override
            public PoiWorksheetHandler<SuTicket> getHandler() {
                return new SuPaymentCardSalesBaseWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.SuPaymentCard_exchange, (Object[])new Object[0]).toString();
            }
        };

    }
}

