/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SUBCAppendixData
implements Serializable {
    private static final long serialVersionUID = 6953318047638363784L;
    private String route;
    private final SUBCData bcData;
    private SUBlockCharterAppendixType type;
    private String appendixNumber;
    private String currencyCode;
    private String fareBasis;
    private final List<SUBCDateData> dates = new ArrayList<SUBCDateData>();

    public SUBCAppendixData(SUBCData aBCData) {
        this.bcData = aBCData;
        this.bcData.getAppendices().add(this);
    }

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String value) {
        this.route = value;
    }

    public SUBlockCharterAppendixType getType() {
        return this.type;
    }

    public void setType(SUBlockCharterAppendixType value) {
        this.type = value;
    }

    public String getAppendixNumber() {
        return this.appendixNumber;
    }

    public void setAppendixNumber(String value) {
        this.appendixNumber = value;
    }

    public String getAgentCode() {
        return this.bcData.getAgentCode();
    }

    public String getAgentName() {
        return this.bcData.getAgentName();
    }

    public String getReportPeriod() {
        return this.bcData.getReportPeriod();
    }

    public String getContractNumber() {
        return this.bcData.getContractNumber();
    }

    public void setCurrencyCode(String value) {
        this.currencyCode = value;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public List<SUBCDateData> getDates() {
        return this.dates;
    }

    public String getFareBasis() {
        return this.fareBasis;
    }

    public void setFareBasis(String value) {
        this.fareBasis = value;
    }

    private int calculateValue(IntValueCalculator valueCalculator) {
        int n = 0;
        for (SUBCDateData date : this.dates) {
            n += valueCalculator.calculateValue(date);
        }
        return n;
    }

    private BigDecimal calculateValue(BigDecimalValueCalculator valueCalculator) {
        BigDecimal result = BigDecimal.ZERO;
        for (SUBCDateData date : this.dates) {
            result = result.add(valueCalculator.calculateValue(date));
        }
        return result;
    }

    public BigDecimal getCurrencyRate() {
        return this.bcData.getRates().get(this.currencyCode);
    }

    public BigDecimal getTotalUnsoldEquivalentTariff() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCDateData data) {
                return data.getTotalUnsoldEquivalentTariff();
            }
        });
    }

    public int getTotalUnsoldCount() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCDateData data) {
                return data.getTotalUnsoldCount();
            }
        });
    }

    private static interface IntValueCalculator {
        public int calculateValue(SUBCDateData var1);
    }

    private static interface BigDecimalValueCalculator {
        public BigDecimal calculateValue(SUBCDateData var1);
    }
}

