/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SUBCData
implements Serializable {
    private static final long serialVersionUID = -6478672820050229465L;
    private String agentCode;
    private String agentName;
    private String phone;
    private String reportPeriod;
    private String reportDecada;
    private String agentINN;
    private String contractNumber;
    private String director;
    private String accountant;
    private String email;
    private final ArrayList<SUBCAppendixData> appendices = new ArrayList();
    private final HashMap<String, BigDecimal> rates = new HashMap();
    private final ArrayList<SUBCTicket> tickets = new ArrayList();

    public int getSellsCount() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCTicket data) {
                return data.getStatus() == ProductStatus.SELL ? 1 : 0;
            }
        });
    }

    public int getRefundsCount() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCTicket data) {
                return data.getStatus() == ProductStatus.REFUND || data.getStatus() == ProductStatus.EXCHANGE ? 1 : 0;
            }
        });
    }

    public BigDecimal getSellsTotalTariff() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.SELL ? ticket.getEquivalentFare() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getSellsTotalCommission() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.SELL ? ticket.getVendorEquivalentCommission() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getSellsTotalPenalty() {
        BigDecimal result = BigDecimal.ZERO;
        for (SUBCAppendixData app : this.appendices) {
            result = result.add(app.getTotalUnsoldEquivalentTariff());
        }
        return result;
    }

    public int getTotalUnsoldTickets() {
        int n = 0;
        for (SUBCAppendixData app : this.appendices) {
            n += app.getTotalUnsoldCount();
        }
        return n;
    }

    public BigDecimal getSellsTotalAirportTaxes() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.SELL ? ticket.getAirportTaxes() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getSellsTotalFuelTaxes() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.SELL ? ticket.getFuelTax() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getSellsTotalAeroflotTaxes() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.SELL ? ticket.getAeroflotTaxes() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getRefundsTotalTariff() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? ticket.getEquivalentFare() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getRefundsTotalPenalty() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? ticket.getPenalty() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getRefundsTotalAirportTaxes() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? ticket.getAirportTaxes() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getRefundsTotalFuelTaxes() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? ticket.getFuelTax() : BigDecimal.ZERO;
            }
        });
    }

    public BigDecimal getRefundsTotalAeroflotTaxes() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? ticket.getAeroflotTaxes() : BigDecimal.ZERO;
            }
        });
    }

    public String getAgentCode() {
        return this.agentCode;
    }

    public void setAgentCode(String value) {
        this.agentCode = value;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String value) {
        this.agentName = value;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String value) {
        this.phone = value;
    }

    public String getReportPeriod() {
        return this.reportPeriod;
    }

    public void setReportPeriod(String value) {
        this.reportPeriod = value;
    }

    public String getAgentINN() {
        return this.agentINN;
    }

    public void setAgentINN(String value) {
        this.agentINN = value;
    }

    public List<SUBCAppendixData> getAppendices() {
        return this.appendices;
    }

    public String getContractNumber() {
        return this.contractNumber;
    }

    public void setContractNumber(String value) {
        this.contractNumber = value;
    }

    public List<SUBCTicket> getTickets() {
        return this.tickets;
    }

    public String getAccountant() {
        return this.accountant;
    }

    public void setAccountant(String value) {
        this.accountant = value;
    }

    public String getDirector() {
        return this.director;
    }

    public void setDirector(String value) {
        this.director = value;
    }

    public String getReportDecada() {
        return this.reportDecada;
    }

    public void setReportDecada(String value) {
        this.reportDecada = value;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    private BigDecimal calculateValue(BigDecimalValueCalculator valueCalculator) {
        BigDecimal result = BigDecimal.ZERO;
        for (SUBCTicket ticket : this.tickets) {
            BigDecimal subValue = valueCalculator.calculateValue(ticket);
            if (subValue == null) continue;
            result = result.add(subValue);
        }
        return result;
    }

    private int calculateValue(IntValueCalculator valueCalculator) {
        int n = 0;
        for (SUBCTicket ticket : this.tickets) {
            n += valueCalculator.calculateValue(ticket);
        }
        return n;
    }

    public BigDecimal getRefundsTotalCommission() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCTicket ticket) {
                return ticket.getStatus() == ProductStatus.REFUND ? ticket.getVendorEquivalentCommission() : BigDecimal.ZERO;
            }
        });
    }

    public Map<String, BigDecimal> getRates() {
        return this.rates;
    }

    private static interface IntValueCalculator {
        public int calculateValue(SUBCTicket var1);
    }

    private static interface BigDecimalValueCalculator {
        public BigDecimal calculateValue(SUBCTicket var1);
    }
}

