/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCQuotaData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicketsData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class SUBCF4AWorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ArrayList<SUBCAppendixData> appendices = new ArrayList<SUBCAppendixData>();
        for (SUBCAppendixData app : bcdata.getAppendices()) {
            if (app.getType() != SUBlockCharterAppendixType.ROUND_TRIP) continue;
            appendices.add(app);
        }
        Collections.sort(appendices, new Comparator<SUBCAppendixData>(){

            @Override
            public int compare(SUBCAppendixData o1, SUBCAppendixData o2) {
                return TextUtil.compare((String)o1.getAppendixNumber(), (String)o2.getAppendixNumber(), (boolean)false, (boolean)false);
            }
        });
        for (int n = 0; n < appendices.size(); ++n) {
            SUBCAppendixData app;
            app = (SUBCAppendixData)appendices.get(n);
            HSSFSheet ws = wb.cloneSheet(wb.getSheetIndex((Sheet)sheet));
            String route = SUBCReportHelper.getRoute(app.getRoute());
            String name = String.format("RT-%s-%s", app.getAppendixNumber(), route);
            for (int m = 0; m < wb.getNumberOfSheets(); ++m) {
                if (!name.equals(wb.getSheetName(m))) continue;
                throw new IllegalArgumentException(String.format("sheet %s is already present in workbook", name));
            }
            wb.setSheetName(wb.getSheetIndex((Sheet)ws), name);
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
            ExcelUtils.replace((HSSFSheet)ws, (String)"APPENDIX_NUMBER", (String)app.getAppendixNumber());
            ExcelUtils.replace((HSSFSheet)ws, (String)"CONTRACT_NO", (String)app.getContractNumber());
            ExcelUtils.replace((HSSFSheet)ws, (String)"ROUTE", (String)app.getRoute());
            ExcelUtils.replace((HSSFSheet)ws, (String)"REPORT_PERIOD", (String)app.getReportPeriod());
            ExcelUtils.replace((HSSFSheet)ws, (String)"APPENDIX_CURRENCY", (String)app.getCurrencyCode());
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_ACCOUNTANT", (String)bcdata.getAccountant());
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_DIRECTOR", (String)bcdata.getDirector());
            ArrayList<SUBCTicketsData> lst = new ArrayList<SUBCTicketsData>();
            for (SUBCDateData date : app.getDates()) {
                for (SUBCFlightData flight : date.getFlights()) {
                    for (SUBCQuotaData quota : flight.getQuotas()) {
                        if (quota.getDirectFlightsData() != null) {
                            lst.add(quota.getDirectFlightsData());
                        } else {
                            lst.add(new SUBCTicketsData(quota, false));
                        }
                        if (quota.getRegionFlightsData() == null) continue;
                        lst.add(quota.getRegionFlightsData());
                    }
                }
            }
            Collections.sort(lst, new Comparator<SUBCTicketsData>(){

                @Override
                public int compare(SUBCTicketsData o1, SUBCTicketsData o2) {
                    int res = MiscUtil.compare((Date)o1.getQuota().getFlight().getDateData().getDate(), (Date)o2.getQuota().getFlight().getDateData().getDate());
                    if (res != 0) {
                        return res;
                    }
                    res = TextUtil.compare((String)o1.getQuota().getFlight().getFlightNumber(), (String)o2.getQuota().getFlight().getFlightNumber(), (boolean)false, (boolean)false);
                    if (res != 0) {
                        return res;
                    }
                    res = o1.getQuota().getRtTariff().compareTo(o2.getQuota().getRtTariff());
                    if (res != 0) {
                        return res;
                    }
                    return o1.isRegionFlight() ? 1 : -1;
                }
            });
            for (int m = 0; m < lst.size() - 1; ++m) {
                ExcelUtils.copyRows((HSSFSheet)ws, (int)12, (int)12);
            }
            int startDateIndex = 13;
            int startFlightIndex = 13;
            int startQuotaIndex = 13;
            SUBCDateData lastDate = null;
            SUBCFlightData lastFlight = null;
            SUBCQuotaData lastQuota = null;
            for (int m = 0; m < lst.size(); ++m) {
                SUBCTicketsData ticketsData = (SUBCTicketsData)lst.get(m);
                SUBCQuotaData quota = ticketsData.getQuota();
                if (lastDate == null) {
                    lastDate = quota.getFlight().getDateData();
                }
                if (lastDate != quota.getFlight().getDateData()) {
                    lastDate = quota.getFlight().getDateData();
                    if (startDateIndex - 1 != 11 + m) {
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startDateIndex - 1, 11 + m, 0, 0));
                    }
                    startDateIndex = 13 + m;
                }
                if (lastFlight == null) {
                    lastFlight = quota.getFlight();
                }
                if (lastFlight != quota.getFlight()) {
                    lastFlight = quota.getFlight();
                    if (startFlightIndex - 1 != 11 + m) {
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startFlightIndex - 1, 11 + m, 1, 1));
                    }
                    startFlightIndex = 13 + m;
                }
                boolean setQuotaValue = false;
                if (lastQuota == null) {
                    lastQuota = quota;
                    setQuotaValue = true;
                }
                if (lastQuota != quota) {
                    setQuotaValue = true;
                    lastQuota = quota;
                    if (startQuotaIndex - 1 != 11 + m) {
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + m, 4, 4));
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + m, 8, 8));
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + m, 10, 10));
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + m, 11, 11));
                    }
                    startQuotaIndex = 13 + m;
                }
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)1, (String)this.dateFormat.format(quota.getFlight().getDateData().getDate()));
                String flightNumber = quota.getFlight().getFlightNumber();
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)2, (String)flightNumber);
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)3, (String)String.format("%s%s %s", quota.getClassOfBooking(), ticketsData.isRegionFlight() ? "R" : "", quota.getRtTariff()));
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)4, (BigDecimal)quota.getRtTariff());
                if (setQuotaValue) {
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)5, (int)quota.getQuota());
                }
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)6, (int)(ticketsData.getTotalRTSingleClassAdult() + ticketsData.getTotalRTMixedClassAdult()));
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)7, (int)(ticketsData.getTotalRTSingleClassInfant() + ticketsData.getTotalRTMixedClassInfant()));
                if (!ticketsData.isRegionFlight()) {
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)8, (int)quota.getTotalUnsoldCount());
                }
                if (ticketsData.isRegionFlight()) continue;
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)(13 + m), (int)1, (int)1, (int)9, (BigDecimal)quota.getTotalUnsoldAmount());
            }
            if (lst.isEmpty()) continue;
            if (startDateIndex - 1 != 11 + lst.size()) {
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startDateIndex - 1, 11 + lst.size(), 0, 0));
            }
            if (startFlightIndex - 1 != 11 + lst.size()) {
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startFlightIndex - 1, 11 + lst.size(), 1, 1));
            }
            if (startQuotaIndex - 1 != 11 + lst.size()) {
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + lst.size(), 4, 4));
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + lst.size(), 8, 8));
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + lst.size(), 10, 10));
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(startQuotaIndex - 1, 11 + lst.size(), 11, 11));
            }
            int row = 14 + lst.size();
            ExcelUtils.setCellFormula((HSSFSheet)ws, (int)row, (int)5, (int)1, (int)1, (String)String.format("=SUM(E13:E%s)", Integer.toString(row - 2)));
            ExcelUtils.setCellFormula((HSSFSheet)ws, (int)row, (int)5, (int)1, (int)2, (String)String.format("=SUM(F13:F%s)", Integer.toString(row - 2)));
            ExcelUtils.setCellFormula((HSSFSheet)ws, (int)row, (int)5, (int)1, (int)3, (String)String.format("=SUM(G13:G%s)", Integer.toString(row - 2)));
            ExcelUtils.setCellFormula((HSSFSheet)ws, (int)row, (int)5, (int)1, (int)4, (String)String.format("=SUM(H13:H%s)", Integer.toString(row - 2)));
            ExcelUtils.setCellFormula((HSSFSheet)ws, (int)row, (int)5, (int)1, (int)5, (String)String.format("=SUM(I13:I%s)", Integer.toString(row - 2)));
            ws.getRow(11).setHeight((short)0);
            ws.getRow(12 + lst.size()).setHeight((short)0);
        }
        wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
    }
}

