/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuBcRegistryWorksheetHandler;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class SUBCF5WorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
    private final DateFormat df2 = new SimpleDateFormat("dd.MM");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ArrayList<SUBCDateData> dates = new ArrayList<SUBCDateData>();
        for (SUBCAppendixData app : bcdata.getAppendices()) {
            dates.addAll(app.getDates());
        }
        Collections.sort(dates, new Comparator<SUBCDateData>(){

            @Override
            public int compare(SUBCDateData o1, SUBCDateData o2) {
                int res = MiscUtil.compare((Date)o1.getDate(), (Date)o2.getDate());
                if (res != 0) {
                    return res;
                }
                return this.getIndex(o1) - this.getIndex(o2);
            }

            private int getIndex(SUBCDateData o1) {
                return o1.getAppendix().getType() == SUBlockCharterAppendixType.ROUND_TRIP ? 0 : 1;
            }
        });
        for (int n = 0; n < dates.size(); ++n) {
            SUBCDateData dateData = (SUBCDateData)dates.get(n);
            ArrayList<SUBCFlightData> flights = new ArrayList<SUBCFlightData>(dateData.getFlights());
            Collections.sort(flights, new Comparator<SUBCFlightData>(){

                @Override
                public int compare(SUBCFlightData o1, SUBCFlightData o2) {
                    return TextUtil.compare((String)o1.getFlightNumber(), (String)o2.getFlightNumber(), (boolean)false, (boolean)false);
                }
            });
            for (SUBCFlightData flight : flights) {
                HSSFSheet ws = wb.cloneSheet(wb.getSheetIndex((Sheet)sheet));
                String route = SUBCReportHelper.getRoute(dateData.getAppendix().getRoute());
                String name = String.format("%s-%s-%s-%s-%s", dateData.getAppendix().getType() == SUBlockCharterAppendixType.ROUND_TRIP ? "RT" : "OW", flight.getDateData().getAppendix().getAppendixNumber(), route, this.df2.format(dateData.getDate()), flight.getFlightNumber());
                for (int m = 0; m < wb.getNumberOfSheets(); ++m) {
                    if (!name.equals(wb.getSheetName(m))) continue;
                    throw new IllegalArgumentException(String.format("sheet %s is already present in workbook", name));
                }
                wb.setSheetName(wb.getSheetIndex((Sheet)ws), name);
                ExcelUtils.replace((HSSFSheet)ws, (String)"APPENDIX_NUMBER", (String)dateData.getAppendix().getAppendixNumber());
                ExcelUtils.replace((HSSFSheet)ws, (String)"CONTRACT_NO", (String)dateData.getAppendix().getContractNumber());
                ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
                ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
                ExcelUtils.replace((HSSFSheet)ws, (String)"ROUTE", (String)dateData.getAppendix().getRoute());
                ExcelUtils.replace((HSSFSheet)ws, (String)"FLIGHT_DATE", (String)this.dateFormat.format(dateData.getDate()));
                ExcelUtils.replace((HSSFSheet)ws, (String)"FLIGHT_NUMBER", (String)flight.getFlightNumber());
                ExcelUtils.replace((HSSFSheet)ws, (String)"APPENDIX_CURRENCY", (String)dateData.getAppendix().getCurrencyCode());
                ExcelUtils.replace((HSSFSheet)ws, (String)"REPORT_PERIOD", (String)bcdata.getReportPeriod());
                ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_DIRECTOR", (String)bcdata.getDirector());
                int totalRecordsCount = flight.getDirectTickets().size();
                if (flight.getRegionTickets().size() > 0) {
                    totalRecordsCount = totalRecordsCount + 1 + flight.getRegionTickets().size();
                }
                for (int m = 0; m < totalRecordsCount - 1; ++m) {
                    ExcelUtils.copyRows((HSSFSheet)ws, (int)9, (int)9);
                }
                int startRowIndex = 10;
                this.addTickets(flight.getDirectTickets(), dateData.getDate(), ws, startRowIndex, 1);
                if (flight.getRegionTickets().size() <= 0) continue;
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress((startRowIndex += flight.getDirectTickets().size()) - 1, startRowIndex - 1, 0, 13));
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)1, (int)1, (String)L10nResourcesManager.createL10nMessage((String)Messages.SUBCF5WorksheetHandler_regions, (Object[])new Object[0]).toString());
                HSSFCellStyle cs = wb.createCellStyle();
                cs.cloneStyleFrom(ws.getRow(startRowIndex - 1).getCell(0).getCellStyle());
                HSSFFont font = wb.createFont();
                font.setBoldweight((short)700);
                cs.setFont(font);
                cs.setAlignment((short)2);
                ws.getRow(startRowIndex - 1).getCell(0).setCellStyle(cs);
                this.addTickets(flight.getRegionTickets(), dateData.getDate(), ws, ++startRowIndex, 1 + flight.getDirectTickets().size());
            }
        }
        wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
    }

    private void addTickets(List<SUBCTicket> directTickets, Date date, HSSFSheet ws, int startRowIndex, int startTicketIndex) throws Exception {
        ArrayList<SUBCTicket> lst = new ArrayList<SUBCTicket>(directTickets);
        Collections.sort(lst, SuBcRegistryWorksheetHandler.ticketsComparator);
        for (int m = 0; m < lst.size(); ++m) {
            SUBCTicket ticket = (SUBCTicket)lst.get(m);
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)1, (int)(startTicketIndex + m));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)2, (String)ticket.getTicketNumber());
            if (ticket.getIssueDate() != null) {
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)3, (String)this.dateFormat.format(ticket.getIssueDate()));
            }
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)4, (String)this.dateFormat.format(date));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)5, (String)ticket.getFlightNumbers());
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)6, (String)ticket.getClassOfService());
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)7, (BigDecimal)SUBCF5WorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

                @Override
                public BigDecimal calculate(SUBCTicket tick) {
                    return tick.getBaseFare().getValue();
                }
            }));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)8, (String)Double.toString(ticket.getRate()));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)9, (BigDecimal)SUBCF5WorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

                @Override
                public BigDecimal calculate(SUBCTicket tick) {
                    return tick.getEquivalentFare();
                }
            }));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)10, (BigDecimal)SUBCF5WorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

                @Override
                public BigDecimal calculate(SUBCTicket tick) {
                    return tick.getAirportTaxes();
                }
            }));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)11, (BigDecimal)SUBCF5WorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

                @Override
                public BigDecimal calculate(SUBCTicket tick) {
                    return tick.getFuelTax();
                }
            }));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)12, (BigDecimal)SUBCF5WorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

                @Override
                public BigDecimal calculate(SUBCTicket tick) {
                    return tick.getAeroflotTaxes();
                }
            }));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)13, (BigDecimal)SUBCF5WorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

                @Override
                public BigDecimal calculate(SUBCTicket tick) {
                    return tick.getVendorEquivalentCommission();
                }
            }));
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)startRowIndex, (int)1, (int)(m + 1), (int)14, (BigDecimal)SUBCF5WorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

                @Override
                public BigDecimal calculate(SUBCTicket tick) {
                    return tick.getVendorCommissionValue() == null ? null : tick.getVendorCommissionValue().getValue();
                }
            }));
        }
    }

    private static BigDecimal calculate(SUBCTicket ticket, BigDecimalCalculator calculator) {
        BigDecimal res = calculator.calculate(ticket);
        if (res == null) {
            return null;
        }
        return ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? res.negate() : res;
    }

    private static interface BigDecimalCalculator {
        public BigDecimal calculate(SUBCTicket var1);
    }
}

