/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SUBCTicket
extends BaseSalesReportTicket {
    private static final long serialVersionUID = 7436951483527145641L;
    private BigDecimal airportTaxes = BigDecimal.ZERO;
    private BigDecimal fuelTax = BigDecimal.ZERO;
    private BigDecimal aeroflotTaxes = BigDecimal.ZERO;
    private String scn = null;
    private Date firstFlightDate = null;
    private Date lastFlightDate = null;
    private Date sellDate = null;
    private String flightNumbers = null;
    private double rate = 1.0;
    private DictionaryReference<PassengerType> passengerType = null;
    private boolean roundTrip = false;
    private String departureCityCode = null;
    private String route = null;
    private String forwardClassOfBooking = null;
    private String backwardClassOfBooking = null;
    private String relatedSellNumber;
    private boolean partitialRefund = false;
    private String classOfService;
    private String fareBasis = null;
    private boolean regionFlight;
    private String direction;
    private boolean hasMixedClasses;
    private boolean ignoreFinanceFields;

    public SUBCTicket(Product ticket, List<Message> messages, Map<String, Object> data) throws Exception {
        super(ticket, messages);
        if (ticket.getStatus() == ProductStatus.EXCHANGE && ticket.getNextProduct() != null) {
            this.relatedSellNumber = ticket.getNextProduct().getSystemNumber();
        }
        this.scn = ticket.getScns().isEmpty() ? null : (String)ticket.getScns().get(0);
        LocationsData locationsData = SUBCTicket.getLocationsData(ticket, (Set)data.get("KEY_BLOCK_CHARTER_CONTRACT_LOCATION_CODES"));
        if (locationsData.departure != null) {
            this.fareBasis = locationsData.departure.fareBasis;
            this.classOfService = locationsData.departure.classOfService;
        }
        this.hasMixedClasses = this.isMixedClasses(ticket);
        this.regionFlight = locationsData.regionFlight;
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        Date date = this.issueDate;
        Product previousProduct = ticket.getPreviousProduct();
        if ((ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE) && previousProduct != null && previousProduct.getIssueDate() != null) {
            date = previousProduct.getIssueDate();
        }
        if (locationsData.departure == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noInfoAboutSegments, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        if (locationsData.departure.flightDate == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noDepartureDateFirstSeg, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        if (locationsData.departure.cityCode == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noDepartureCityFirstSeg, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        this.direction = locationsData.direction;
        this.departureCityCode = locationsData.departure.cityCode;
        this.passengerType = DictHelper.getAdultPassengerType();
        if (DictHelper.isEqualsPredifinedValue((DictionaryReference)ticket.getPassengerType(), (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD, PassengerTypeValue.CHILD_UNACCOMPANIED})) {
            this.passengerType = DictHelper.getChildPassengerType();
        } else if (DictHelper.isEqualsPredifinedValue((DictionaryReference)ticket.getPassengerType(), (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT, PassengerTypeValue.INFANT_WITH_SITE})) {
            this.passengerType = DictHelper.getInfantPassengerType();
        }
        this.firstFlightDate = locationsData.departure.flightDate;
        if ((ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE) && previousProduct != null) {
            this.sellDate = previousProduct.getIssueDate();
        }
        this.forwardClassOfBooking = locationsData.departure.classOfBooking;
        if (TextUtil.isBlank((String)this.forwardClassOfBooking)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noBookingClassForward, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        String string = this.flightNumbers = locationsData.arrival.flightNumber != null && !locationsData.arrival.flightNumber.equals(locationsData.departure.flightNumber) ? String.format("%s/%s", locationsData.departure.flightNumber, locationsData.arrival.flightNumber) : locationsData.departure.flightNumber;
        if (locationsData.arrival.cityCode == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noArrivalCity, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        this.lastFlightDate = locationsData.arrival.flightDate;
        if (this.lastFlightDate == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noLastFlightDate, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        this.backwardClassOfBooking = locationsData.arrival.classOfBooking;
        if (TextUtil.isBlank((String)this.backwardClassOfBooking)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noBookingClassBackward, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        this.roundTrip = locationsData.roundTrip;
        this.route = locationsData.fullRoute;
        if (ticket.getStatus() == ProductStatus.VOID || ticket.getStatus() == ProductStatus.VOID_BOOKING) {
            this.direction = locationsData.direction;
            return;
        }
        if (this.baseFare == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_noFareInDestinationCurrency, (Object[])new Object[]{ticket.getSystemNumber()}));
            return;
        }
        if (this.baseFare != null && this.baseFare.getCurrency() != null && !this.baseFare.getCurrency().equals("RUB")) {
            CurrencyRate crate = BookingHelper.findCurrencyRate((String)this.baseFare.getCurrency(), (Date)date, (CurrencyRateType)CurrencyRateType.IATA, null, (EntityReference)params.getBlankOwner());
            if (crate == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCTicket_failedToDetermineRate, (Object[])new Object[]{ticket.getSystemNumber(), this.baseFare.getCurrency()}));
                return;
            }
            this.rate = crate.getRate();
        }
        this.fuelTax = AirProductTaxHelper.getFuelTaxesEquivalentAmount((Product)ticket);
        this.aeroflotTaxes = AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)ticket).add(AirProductTaxHelper.getTaxesForGDSEquivalentAmount((Product)ticket));
        this.airportTaxes = AirProductTaxHelper.getEquivalentTaxesAmount((Product)ticket).subtract(this.aeroflotTaxes).subtract(this.fuelTax);
        if (!this.roundTrip && ticket.getStatus() == ProductStatus.REFUND && previousProduct != null && previousProduct.getTicketType() == TicketType.OWN) {
            LocationsData prevLocData = SUBCTicket.getLocationsData(previousProduct, (Set)data.get("KEY_BLOCK_CHARTER_CONTRACT_LOCATION_CODES"));
            if (prevLocData.roundTrip && prevLocData.departure != null && prevLocData.departure.flightDate != null && prevLocData.departure.flightDate.before(MiscUtil.clearTime((Date)params.getPeriodBegin()))) {
                this.partitialRefund = true;
                this.roundTrip = true;
            }
        }
    }

    private boolean isMixedClasses(Product ticket) {
        String lastClassOfService = null;
        for (SegmentTariff st : ticket.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                String code = seg.getClassOfSvcCode();
                if (TextUtil.isBlank((String)code)) {
                    code = seg.getClassOfService();
                }
                if (TextUtil.isBlank((String)code)) continue;
                if (lastClassOfService == null) {
                    lastClassOfService = code;
                    continue;
                }
                if (lastClassOfService.equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    public BigDecimal getAirportTaxes() {
        return this.airportTaxes;
    }

    public BigDecimal getFuelTax() {
        return this.fuelTax;
    }

    public BigDecimal getAeroflotTaxes() {
        return this.aeroflotTaxes;
    }

    public String getScn() {
        return this.scn;
    }

    public Date getFirstFlightDate() {
        return this.firstFlightDate;
    }

    public String getFlightNumbers() {
        return this.flightNumbers;
    }

    public double getRate() {
        return this.rate;
    }

    public DictionaryReference<PassengerType> getPassengerType() {
        return this.passengerType;
    }

    public boolean isRoundTrip() {
        return this.roundTrip;
    }

    public String getDepartureCityCode() {
        return this.departureCityCode;
    }

    public String getRoute() {
        return this.route;
    }

    public Date getLastFlightDate() {
        return this.lastFlightDate;
    }

    public String getForwardClassOfBooking() {
        return this.forwardClassOfBooking;
    }

    public String getBackwardClassOfBooking() {
        return this.backwardClassOfBooking;
    }

    public Date getSellDate() {
        return this.sellDate;
    }

    public void resetFinanceFields() {
        this.airportTaxes = BigDecimal.ZERO;
        this.fuelTax = BigDecimal.ZERO;
        this.aeroflotTaxes = BigDecimal.ZERO;
        this.equivalentFare = BigDecimal.ZERO;
        this.baseFare.setValue(BigDecimal.ZERO);
        this.vendorEquivalentCommission = BigDecimal.ZERO;
        if (this.vendorCommissionValue != null) {
            this.vendorCommissionValue.setValue(BigDecimal.ZERO);
        }
    }

    public String getRelatedSellNumber() {
        return this.relatedSellNumber;
    }

    public void setRelatedSellNumber(String value) {
        this.relatedSellNumber = value;
    }

    public boolean isPartitialRefund() {
        return this.partitialRefund;
    }

    public String getClassOfService() {
        return this.classOfService;
    }

    public void setClassOfService(String value) {
        this.classOfService = value;
    }

    public String getFareBasis() {
        return this.fareBasis;
    }

    public void setFareBasis(String value) {
        this.fareBasis = value;
    }

    public boolean isRegionFlight() {
        return this.regionFlight;
    }

    public String getDirection() {
        return this.direction;
    }

    private static boolean isRussianCity(DictionaryReference<GeoLocation> loc) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(loc);
        return location != null && location.getCountry() != null && "RU".equals(location.getCountry().getCode());
    }

    public static LocationsData getLocationsData(Product ticket, Set<String> locationCodes) {
        LocationData departure = null;
        LocationData arrival = null;
        boolean regionFlight = false;
        StringBuilder fullRoute = new StringBuilder();
        String ruCityCode = null;
        String foreignCityCode = null;
        for (SegmentTariff st : ticket.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (fullRoute.length() == 0) {
                    fullRoute.append(DictHelper.findCityCode((DictionaryReference)seg.getDepartureLocation(), (CodeSystem)CodeSystem.IATA, (boolean)false));
                }
                fullRoute.append("-").append(DictHelper.findCityCode((DictionaryReference)seg.getArriveLocation(), (CodeSystem)CodeSystem.IATA, (boolean)false));
                if (!(seg.getDepartureLocation() == null || seg.getArriveLocation() == null || SUBCTicket.isInList((DictionaryReference<GeoLocation>)seg.getDepartureLocation(), locationCodes) && SUBCTicket.isInList((DictionaryReference<GeoLocation>)seg.getArriveLocation(), locationCodes))) {
                    regionFlight = true;
                    continue;
                }
                if (departure == null) {
                    departure = SUBCTicket.createLocationData(seg, false);
                    if (departure.ruCity) {
                        ruCityCode = departure.cityCode;
                    } else {
                        foreignCityCode = departure.cityCode;
                    }
                }
                arrival = SUBCTicket.createLocationData(seg, true);
                if (arrival.ruCity) {
                    ruCityCode = arrival.cityCode;
                    continue;
                }
                foreignCityCode = arrival.cityCode;
            }
        }
        boolean roundTrip = departure != null && arrival != null && departure.cityCode != null && departure.cityCode.equals(arrival.cityCode);
        return new LocationsData(departure, arrival, roundTrip, regionFlight, fullRoute.toString(), String.format("%s-%s", ruCityCode, foreignCityCode));
    }

    private static boolean isInList(DictionaryReference<GeoLocation> location, Set<String> expectedCodes) {
        HashSet<String> actualCodes = new HashSet<String>();
        actualCodes.add(location.getCode());
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(location);
        if (loc != null) {
            actualCodes.addAll(loc.getCodeVariants().values());
            if (loc.getParent() != null && (loc = (GeoLocation)DictionaryCache.get().resolveReference(loc.getParent())) != null) {
                actualCodes.addAll(loc.getCodeVariants().values());
            }
        }
        for (String code : actualCodes) {
            if (!expectedCodes.contains(code)) continue;
            return true;
        }
        return false;
    }

    private static LocationData createLocationData(Segment seg, boolean arrival) {
        String classOfBooking;
        String classOfService = seg.getClassOfSvcCode();
        if (TextUtil.isBlank((String)classOfService) && !TextUtil.isBlank((String)seg.getFareBasis())) {
            classOfService = seg.getFareBasis().substring(0, 1);
        }
        if ((classOfBooking = seg.getClassOfSvcCode()) == null) {
            classOfBooking = seg.getClassOfService();
        }
        String fareBasis = seg.getFareBasis();
        Date flightDate = seg.getStartDate();
        String flightNumber = seg.getFlightNo();
        DictionaryReference loc = arrival ? seg.getArriveLocation() : seg.getDepartureLocation();
        GeoLocation city = DictHelper.findCity((DictionaryReference)loc);
        String cityCode = city == null ? null : (String)city.getCodeVariants().get(CodeSystem.IATA.name());
        return new LocationData(classOfService, classOfBooking, fareBasis, flightDate, cityCode, flightNumber, SUBCTicket.isRussianCity((DictionaryReference<GeoLocation>)loc));
    }

    public boolean isHasMixedClasses() {
        return this.hasMixedClasses;
    }

    public void setIgnoreFinanceFields(boolean value) {
        this.ignoreFinanceFields = value;
    }

    public boolean isIgnoreFinanceFields() {
        return this.ignoreFinanceFields;
    }

    public static class LocationsData {
        public final LocationData departure;
        public final LocationData arrival;
        public final boolean roundTrip;
        public final boolean regionFlight;
        public final String fullRoute;
        public final String direction;

        LocationsData(LocationData dep, LocationData arr, boolean rt, boolean region, String aFullRoute, String aDirection) {
            this.departure = dep;
            this.arrival = arr;
            this.roundTrip = rt;
            this.regionFlight = region;
            this.fullRoute = aFullRoute;
            this.direction = aDirection;
        }
    }

    public static class LocationData {
        public final String classOfService;
        public final String classOfBooking;
        public final String fareBasis;
        public final Date flightDate;
        public final String cityCode;
        public final String flightNumber;
        public final boolean ruCity;

        public LocationData(String clsOfService, String clsOfBooking, String fb, Date date, String city, String flight, boolean isRuCity) {
            this.classOfService = clsOfService;
            this.classOfBooking = clsOfBooking;
            this.fareBasis = fb;
            this.flightDate = date;
            this.cityCode = city;
            this.flightNumber = flight;
            this.ruCity = isRuCity;
        }
    }
}

