/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuBcRegistryWorksheetHandler;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SUBCVoidWorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)bcdata.getReportPeriod());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)bcdata.getContractNumber());
        ArrayList<SUBCTicket> tickets = new ArrayList<SUBCTicket>();
        for (SUBCTicket ticket : bcdata.getTickets()) {
            if (ticket.getStatus() != ProductStatus.VOID && ticket.getStatus() != ProductStatus.VOID_BOOKING) continue;
            tickets.add(ticket);
        }
        Collections.sort(tickets, SuBcRegistryWorksheetHandler.ticketsComparator);
        for (int n = 0; n < tickets.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)9, (int)9);
        }
        int lineNo = 10;
        for (SUBCTicket ticket : tickets) {
            this.populateTicket(sheet, lineNo, ticket);
            ++lineNo;
        }
        sheet.getRow(8).setHeight((short)0);
        sheet.getRow(++lineNo - 2).setHeight((short)0);
    }

    private void populateTicket(HSSFSheet sheet, int lineNo, SUBCTicket ticket) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)1, (int)(lineNo - 9));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)2, (String)(ticket.isEticket() ? "ETKT" : ticket.getScn()));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)3, (String)ticket.getTicketNumber());
        if (ticket.getIssueDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)4, (String)this.dateFormat.format(ticket.getIssueDate()));
        }
    }
}

