/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuBcRegistryWorksheetHandler;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

public class SUCharterF3WorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)bcdata.getContractNumber());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_DECADA", (String)bcdata.getReportDecada());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)bcdata.getAccountant());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)bcdata.getDirector());
        List<SUBCTicket> tickets = bcdata.getTickets();
        if (tickets.size() == 0) {
            return;
        }
        Collections.sort(tickets, SuBcRegistryWorksheetHandler.ticketsComparator);
        for (int n = 0; n < tickets.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)10, (int)10);
        }
        int lineNo = 11;
        int ticketsCount = 0;
        for (SUBCTicket ticket : tickets) {
            if (ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE) {
                --ticketsCount;
            } else if (ticket.getStatus() == ProductStatus.SELL) {
                ++ticketsCount;
            }
            this.populateTicket(sheet, lineNo, ticket);
            ++lineNo;
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(++lineNo), (int)1, (int)1, (int)3, (int)ticketsCount);
        sheet.getRow(9).setHeight((short)0);
        sheet.getRow(lineNo - 2).setHeight((short)0);
        wb.setSheetName(wb.getSheetIndex((Sheet)sheet), L10nResourcesManager.createL10nMessage((String)Messages.SUCharterF3WorksheetHandler_registry, (Object[])new Object[0]).toString());
        sheet.setForceFormulaRecalculation(true);
    }

    private void populateTicket(HSSFSheet workSheet, int lineNo, SUBCTicket ticket) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)1, (int)(lineNo - 10));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)2, (String)ticket.getTicketNumber());
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)3, (String)(ticket.isEticket() ? "ETKT" : ticket.getScn()));
        if (ticket.getIssueDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)4, (String)this.dateFormat.format(ticket.getIssueDate()));
        }
        if (ticket.getFirstFlightDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)5, (String)this.dateFormat.format(ticket.getFirstFlightDate()));
        }
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)6, (String)ticket.getClassOfService());
        if (ticket.getStatus() == ProductStatus.VOID || ticket.getStatus() == ProductStatus.VOID_BOOKING) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)7, (String)L10nResourcesManager.createL10nMessage((String)Messages.SUCharter_voided, (Object[])new Object[0]).toString());
        }
        if (ticket.getStatus() == ProductStatus.REFUND) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)7, (String)L10nResourcesManager.createL10nMessage((String)Messages.SUCharter_refunded, (Object[])new Object[0]).toString());
        }
    }
}

