/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

public class SUCharterF5WorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)bcdata.getContractNumber());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_DECADA", (String)bcdata.getReportDecada());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)bcdata.getAccountant());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)bcdata.getDirector());
        ArrayList<SUBCFlightData> flights = new ArrayList<SUBCFlightData>();
        boolean hasEuro = false;
        for (SUBCAppendixData app : bcdata.getAppendices()) {
            if ("EUR".equals(app.getCurrencyCode())) {
                hasEuro = true;
            }
            for (SUBCDateData date : app.getDates()) {
                for (SUBCFlightData flight : date.getFlights()) {
                    flights.add(flight);
                }
            }
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_CURRENCY", (String)(hasEuro ? "EUR" : "USD"));
        Comparator<SUBCFlightData> comparator = new Comparator<SUBCFlightData>(){

            @Override
            public int compare(SUBCFlightData o1, SUBCFlightData o2) {
                int res = TextUtil.compare((String)o1.getDateData().getAppendix().getAppendixNumber(), (String)o2.getDateData().getAppendix().getAppendixNumber(), (boolean)false, (boolean)true);
                if (res != 0) {
                    return res;
                }
                res = TextUtil.compare((String)o1.getDateData().getAppendix().getRoute(), (String)o2.getDateData().getAppendix().getRoute(), (boolean)false, (boolean)true);
                if (res != 0) {
                    return res;
                }
                res = MiscUtil.compare((Date)o1.getDateData().getDate(), (Date)o2.getDateData().getDate(), (boolean)false);
                if (res != 0) {
                    return res;
                }
                return TextUtil.compare((String)o1.getFlightNumber(), (String)o2.getFlightNumber(), (boolean)false, (boolean)true);
            }
        };
        Collections.sort(flights, comparator);
        List<SUBCTicket> tickets = bcdata.getTickets();
        if (tickets.size() == 0) {
            return;
        }
        Collections.sort(tickets, new Comparator<SUBCTicket>(){

            @Override
            public int compare(SUBCTicket o1, SUBCTicket o2) {
                return TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)false);
            }
        });
        int startRow = 12;
        for (int n = 0; n < flights.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)startRow, (int)startRow);
        }
        int row = startRow;
        for (SUBCFlightData flight : flights) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)1, (String)flight.getDateData().getAppendix().getAppendixNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)2, (String)this.dateFormat.format(flight.getDateData().getDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)3, (String)flight.getFlightNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)4, (int)flight.getTotalSoldCount());
            ++row;
        }
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)6, (int)1, (int)1, (String)String.format("=SUM(F%s:F%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)7, (int)1, (int)1, (String)String.format("=SUM(G%s:G%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)8, (int)1, (int)1, (String)String.format("=SUM(H%s:H%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)9, (int)1, (int)1, (String)String.format("=SUM(I%s:I%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)10, (int)1, (int)1, (String)String.format("=SUM(J%s:J%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)11, (int)1, (int)1, (String)String.format("=SUM(K%s:K%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)14, (int)1, (int)1, (String)String.format("=SUM(N%s:N%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)16, (int)1, (int)1, (String)String.format("=SUM(P%s:P%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)17, (int)1, (int)1, (String)String.format("=SUM(Q%s:Q%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(row + 1), (int)18, (int)1, (int)1, (String)String.format("=SUM(R%s:R%s)", Integer.toString(startRow + 1), Integer.toString(row)));
        sheet.getRow(startRow - 2).setHeight((short)0);
        sheet.getRow(row - 1).setHeight((short)0);
        wb.setSheetName(wb.getSheetIndex((Sheet)sheet), L10nResourcesManager.createL10nMessage((String)Messages.SUCharterF5WorksheetHandler_report, (Object[])new Object[0]).toString());
        sheet.setForceFormulaRecalculation(true);
    }
}

