/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuBcRegistryWorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
    static final Comparator<SUBCTicket> ticketsComparator = new Comparator<SUBCTicket>(){

        @Override
        public int compare(SUBCTicket o1, SUBCTicket o2) {
            int res = this.getIndex(o1.getStatus()) - this.getIndex(o2.getStatus());
            if (res != 0) {
                return res;
            }
            res = TextUtil.compare((String)this.getSortingNumber(o1), (String)this.getSortingNumber(o2), (boolean)false, (boolean)false);
            if (res != 0) {
                return res;
            }
            if (o1.getStatus() != o2.getStatus()) {
                return o1.getStatus() == ProductStatus.EXCHANGE ? -1 : 1;
            }
            return 0;
        }

        private String getSortingNumber(SUBCTicket ticket) {
            if (ticket.getStatus() == ProductStatus.EXCHANGE) {
                return ticket.getRelatedSellNumber();
            }
            return ticket.getTicketNumber();
        }

        private int getIndex(ProductStatus status) {
            if (status == ProductStatus.REFUND) {
                return 2;
            }
            if (status == ProductStatus.SELL || status == ProductStatus.EXCHANGE) {
                return 1;
            }
            return 0;
        }
    };

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)bcdata.getReportPeriod());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)bcdata.getContractNumber());
        List<SUBCTicket> tickets = bcdata.getTickets();
        if (tickets.size() == 0) {
            return;
        }
        Collections.sort(tickets, ticketsComparator);
        for (int n = 0; n < tickets.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)9, (int)9);
        }
        int lineNo = 10;
        for (SUBCTicket ticket : tickets) {
            this.populateTicket(sheet, lineNo, ticket);
            ++lineNo;
        }
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)6, (int)1, (int)1, (String)String.format("=SUM(F9:F%s)", Integer.toString(++lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)7, (int)1, (int)1, (String)String.format("=SUM(G9:G%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)9, (int)1, (int)1, (String)String.format("=SUM(I9:I%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)10, (int)1, (int)1, (String)String.format("=SUM(J9:J%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)11, (int)1, (int)1, (String)String.format("=SUM(K9:K%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)12, (int)1, (int)1, (String)String.format("=SUM(L9:L%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)13, (int)1, (int)1, (String)String.format("=SUM(M9:M%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)14, (int)1, (int)1, (String)String.format("=SUM(N9:N%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)15, (int)1, (int)1, (String)String.format("=SUM(O9:O%s)", Integer.toString(lineNo - 1)));
        sheet.getRow(8).setHeight((short)0);
        sheet.getRow(lineNo - 2).setHeight((short)0);
    }

    private void populateTicket(HSSFSheet workSheet, int lineNo, SUBCTicket ticket) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)1, (int)(lineNo - 9));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)2, (String)ticket.getTicketNumber());
        if (ticket.getIssueDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)3, (String)this.dateFormat.format(ticket.getIssueDate()));
        }
        if (ticket.getStatus() == ProductStatus.VOID) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)4, (String)"V O I D");
            return;
        }
        if (ticket.getFirstFlightDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)4, (String)this.dateFormat.format(ticket.getFirstFlightDate()));
        }
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)5, (String)ticket.getFlightNumbers());
        boolean usd = ticket.getBaseFare().getCurrency().equals("USD");
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)(usd ? 6 : 7), (BigDecimal)SuBcRegistryWorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

            @Override
            public BigDecimal calculate(SUBCTicket tick) {
                return tick.getBaseFare().getValue();
            }
        }));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)8, (String)Double.toString(ticket.getRate()));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)9, (BigDecimal)SuBcRegistryWorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

            @Override
            public BigDecimal calculate(SUBCTicket tick) {
                return tick.getEquivalentFare();
            }
        }));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)10, (BigDecimal)SuBcRegistryWorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

            @Override
            public BigDecimal calculate(SUBCTicket tick) {
                return tick.getAirportTaxes();
            }
        }));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)11, (BigDecimal)SuBcRegistryWorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

            @Override
            public BigDecimal calculate(SUBCTicket tick) {
                return tick.getFuelTax();
            }
        }));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)12, (BigDecimal)SuBcRegistryWorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

            @Override
            public BigDecimal calculate(SUBCTicket tick) {
                return tick.getAeroflotTaxes();
            }
        }));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)13, (BigDecimal)SuBcRegistryWorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

            @Override
            public BigDecimal calculate(SUBCTicket tick) {
                return tick.getVendorEquivalentCommission();
            }
        }));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)(ticket.getVendorCommissionValue() != null && ticket.getVendorCommissionValue().getCurrency().equals("USD") ? 14 : 15), (BigDecimal)SuBcRegistryWorksheetHandler.calculate(ticket, new BigDecimalCalculator(){

            @Override
            public BigDecimal calculate(SUBCTicket tick) {
                return tick.getVendorCommissionValue() != null ? tick.getVendorCommissionValue().getValue() : null;
            }
        }));
    }

    private static BigDecimal calculate(SUBCTicket ticket, BigDecimalCalculator calculator) {
        BigDecimal res = calculator.calculate(ticket);
        if (res == null) {
            return null;
        }
        return ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? res.negate() : res;
    }

    private static interface BigDecimalCalculator {
        public BigDecimal calculate(SUBCTicket var1);
    }
}

