/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.registry;

import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuAgencyMemoRegistryRegularListWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    private static final int TICKETS_ROW_OFFSET = 5;

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ArrayList tickets = (ArrayList)data.getTickets();
        final List<TariffType> tariffTypes = this.getTariffTypes();
        Filter filter = new Filter(){

            @Override
            public boolean accept(SuTicket ticket) {
                if (!tariffTypes.contains(ticket.getTariffType())) {
                    return false;
                }
                BigDecimal tariff = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TARIFF));
                BigDecimal taxOthers = MiscUtil.nonNull((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_STATE), ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_OTHERS)}));
                BigDecimal taxCarrier = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_CARRIER));
                BigDecimal penalty = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.PENALTY)).add(MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.CONTRACT_PENALTY)));
                BigDecimal commission = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.COMMISSION));
                BigDecimal taxFuel = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_FUEL));
                return tariff.compareTo(BigDecimal.ZERO) != 0 || taxOthers.compareTo(BigDecimal.ZERO) != 0 || taxCarrier.compareTo(BigDecimal.ZERO) != 0 || penalty.compareTo(BigDecimal.ZERO) != 0 || commission.compareTo(BigDecimal.ZERO) != 0 || taxFuel.compareTo(BigDecimal.ZERO) != 0;
            }
        };
        Iterator iterator = tickets.iterator();
        while (iterator.hasNext()) {
            BaseSalesReportTicket ticket = (BaseSalesReportTicket)iterator.next();
            if (filter.accept((SuTicket)ticket)) continue;
            iterator.remove();
        }
        if (tickets.isEmpty()) {
            return;
        }
        int shiftLinesCount = sheet.getLastRowNum() - 5;
        int lineNumber = 5;
        for (int i = 0; i < tickets.size(); ++i) {
            SuTicket ticket = (SuTicket)tickets.get(i);
            ++lineNumber;
            if (i < tickets.size() - 1) {
                ExcelUtils.insertRow((HSSFSheet)sheet, (int)lineNumber, (int)10, (int)shiftLinesCount);
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (String)ticket.getTicketNumber());
            BigDecimal tariff = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TARIFF));
            BigDecimal taxOthers = MiscUtil.nonNull((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_STATE), ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_OTHERS)}));
            BigDecimal taxCarrier = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_CARRIER));
            BigDecimal penalty = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.PENALTY)).add(MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.CONTRACT_PENALTY)));
            BigDecimal commission = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.COMMISSION));
            BigDecimal taxFuel = MiscUtil.nonNull((BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.TAX_FUEL));
            if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ACM) {
                tariff = tariff.negate();
                taxOthers = taxOthers.negate();
                taxCarrier = taxCarrier.negate();
                penalty = penalty.negate();
                commission = commission.negate();
                taxFuel = taxFuel.negate();
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)2, (BigDecimal)tariff);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)3, (BigDecimal)taxOthers);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)4, (BigDecimal)taxCarrier);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)5, (BigDecimal)penalty);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)6, (BigDecimal)commission);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)7, (BigDecimal)taxFuel);
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)String.format("SUM(B%s:G%1$s)", lineNumber));
        }
        Integer startRangeIndex = 6;
        Integer endRangeIndex = 6 + tickets.size() - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(++lineNumber), (int)1, (int)1, (int)2, (String)String.format("=SUM(B%s:B%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)3, (String)String.format("=SUM(C%s:C%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)4, (String)String.format("=SUM(D%s:D%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)5, (String)String.format("=SUM(E%s:E%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)6, (String)String.format("=SUM(F%s:F%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)7, (String)String.format("=SUM(G%s:G%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)String.format("=SUM(H%s:H%s)", startRangeIndex, endRangeIndex));
    }

    protected List<TariffType> getTariffTypes() {
        return Arrays.asList(TariffType.REGULAR, TariffType.GROUP);
    }

    private static interface Filter {
        public boolean accept(SuTicket var1);
    }
}

