/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.registry;

import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuAgencyMemoRegistryBlockCharterListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuAgencyMemoRegistryCharterListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuAgencyMemoRegistryRegularListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuRegistryMvlNewPageWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuRegistryRegisterListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuRegistryScnrListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuRegistrySettlementLetterPageWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuRegistryVvlNewPageWorksheetHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SuRegistryRender<T extends BaseSalesReportTicket>
extends BasePoiSalesReportRenderHandler<BaseSalesReportTicket> {
    @Override
    protected List<PoiWorksheetData<BaseSalesReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<BaseSalesReportTicket>> result = new ArrayList<PoiWorksheetData<BaseSalesReportTicket>>();
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.REGISTER;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MEMO";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.ADM_REGULAR;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MEMO";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.ADM_CHARTER;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MEMO";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.ADM_BLOCK_CHARTER;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SCNR";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.SCNR;
            }

            @Override
            public int getProirity() {
                return 5;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "\u0421\u0432\u043e\u0434\u043d\u043e\u0435 \u0420\u041f";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.SETTLEMENT_LETTER;
            }

            @Override
            public int getProirity() {
                return 6;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "VVL";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.VVL;
            }

            @Override
            public int getProirity() {
                return 7;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MVL";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.MVL;
            }

            @Override
            public int getProirity() {
                return 8;
            }
        });
        return result;
    }

    @Override
    protected void initializeDataList(List<PoiWorksheetData<BaseSalesReportTicket>> dataList, Map<String, Object> data) {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null) {
            return;
        }
        for (ReportBatchData batchData : batchDataList) {
            if (batchData.getBatchId().startsWith("MVL_BC")) continue;
            for (PoiWorksheetData<BaseSalesReportTicket> wd : dataList) {
                switch ((Definitions)wd.getDefinition()) {
                    case REGISTER: 
                    case SCNR: {
                        if (batchData.getBatchId().equals("MEMO")) break;
                        wd.getTickets().addAll(batchData.getTickets());
                        break;
                    }
                    case ADM_REGULAR: 
                    case ADM_CHARTER: 
                    case ADM_BLOCK_CHARTER: {
                        if (!batchData.getBatchId().equals("MEMO")) break;
                        wd.getTickets().addAll(batchData.getTickets());
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected String getTemplateFileName() {
        return "AeroflotReg.xls";
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return "" + (String)data.get("AIRLINE_IATA_CODE") + "_" + (String)data.get("AGENCY_IATA_CODE") + "_\u0421\u0432\u043e\u0434\u043d\u044b\u0439 \u0440\u0435\u0435\u0441\u0442\u0440" + (String)data.get("KEY_REPORT_FILENAME");
    }

    @Override
    public String getId() {
        return null;
    }

    public static enum Definitions implements PoiWorksheetDefinition<BaseSalesReportTicket>
    {
        REGISTER{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuRegistryRegisterListWorksheetHandler();
            }
        }
        ,
        ADM_REGULAR{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuAgencyMemoRegistryRegularListWorksheetHandler();
            }
        }
        ,
        ADM_CHARTER{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuAgencyMemoRegistryCharterListWorksheetHandler();
            }
        }
        ,
        ADM_BLOCK_CHARTER{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuAgencyMemoRegistryBlockCharterListWorksheetHandler();
            }
        }
        ,
        SCNR{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuRegistryScnrListWorksheetHandler();
            }
        }
        ,
        SETTLEMENT_LETTER{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuRegistrySettlementLetterPageWorksheetHandler();
            }
        }
        ,
        VVL{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuRegistryVvlNewPageWorksheetHandler();
            }
        }
        ,
        MVL{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new SuRegistryMvlNewPageWorksheetHandler();
            }
        };


        @Override
        public String getWorksheetTemplateName() {
            return this.name();
        }
    }
}

