/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.registry;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuRegistryScnrListWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ArrayList tickets = (ArrayList)data.getTickets();
        if (tickets.isEmpty()) {
            return;
        }
        int lineNumber = 2;
        boolean shiftRows = false;
        for (BaseSalesReportTicket t : tickets) {
            SuTicket ticket = (SuTicket)t;
            if (ticket.isEticket() || ticket.getScn() == null || ticket.getScn().isEmpty()) continue;
            if (!shiftRows) {
                sheet.shiftRows(lineNumber, lineNumber + 5, tickets.size());
                shiftRows = true;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (int)(lineNumber - 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)2, (int)ticket.getBatchNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)3, (String)ticket.getBatchType());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)4, (int)ticket.getTransactionNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)5, (String)(ticket.getTicketSeries() + " " + ticket.getTicketNumber()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)6, (String)ticket.getScn());
            ++lineNumber;
        }
    }
}

