/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.registry;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuRegistryLetterItem;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuRegistryVvlPageWorksheetHandler
extends BaseSuRegistryWorksheetHandler<BaseSalesReportTicket> {
    private final int linesCnt = 46;

    protected TransportationType getTransportationType() {
        return TransportationType.DOMESTIC;
    }

    protected String getVatRate() {
        BigDecimal vat = DictHelper.getDefaultVat();
        return vat != null ? vat.toString() : null;
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        sheet.setForceFormulaRecalculation(true);
        TreeMap items = (TreeMap)globalData.get("key-registry-letters-data");
        if (items == null) {
            return;
        }
        String vatValue = this.getVatRate();
        if (!TextUtil.isBlank((String)vatValue)) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)73, (int)1, (int)1, (int)4, (String)vatValue);
        }
        SuRegistryLetterItem[] pageItems = new SuRegistryLetterItem[46];
        String tt = this.getTransportationType().name();
        String psSell = ProductStatus.SELL.name();
        String psExch = ProductStatus.EXCHANGE.name();
        String psRef = ProductStatus.REFUND.name();
        pageItems[0] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.Fare.name());
        pageItems[1] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.InterlineFare.name());
        pageItems[2] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.EbtFare.name());
        pageItems[3] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.OtherTax.name());
        pageItems[4] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.YqTax.name());
        pageItems[5] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.RuTax.name());
        pageItems[6] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.Comm.name());
        pageItems[7] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.Bonus.name());
        pageItems[8] = null;
        pageItems[9] = null;
        pageItems[10] = null;
        pageItems[11] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.Fare.name());
        pageItems[12] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.InterlineFare.name());
        pageItems[13] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.OtherTax.name());
        pageItems[14] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.YqTax.name());
        pageItems[15] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.RuTax.name());
        pageItems[16] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.Penalty.name());
        pageItems[17] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.Comm.name());
        pageItems[18] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.CCFare.name());
        pageItems[19] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.CCInterlineFare.name());
        pageItems[20] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.CCOtherTax.name());
        pageItems[21] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.CCYqTax.name());
        pageItems[22] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.CCRuTax.name());
        pageItems[23] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.CCPenalty.name());
        pageItems[24] = (SuRegistryLetterItem)items.get(tt + psExch + SuRegistryLetterItem.TableDefinition.CCComm.name());
        pageItems[25] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.CCFare.name());
        pageItems[26] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.CCInterlineFare.name());
        pageItems[27] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.CCOtherTax.name());
        pageItems[28] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.CCYqTax.name());
        pageItems[29] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.CCRuTax.name());
        pageItems[30] = (SuRegistryLetterItem)items.get(tt + psSell + SuRegistryLetterItem.TableDefinition.CCComm.name());
        pageItems[31] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.Fare.name());
        pageItems[32] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.InterlineFare.name());
        pageItems[33] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.EbtFare.name());
        pageItems[34] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.OtherTax.name());
        pageItems[35] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.YqTax.name());
        pageItems[36] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.RuTax.name());
        pageItems[37] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.Penalty.name());
        pageItems[38] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.Comm.name());
        pageItems[39] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.CCFare.name());
        pageItems[40] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.CCInterlineFare.name());
        pageItems[41] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.CCOtherTax.name());
        pageItems[42] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.CCYqTax.name());
        pageItems[43] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.CCRuTax.name());
        pageItems[44] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.CCPenalty.name());
        pageItems[45] = (SuRegistryLetterItem)items.get(tt + psRef + SuRegistryLetterItem.TableDefinition.CCComm.name());
        for (int cnt = 0; cnt < 46; ++cnt) {
            SuRegistryLetterItem item = pageItems[cnt];
            if (item == null) continue;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(cnt + 13), (int)1, (int)1, (int)4, (int)item.docCount);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(cnt + 13), (int)1, (int)1, (int)5, (BigDecimal)BigDecimal.valueOf(item.debit));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(cnt + 13), (int)1, (int)1, (int)6, (BigDecimal)BigDecimal.valueOf(item.credit));
        }
    }
}

