/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.saleregisters;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuExchangeCreditCardWorksheetHandler
extends BaseRegistryWorksheetHandler {
    protected static final int START_ROW_INDEX = 12;
    protected static final int ROW_SHIFT_AMOUNT = 10;
    protected static final int COLUMN_AMOUNT = 23;
    private final BaseRegistryWorksheetHandler.IColumn[] columns = new BaseRegistryWorksheetHandler.IColumn[]{Column.TICKET_FARE, Column.OTHER_TAXES, Column.FUEL_TAX, Column.RU_TAX, Column.YR_TAX, Column.EXC_FARE, Column.EXC_TAXES, Column.EXC_YR_TAX, Column.EXC_YQ_TAX, Column.EXTRA_FARE, Column.EXTRA_TAXES, Column.EXTRA_YR, Column.EXTRA_YQ, Column.EXTRA_RU, Column.PENALTY, Column.EXTRA_CASH, Column.CREDIT_CARD_SUM};

    @Override
    protected void setFieldValue(BaseSalesReportTicket argTicket, int itemIndex, BaseRegistryWorksheetHandler.IColumn column) throws Exception {
        SuTicket ticket = (SuTicket)argTicket;
        boolean sale = ticket.getStatus() == ProductStatus.SELL;
        switch ((Column)column) {
            case ITEM_NUMBER: {
                if (!sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (int)(itemIndex + 1));
                break;
            }
            case TICKET_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketNumber());
                break;
            }
            case TICKET_ISSUE_DATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (Date)ticket.getIssueDate());
                break;
            }
            case TICKET_ROUTING: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketRouting());
                break;
            }
            case TICKET_SCN: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getScn());
                break;
            }
            case TICKET_FARE: {
                if (!sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getEquivalentFare());
                break;
            }
            case OTHER_TAXES: {
                if (!sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getOtherTaxAmount()));
                break;
            }
            case FUEL_TAX: {
                if (!sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YQ")));
                break;
            }
            case YR_TAX: {
                if (!sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YR")));
                break;
            }
            case RU_TAX: {
                if (!sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("RU")));
                break;
            }
            case PENALTY: {
                if (!sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getPenalty());
                break;
            }
            case EXTRA_FARE: {
                if (!sale) break;
                Product exchTicket = ticket.getPrevTicket();
                BigDecimal fare = BigDecimal.ZERO;
                if (exchTicket != null) {
                    fare = AirProductHelper.getEquivalentFare((Product)exchTicket);
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getEquivalentFare().subtract(fare));
                break;
            }
            case EXTRA_TAXES: {
                if (!sale) break;
                Product exchTicket = ticket.getPrevTicket();
                BigDecimal otherTaxes = BigDecimal.ZERO;
                if (exchTicket != null) {
                    otherTaxes = AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Collection)exchTicket.getTaxes(), (boolean)false, (String[])new String[]{"YQ", "RU", "CP"});
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getOtherTaxAmount() - otherTaxes.doubleValue()));
                break;
            }
            case EXTRA_YQ: {
                if (!sale) break;
                Product exchTicket = ticket.getPrevTicket();
                BigDecimal YQ = BigDecimal.ZERO;
                if (exchTicket != null) {
                    YQ = AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Product)exchTicket, (String[])new String[]{"YQ"});
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YQ") - YQ.doubleValue()));
                break;
            }
            case EXTRA_YR: {
                if (!sale) break;
                Product exchTicket = ticket.getPrevTicket();
                BigDecimal YR = BigDecimal.ZERO;
                if (exchTicket != null) {
                    YR = AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Product)exchTicket, (String[])new String[]{"YR"});
                }
                if (YR == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YR") - YR.doubleValue()));
                break;
            }
            case EXTRA_RU: {
                if (!sale) break;
                Product exchTicket = ticket.getPrevTicket();
                BigDecimal RU = BigDecimal.ZERO;
                if (exchTicket != null) {
                    RU = AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Product)exchTicket, (String[])new String[]{"RU"});
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("RU") - RU.doubleValue()));
                break;
            }
            case EXC_FARE: {
                if (sale) break;
                double fare = ticket.getEquivalentFare() != null ? Math.abs(ticket.getEquivalentFare().doubleValue()) : 0.0;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(fare));
                break;
            }
            case EXC_TAXES: {
                if (sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(Math.abs(ticket.getOtherTaxAmount())));
                break;
            }
            case EXC_YR_TAX: {
                if (sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(Math.abs(ticket.getTaxEquivAmountByCode("YR"))));
                break;
            }
            case EXC_YQ_TAX: {
                if (sale) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(Math.abs(ticket.getTaxEquivAmountByCode("YQ"))));
                break;
            }
            case EXTRA_CASH: {
                Product exchProduct;
                if (!sale || (exchProduct = ticket.getPrevTicket()) == null || !exchProduct.getStatus().equals((Object)ProductStatus.EXCHANGE)) break;
                BigDecimal extraCash = BigDecimal.ZERO;
                for (ProductFop fop : ticket.getFops()) {
                    if (fop.getCard() != null || fop.getType() != PaymentType.CASH || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    extraCash = extraCash.add(fop.getAmount().getValue());
                }
                for (ProductFop fop : AirProductHelper.getVendorContractRelation((Product)exchProduct).getFops()) {
                    if (fop.getCard() != null || fop.getType() != PaymentType.CASH || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    extraCash = extraCash.subtract(fop.getAmount().getValue());
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)extraCash);
                break;
            }
            case CREDIT_CARD_SUM: {
                if (!sale) break;
                BigDecimal ccSum = BigDecimal.ZERO;
                for (ProductFop fop : ticket.getFops()) {
                    if (fop.getCard() == null || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    ccSum = ccSum.add(fop.getAmount().getValue());
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ccSum);
                break;
            }
            case CREDIT_CARD_NUMBER: {
                if (!sale) break;
                String ccNumber = null;
                for (ProductFop fop : ticket.getFops()) {
                    if (fop.getCard() == null) continue;
                    ccNumber = fop.getCard().getNumber();
                    break;
                }
                if (ccNumber == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ccNumber);
                break;
            }
        }
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.init(sheet, 12, 10, 23);
        super.fill(wb, sheet, data, globalData);
    }

    @Override
    public BaseRegistryWorksheetHandler.IColumn[] getColumns() {
        return Column.values();
    }

    @Override
    protected void fillSubtotal(int startRow, int endRow) throws Exception {
        this.setSubtotalForColumn(this.columns, this.currentRow, startRow, endRow);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 1), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow, 10));
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 1), (int)1, (int)1, (int)Column.EXTRA_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.EXTRA_FARE.getExcelColumn().getColumnName(), this.currentRow, 10));
    }

    @Override
    protected void fillTotal() throws Exception {
        this.setTotalFormulaForColumn(this.columns, this.currentRow + 2);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 3), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow + 2, 10));
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 3), (int)1, (int)1, (int)Column.EXTRA_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.EXTRA_FARE.getExcelColumn().getColumnName(), this.currentRow + 2, 10));
    }

    private static enum Column implements BaseRegistryWorksheetHandler.IColumn
    {
        ITEM_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        TICKET_SCN{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        TICKET_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        }
        ,
        TICKET_ISSUE_DATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.D;
            }
        }
        ,
        TICKET_ROUTING{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.E;
            }
        }
        ,
        TICKET_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.F;
            }
        }
        ,
        OTHER_TAXES{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.G;
            }
        }
        ,
        FUEL_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.H;
            }
        }
        ,
        YR_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        RU_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.J;
            }
        }
        ,
        EXC_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.K;
            }
        }
        ,
        EXC_TAXES{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.L;
            }
        }
        ,
        EXC_YR_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.M;
            }
        }
        ,
        EXC_YQ_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.N;
            }
        }
        ,
        EXTRA_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.O;
            }
        }
        ,
        EXTRA_TAXES{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.P;
            }
        }
        ,
        EXTRA_YQ{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.Q;
            }
        }
        ,
        EXTRA_YR{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.R;
            }
        }
        ,
        EXTRA_RU{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.S;
            }
        }
        ,
        PENALTY{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.T;
            }
        }
        ,
        EXTRA_CASH{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.U;
            }
        }
        ,
        CREDIT_CARD_SUM{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.V;
            }
        }
        ,
        CREDIT_CARD_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.W;
            }
        };

    }
}

