/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.saleregisters;

import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuSaleCreditCardWorksheetHandler
extends BaseRegistryWorksheetHandler {
    protected static final int START_ROW_INDEX = 12;
    protected static final int ROW_SHIFT_AMOUNT = 9;
    protected static final int COLUMN_AMOUNT = 14;
    private final BaseRegistryWorksheetHandler.IColumn[] columns = new BaseRegistryWorksheetHandler.IColumn[]{Column.TICKET_FARE, Column.OTHER_TAXES, Column.FUEL_TAX, Column.YR_TAX, Column.RU_TAX, Column.CREDIT_CARD_SUM, Column.CASH_SUM};
    private final BaseRegistryWorksheetHandler.IColumn[] comm = new BaseRegistryWorksheetHandler.IColumn[]{Column.COMMISSION};

    @Override
    protected void setFieldValue(BaseSalesReportTicket argTicket, int itemIndex, BaseRegistryWorksheetHandler.IColumn column) throws Exception {
        SuTicket ticket = (SuTicket)argTicket;
        switch ((Column)column) {
            case ITEM_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (int)(itemIndex + 1));
                break;
            }
            case TICKET_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketNumber());
                break;
            }
            case TICKET_SCN: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getScn());
                break;
            }
            case TICKET_ISSUE_DATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (Date)ticket.getIssueDate());
                break;
            }
            case TICKET_ROUTING: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketRouting());
                break;
            }
            case TICKET_FARE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getEquivalentFare());
                break;
            }
            case OTHER_TAXES: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getOtherTaxAmount()));
                break;
            }
            case FUEL_TAX: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YQ")));
                break;
            }
            case YR_TAX: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YR")));
                break;
            }
            case RU_TAX: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("RU")));
                break;
            }
            case CREDIT_CARD_NUMBER: {
                String creditCardNumber = null;
                for (ProductFop fop : ticket.getFops()) {
                    if (fop.getCard() == null) continue;
                    creditCardNumber = fop.getCard().getNumber();
                }
                if (creditCardNumber == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)creditCardNumber);
                break;
            }
            case CREDIT_CARD_SUM: {
                BigDecimal creditCardSum = BigDecimal.ZERO;
                for (ProductFop fop : ticket.getFops()) {
                    if (fop.getCard() == null || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    creditCardSum = creditCardSum.add(fop.getAmount().getValue());
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)creditCardSum);
                break;
            }
            case CASH_SUM: {
                BigDecimal cashSum = BigDecimal.ZERO;
                for (ProductFop fop : ticket.getFops()) {
                    if (fop.getCard() != null || fop.getType() != PaymentType.CASH || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    cashSum = cashSum.add(fop.getAmount().getValue());
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)cashSum);
                break;
            }
            case COMMISSION: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getVendorEquivalentCommission());
                break;
            }
        }
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.init(sheet, 12, 9, 14);
        super.fill(wb, sheet, data, globalData);
        this.currentSheet.autoSizeColumn(4);
    }

    @Override
    protected void fillSubtotal(int startRow, int endRow) throws Exception {
        this.setSubtotalForColumn(this.columns, this.currentRow, startRow, endRow);
        this.setSubtotalForColumn(this.comm, this.currentRow + 1, startRow, endRow);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 1), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow, 10));
    }

    @Override
    public BaseRegistryWorksheetHandler.IColumn[] getColumns() {
        return Column.values();
    }

    @Override
    protected void fillTotal() throws Exception {
        this.setTotalFormulaForColumn(this.columns, this.currentRow + 2);
        this.setTotalFormulaForColumn(this.comm, this.currentRow + 3);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 3), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow + 2, 10));
    }

    private static enum Column implements BaseRegistryWorksheetHandler.IColumn
    {
        ITEM_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        TICKET_SCN{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        TICKET_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        }
        ,
        TICKET_ISSUE_DATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.D;
            }
        }
        ,
        TICKET_ROUTING{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.E;
            }
        }
        ,
        TICKET_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.F;
            }
        }
        ,
        OTHER_TAXES{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.G;
            }
        }
        ,
        FUEL_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.H;
            }
        }
        ,
        YR_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        RU_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        CREDIT_CARD_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.J;
            }
        }
        ,
        CREDIT_CARD_SUM{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.K;
            }
        }
        ,
        CASH_SUM{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.L;
            }
        }
        ,
        COMMISSION{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.M;
            }
        };

    }
}

