/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.saleregisters;

import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuSaleVVLWorksheetHandler
extends BaseRegistryWorksheetHandler {
    protected static final int START_ROW_INDEX = 11;
    protected static final int ROW_SHIFT_AMOUNT = 9;
    protected static final int COLUMN_AMOUNT = 11;
    private final BaseRegistryWorksheetHandler.IColumn[] columns = new BaseRegistryWorksheetHandler.IColumn[]{Column.TICKET_FARE, Column.OTHER_TAXES, Column.FUEL_TAX, Column.YR_TAX, Column.RU_TAX};
    private final BaseRegistryWorksheetHandler.IColumn[] comm = new BaseRegistryWorksheetHandler.IColumn[]{Column.COMMISSION};

    @Override
    protected void setFieldValue(BaseSalesReportTicket argTicket, int itemIndex, BaseRegistryWorksheetHandler.IColumn column) throws Exception {
        SuTicket ticket = (SuTicket)argTicket;
        switch ((Column)column) {
            case ITEM_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (int)(itemIndex + 1));
                break;
            }
            case TICKET_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketNumber());
                break;
            }
            case TICKET_SCN: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getScn());
                break;
            }
            case TICKET_ISSUE_DATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (Date)ticket.getIssueDate());
                break;
            }
            case TICKET_ROUTING: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketRouting());
                break;
            }
            case TICKET_FARE: {
                BigDecimal equivalentFare = ticket.getEquivalentFare();
                if (ticket.isDuplicate()) {
                    equivalentFare = BigDecimal.ZERO;
                }
                if (ticket.getTariffType() == TariffType.GROUP && ticket.getPrepayed() != null && ticket.getEquivalentFare() != null) {
                    equivalentFare = ticket.getEquivalentFare().subtract(ticket.getPrepayed());
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)equivalentFare);
                break;
            }
            case OTHER_TAXES: {
                BigDecimal otherTaxes = null;
                otherTaxes = ticket.isDuplicate() ? AirProductTaxHelper.getEquivalentTaxesAmount(ticket.getTaxes(), (String[])new String[]{"CP"}) : BigDecimal.valueOf(ticket.getOtherTaxAmount());
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)otherTaxes);
                break;
            }
            case FUEL_TAX: {
                double fuelTax = ticket.getTaxEquivAmountByCode("YQ");
                if (ticket.isDuplicate()) {
                    fuelTax = 0.0;
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(fuelTax));
                break;
            }
            case YR_TAX: {
                double yrTax = ticket.getTaxEquivAmountByCode("YR");
                if (ticket.isDuplicate()) {
                    yrTax = 0.0;
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(yrTax));
                break;
            }
            case RU_TAX: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("RU")));
                break;
            }
            case COMMISSION: {
                BigDecimal commission = ticket.getVendorEquivalentCommission();
                if (ticket.isDuplicate()) {
                    commission = null;
                }
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)commission);
                break;
            }
        }
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.init(sheet, 11, 9, 11);
        super.fill(wb, sheet, data, globalData);
        this.currentSheet.autoSizeColumn(4);
    }

    @Override
    public BaseRegistryWorksheetHandler.IColumn[] getColumns() {
        return Column.values();
    }

    @Override
    protected void fillSubtotal(int startRow, int endRow) throws Exception {
        this.setSubtotalForColumn(this.columns, this.currentRow, startRow, endRow);
        this.setSubtotalForColumn(this.comm, this.currentRow + 1, startRow, endRow);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 1), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow, 9));
    }

    @Override
    protected void fillTotal() throws Exception {
        this.setTotalFormulaForColumn(this.columns, this.currentRow + 2);
        this.setTotalFormulaForColumn(this.comm, this.currentRow + 3);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 3), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow + 2, 9));
    }

    private static enum Column implements BaseRegistryWorksheetHandler.IColumn
    {
        ITEM_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        TICKET_SCN{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        TICKET_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        }
        ,
        TICKET_ISSUE_DATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.D;
            }
        }
        ,
        TICKET_ROUTING{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.E;
            }
        }
        ,
        TICKET_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.F;
            }
        }
        ,
        OTHER_TAXES{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.G;
            }
        }
        ,
        FUEL_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.H;
            }
        }
        ,
        YR_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        RU_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.J;
            }
        }
        ,
        COMMISSION{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.K;
            }
        };

    }
}

