/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.xml;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class BaseSuXmlBatchHandler {
    protected final DecimalFormat decimalFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private final Map<MCOCategory, String> mcoCategory2emscCode = new HashMap<MCOCategory, String>(){
        private static final long serialVersionUID = 4535512675124348288L;
        {
            this.put(MCOCategory.PENALTY, "995");
            this.put(MCOCategory.RETURN_TICKET, "98D");
            this.put(MCOCategory.REBOOKING, "98F");
            this.put(MCOCategory.ADDITIONAL_TARIFF, "98K");
            this.put(MCOCategory.SEAT_RESERVATION, "0B5");
            this.put(MCOCategory.SPECIAL_FOOD, "0B3");
            this.put(MCOCategory.EXCESS_LUGGAGE, "0GO");
            this.put(MCOCategory.INFORMATION, "98J");
            this.put(MCOCategory.UNESCORTED_MINOR, "0BH");
            this.put(MCOCategory.STICKER, "98F");
            this.put(MCOCategory.ANIMALS, "0BT");
            this.put(MCOCategory.COMFORT_PLUS, "0B5");
            this.put(MCOCategory.WEAPON, "0HW");
        }
    };
    private final Map<MCOCategory, String> mcoCategory2usageCode = new HashMap<MCOCategory, String>(){
        private static final long serialVersionUID = 4026042320487781210L;
        {
            this.put(MCOCategory.PTA, "PTA");
            this.put(MCOCategory.RETURN_FARE_DIFFERENCE, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
            this.put(MCOCategory.GROUP_PREPAYMENT, "\u041f\u0440\u043e\u0447\u0435\u0435");
            this.put(MCOCategory.PENALTY, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
            this.put(MCOCategory.REBOOKING, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
            this.put(MCOCategory.STICKER, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
            this.put(MCOCategory.ADDITIONAL_TARIFF, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
            this.put(MCOCategory.DUPLICATE_TICKET, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
            this.put(MCOCategory.INFORMATION, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
            this.put(MCOCategory.GROUP_PENALTY, "\u041f\u0440\u043e\u0447\u0435\u0435");
            this.put(MCOCategory.SEAT_RESERVATION, "\u041f\u0440\u043e\u0447\u0435\u0435");
            this.put(MCOCategory.SPECIAL_FOOD, "\u041f\u0440\u043e\u0447\u0435\u0435");
            this.put(MCOCategory.UNESCORTED_MINOR, "\u041f\u0440\u043e\u0447\u0435\u0435");
            this.put(MCOCategory.COMFORT_PLUS, "\u041f\u0440\u043e\u0447\u0435\u0435");
            this.put(MCOCategory.PAPER_SURCHARGE, "\u041f\u0440\u043e\u0447\u0435\u0435");
            this.put(MCOCategory.NOT_SOLD_SEATS, "\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u043d\u0435\u043f\u0440\u043e\u0434\u0430\u043d\u043d\u044b\u0435 \u0431/\u043c\u0435\u0441\u0442\u0430");
        }
    };
    private final Map<MCOCategory, String> mcoCategory2otherKind = new HashMap<MCOCategory, String>(){
        private static final long serialVersionUID = 6545345497009977143L;
        {
            this.put(MCOCategory.GROUP_PREPAYMENT, "\u041e\u043f\u043b\u0430\u0442\u0430 \u0433\u0440\u0443\u043f\u043f");
            this.put(MCOCategory.GROUP_PENALTY, "\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u0443");
            this.put(MCOCategory.UNESCORTED_MINOR, "\u0414\u0435\u0442\u0438 \u0431\u0435\u0437 \u0441\u043e\u043f\u0440\u043e\u0432");
            this.put(MCOCategory.COMFORT_PLUS, "\u041a\u043e\u043c\u0444\u043e\u0440\u0442+");
            this.put(MCOCategory.PAPER_SURCHARGE, "\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0441\u0431\u043e\u0440");
            this.put(MCOCategory.ADDITIONAL_TARIFF, "Vol. UpGrade");
        }
    };
    private boolean isBatchCancel;
    private boolean isMcoTicketReturn;
    private boolean isMcoSeatPrereservation;

    protected static Element writeElement(Document doc, String namespaceUri, String name, Object value) {
        Element result = doc.createElementNS(namespaceUri, name);
        if (value != null) {
            result.appendChild(doc.createTextNode(value.toString()));
        }
        return result;
    }

    protected static String getCouponName(SuTicket ticket) {
        String result = "";
        switch (ticket.getStatus()) {
            case EXCHANGE: 
            case REFUND: {
                result = "R";
                break;
            }
            case SELL: {
                result = "F";
                break;
            }
            case VOID: {
                result = "V";
                break;
            }
        }
        return result;
    }

    protected static String getTicketElementName(SuTicket ticket) {
        if (ticket.getReportTicketType() == BaseSalesReportTicket.ReportTicketType.MEMO) {
            return "ADM";
        }
        if (ticket.getStatus() == ProductStatus.VOID) {
            return "CANCEL";
        }
        switch (ticket.getProductCategory()) {
            case AIR: {
                return "TCT";
            }
            case MCO: {
                if (ticket.getMcoCategory() == MCOCategory.RETURN_TICKET) {
                    return "TCT";
                }
                if (ticket.isEticket()) {
                    return "MCO_EMD";
                }
                return "MCO";
            }
            case EXCESS_BAGAGE: {
                if (ticket.isEticket()) {
                    return "EBT_EMD";
                }
                return "EBT";
            }
        }
        return null;
    }

    protected static Element getChildElement(Element parent, String name) {
        NodeList nodes = parent.getElementsByTagNameNS(parent.getNamespaceURI(), name);
        if (nodes.getLength() >= 1) {
            return (Element)nodes.item(nodes.getLength() - 1);
        }
        return null;
    }

    protected static Element getDocElement(Element parent) {
        Element xmlTransaction = BaseSuXmlBatchHandler.getChildElement(parent, "TRANSACTION");
        if (xmlTransaction != null) {
            return BaseSuXmlBatchHandler.getChildElement(xmlTransaction, "DOC");
        }
        return null;
    }

    protected static Element getFopElement(Element parent) {
        Element xmlTransaction = BaseSuXmlBatchHandler.getChildElement(parent, "TRANSACTION");
        if (xmlTransaction != null) {
            return BaseSuXmlBatchHandler.getChildElement(xmlTransaction, "FOP");
        }
        return null;
    }

    protected static Element getTicketElement(Element parent) {
        Element docElement = BaseSuXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            return BaseSuXmlBatchHandler.getChildElement(docElement, "TCT");
        }
        return null;
    }

    protected static Element getMemoElement(Element parent) {
        Element docElement = BaseSuXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            return BaseSuXmlBatchHandler.getChildElement(docElement, "ADM");
        }
        return null;
    }

    protected static Element getBagageElement(Element parent, SuTicket ticket) {
        Element docElement = BaseSuXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            if (ticket.isEticket()) {
                return BaseSuXmlBatchHandler.getChildElement(docElement, "EBT_EMD");
            }
            return BaseSuXmlBatchHandler.getChildElement(docElement, "EBT");
        }
        return null;
    }

    protected static String getFirstBlankCouponsNames(SuTicket ticket) {
        StringBuilder buf = new StringBuilder("");
        switch (ticket.getStatus()) {
            case EXCHANGE: 
            case REFUND: 
            case SELL: {
                buf.append(BaseSuXmlBatchHandler.getCouponNames(ticket, 0));
                break;
            }
        }
        return buf.toString();
    }

    protected static String getCouponNames(SuTicket ticket, int blankIndex) {
        int i;
        StringBuilder result = new StringBuilder();
        int couponsCnt = ticket.getCouponsCount();
        int segmentMaxNo = couponsCnt * (ticket.getConjCount() + 1);
        String[] segmentsTab = new String[segmentMaxNo];
        String voidCoupon = " ";
        String notVoidCoupon = "R";
        switch (ticket.getStatus()) {
            case SELL: {
                voidCoupon = "V";
                notVoidCoupon = "F";
                break;
            }
        }
        for (int i2 = 0; i2 < segmentMaxNo; ++i2) {
            segmentsTab[i2] = voidCoupon;
        }
        for (Segment seg : ticket.getSegments()) {
            if (seg.getRecordNumber() <= 0 || seg.getRecordNumber() > segmentMaxNo) continue;
            segmentsTab[seg.getRecordNumber() - 1] = notVoidCoupon;
        }
        if (ProductCategory.MCO.equals((Object)ticket.getProductCategory()) && ticket.isEticket() && couponsCnt == 1 && segmentMaxNo == 1 && !ProductStatus.REFUND.equals((Object)ticket.getStatus())) {
            segmentsTab[0] = "F";
        }
        for (i = 0; i < segmentMaxNo - 1; ++i) {
            if (!segmentsTab[i].equals("V") || !segmentsTab[i + 1].equals("F")) continue;
            segmentsTab[i] = "S";
        }
        for (i = 0; i < couponsCnt; ++i) {
            result.append(segmentsTab[i + blankIndex * couponsCnt]);
        }
        return result.toString();
    }

    protected abstract String getTransactionType(SuTicket var1);

    public void renderReportBatch(Document doc, Element parent, SuSalesReportBatchData<SuTicket> batchData) {
        if (batchData.getTickets().isEmpty()) {
            return;
        }
        this.isBatchCancel = batchData.getBatchId().equals("CANCEL");
        for (List<SuTicket> batch : this.getSubBatches(batchData.getTickets())) {
            Element xmlBatch = null;
            for (SuTicket ticket : batch) {
                if (xmlBatch == null) {
                    xmlBatch = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "BATCH", "");
                    xmlBatch.setAttributeNS(null, "NO", Integer.toString(ticket.getBatchNo()));
                    xmlBatch.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "NAME", ticket.getBatchId()));
                    parent.appendChild(xmlBatch);
                }
                this.isMcoTicketReturn = ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.RETURN_TICKET;
                this.isMcoSeatPrereservation = ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.SEAT_RESERVATION;
                this.addTicketTransaction(doc, xmlBatch, ticket, ticket.getTransactionNo());
            }
            parent.appendChild(xmlBatch);
        }
    }

    protected void addMcoTicketTransaction(Document doc, Element parent, SuTicket mco, int ticketNo) {
        Element xmlTctItem = this.getTicketElement(parent, mco);
        boolean isSticker = false;
        if (mco.getMcoCategory() == MCOCategory.STICKER) {
            for (Product prod : mco.getRelatedProducts()) {
                if (prod.getStatus() != ProductStatus.SELL) continue;
                isSticker = true;
                break;
            }
        }
        if (xmlTctItem != null) {
            Element xmlTransaction;
            String tourCode;
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getFirstBlankCouponsNames(mco)));
            MCOCategory mcoCategory = mco.getMcoCategory();
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PXNM", mco.getPassengerName()));
            Element xmlFareItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
            if (mcoCategory == MCOCategory.PENALTY || mcoCategory == MCOCategory.REBOOKING || mcoCategory == MCOCategory.STICKER || mcoCategory == MCOCategory.RETURN_TICKET || mcoCategory == MCOCategory.ADDITIONAL_TARIFF || mcoCategory == MCOCategory.DUPLICATE_TICKET || mcoCategory == MCOCategory.INFORMATION) {
                if (!this.isBatchCancel) {
                    this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, mco);
                }
            } else if (mcoCategory == MCOCategory.GROUP_PENALTY) {
                if (!this.isBatchCancel) {
                    Element xmlFareAmountItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
                    xmlFareItem.appendChild(xmlFareAmountItem);
                    if (xmlFareAmountItem != null) {
                        xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.decimalFormat.format(mco.getBaseFare() != null ? mco.getBaseFare().getValue() : Integer.valueOf(0))));
                        xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", doc.getElementsByTagName("CURRENCY").item(0).getTextContent()));
                        xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", mco.getFareRate().doubleValue()));
                        xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.decimalFormat.format(mco.getEquivalentFare())));
                        Element xmlFareCommissionItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COMMISSION", null);
                        String commRate = "0";
                        String commVal = this.decimalFormat.format((Object)0.0);
                        xmlFareCommissionItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CORT", commRate));
                        xmlFareCommissionItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COAM", commVal));
                        xmlFareItem.appendChild(xmlFareCommissionItem);
                    }
                }
            } else if (!this.isBatchCancel) {
                this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, mco);
            }
            xmlTctItem.appendChild(xmlFareItem);
            if (!this.isBatchCancel && (this.isMcoTicketReturn || this.isMcoSeatPrereservation || mco.getMcoCategory() == MCOCategory.GROUP_PENALTY || mco.getMcoCategory() == MCOCategory.GROUP_PREPAYMENT || mco.getMcoCategory() == MCOCategory.UNESCORTED_MINOR || mco.getMcoCategory() == MCOCategory.NOT_SOLD_SEATS || mco.getMcoCategory() == MCOCategory.COMFORT_PLUS || mco.getMcoCategory() == MCOCategory.SPECIAL_FOOD || mco.getMcoCategory() == MCOCategory.PAPER_SURCHARGE)) {
                this.appendTaxesElement(xmlTctItem, mco, doc, parent);
            }
            if (mcoCategory != null) {
                switch (mcoCategory) {
                    case PTA: 
                    case GROUP_PREPAYMENT: 
                    case NOT_SOLD_SEATS: {
                        this.addUsageCodeAndOtherKind(xmlTctItem, doc, parent, mcoCategory, mco.getBlankOwnerCode());
                        break;
                    }
                    case RETURN_FARE_DIFFERENCE: 
                    case PENALTY: 
                    case REBOOKING: 
                    case STICKER: 
                    case ADDITIONAL_TARIFF: 
                    case DUPLICATE_TICKET: 
                    case INFORMATION: {
                        this.addMainDocs(xmlTctItem, doc, parent, mco, false);
                        this.addUsageCodeAndOtherKind(xmlTctItem, doc, parent, mcoCategory, mco.getBlankOwnerCode());
                        break;
                    }
                    case GROUP_PENALTY: 
                    case SEAT_RESERVATION: 
                    case SPECIAL_FOOD: 
                    case UNESCORTED_MINOR: 
                    case COMFORT_PLUS: 
                    case PAPER_SURCHARGE: 
                    case EXCESS_LUGGAGE: 
                    case ADDITIONAL_TAX: 
                    case POSTAGE_FEE: 
                    case ANIMALS: 
                    case ADDITIONAL_SERVICES: {
                        this.addMainDocs(xmlTctItem, doc, parent, mco, true);
                        this.addUsageCodeAndOtherKind(xmlTctItem, doc, parent, mcoCategory, mco.getBlankOwnerCode());
                        break;
                    }
                }
                if (mcoCategory == MCOCategory.GROUP_PREPAYMENT) {
                    this.addPnrr(xmlTctItem, doc, parent, mcoCategory, mco.getPnr());
                }
            }
            if (!TextUtil.isBlank((String)(tourCode = mco.getTourCode())) && mcoCategory == MCOCategory.RETURN_TICKET) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TOUR", tourCode));
            }
            if ((xmlTransaction = BaseSuXmlBatchHandler.getChildElement(parent, "TRANSACTION")) != null && !this.isBatchCancel) {
                this.addFopSection(doc, parent, xmlTransaction, mco);
            }
        }
    }

    private void addUsageCodeAndOtherKind(Element xmlTctItem, Document doc, Element parent, MCOCategory mcoCategory, String blankOwnerCode) {
        String usageCode = this.getUsageCode(mcoCategory, blankOwnerCode);
        if (!TextUtil.isBlank((String)usageCode)) {
            String otherKind;
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", usageCode));
            if (!"FV".equals(blankOwnerCode) && !TextUtil.isBlank((String)(otherKind = this.getOtherKind(mcoCategory)))) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "OTHER_KIND", otherKind));
            }
        }
    }

    private void addPnrr(Element xmlTctItem, Document doc, Element parent, MCOCategory mcoCategory, String pnr) {
        if (!TextUtil.isBlank((String)pnr)) {
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PNRR", pnr));
        }
    }

    private void addMainDocs(Element xmlTctItem, Document doc, Element parent, SuTicket mco, boolean forAllRelatedProducts) {
        Product[] relatedProducts = mco.getRelatedProducts();
        String mainProductCode = mco.getProduct().getMainProductCode();
        String mainProductNumber = mco.getProduct().getMainProductNumber();
        Element xmlMainDocs = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
        if (relatedProducts == null || relatedProducts.length == 0) {
            if (TextUtil.nonBlank((String)mainProductCode) || TextUtil.nonBlank((String)mainProductNumber)) {
                String relatedTicketNumber = (TextUtil.nonBlankStr((String)mainProductCode) + " " + TextUtil.nonBlankStr((String)mainProductNumber)).trim();
                this.addMainDoc(xmlMainDocs, doc, parent, relatedTicketNumber);
            }
        } else if (!forAllRelatedProducts) {
            String relatedTicketNumber = (!TextUtil.isBlank((String)relatedProducts[0].getCarrierNumber()) || relatedProducts[0].getTicketType() != TicketType.FAKE ? relatedProducts[0].getCarrierNumber() : mco.getProduct().getCarrierNumber()) + " " + relatedProducts[0].getSystemNumber();
            this.addMainDoc(xmlMainDocs, doc, parent, relatedTicketNumber);
        } else {
            for (Product relProduct : relatedProducts) {
                String relatedTicketNumber = relProduct.getCarrierNumber() + " " + relProduct.getSystemNumber();
                this.addMainDoc(xmlMainDocs, doc, parent, relatedTicketNumber);
            }
        }
        xmlTctItem.appendChild(xmlMainDocs);
    }

    private void addMainDoc(Element xmlMainDocs, Document doc, Element parent, String relatedTicketNumber) {
        Element xmlMainDoc = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
        Element xmlMainDocTDNR = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
        xmlMainDoc.appendChild(xmlMainDocTDNR);
        xmlMainDocs.appendChild(xmlMainDoc);
    }

    protected void addMcoEmdTicketTransaction(Document doc, Element parent, SuTicket mco, int ticketNo) {
        Element xmlTctItem = this.getTicketElement(parent, mco);
        if (xmlTctItem != null) {
            Element xmlTransaction;
            String[] conjunctions;
            String curr;
            String tourCode;
            String cpui = BaseSuXmlBatchHandler.getFirstBlankCouponsNames(mco);
            if (!TextUtil.isBlank((String)cpui)) {
                boolean allVoid = true;
                for (int i = 0; i < cpui.length(); ++i) {
                    if (cpui.charAt(i) == 'V') continue;
                    allVoid = false;
                    break;
                }
                if (allVoid) {
                    cpui = "F" + cpui.substring(1);
                }
            }
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", cpui));
            MCOCategory mcoCategory = mco.getMcoCategory();
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PXNM", mco.getPassengerName()));
            Element xmlFareItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
            if (!this.isBatchCancel) {
                this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, mco);
            }
            xmlTctItem.appendChild(xmlFareItem);
            if (!this.isBatchCancel) {
                this.appendTaxesElement(xmlTctItem, mco, doc, parent);
            }
            if (!TextUtil.isBlank((String)(tourCode = mco.getTourCode())) && mcoCategory == MCOCategory.RETURN_TICKET) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TOUR", tourCode));
            }
            String emscCode = this.getEmscCode(mco.getMcoCategory());
            int segmentNo = 0;
            List<Segment> segments = this.getActiveCoupons(mco);
            String baseFare = mco.getBaseFare() != null && mco.getBaseFare().getValue() != null ? this.decimalFormat.format(mco.getBaseFare().getValue()) : "0";
            String string = curr = mco.getBaseFare() != null && mco.getBaseFare().getCurrency() != null ? mco.getBaseFare().getCurrency() : DictHelper.getLocalCurrency();
            if (mco.getMcoCategory() == MCOCategory.STICKER && mco.isEticket() && mco.getCashValue() != null) {
                baseFare = this.decimalFormat.format(mco.getCashValue());
                curr = DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            }
            if (segments.isEmpty()) {
                Segment seg = new Segment();
                seg.setRecordNumber(1);
                EntityContainer blankOwner = EntityStorage.get().resolve(mco.getBlankOwner());
                if (blankOwner != null) {
                    seg.setAirline(((Organization)blankOwner.getEntity()).getAirline());
                }
                segments.add(seg);
            }
            if (!segments.isEmpty()) {
                Element xmlCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                for (Segment segment : segments) {
                    ++segmentNo;
                    Element xmlCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                    xmlCouponItem.setAttributeNS(null, "NO", "" + segment.getRecordNumber());
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(mco)));
                    if (MCOCategory.INFORMATION != mco.getMcoCategory()) {
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", ("" + segment.getAirline().getCode()).trim()));
                    }
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                    if (!Arrays.asList("995", "98F", "98D", "98E").contains(emscCode)) {
                        if (segment.getDepartureLocation() != null) {
                            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                        }
                        if (segment.getArriveLocation() != null) {
                            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                        }
                    }
                    if (segments.size() == 1) {
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMCV", baseFare));
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTPC", curr != null ? curr : ""));
                    }
                    if (MCOCategory.COMFORT_PLUS == mco.getMcoCategory()) {
                        emscCode = "0B5";
                    } else if (MCOCategory.UNESCORTED_MINOR == mco.getMcoCategory()) {
                        emscCode = "0BH";
                    } else if (MCOCategory.WEAPON == mco.getMcoCategory()) {
                        emscCode = "0HW";
                    }
                    if (TextUtil.nonBlank((String)emscCode)) {
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMSC", emscCode));
                    }
                    String mainTicketNumber = "";
                    if (mco.getRelatedProducts().length > 0 && mco.getRelatedProducts()[0] != null) {
                        mainTicketNumber = mco.getRelatedProducts()[0].getCarrierNumber() + " " + mco.getRelatedProducts()[0].getSystemNumber();
                    }
                    if (TextUtil.isBlank((String)mainTicketNumber)) {
                        mainTicketNumber = mco.getMainTicketSeries() + " " + (!TextUtil.isBlank((String)mco.getMainTicketNumber()) ? mco.getMainTicketNumber() : mco.getRelatedProductNumber());
                    }
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMRT", mainTicketNumber));
                    int emrcCode = 0;
                    if (mco.getRelatedProducts() != null) {
                        emrcCode = mco.getSegments().size();
                    }
                    if (emrcCode != 0) {
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMRC", String.valueOf(emrcCode)));
                    }
                    if (MCOCategory.EXCESS_LUGGAGE.equals((Object)mco.getMcoCategory())) {
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "XBOA", mco.getLuggageUnits() == LuggageUnits.WEIGHT_KG ? "K" : "P"));
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "XBRU", mco.getBaseFare() != null ? mco.getBaseFare().getValue() : ""));
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "XBNE", mco.getLuggageWeight()));
                    }
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMNS", "1"));
                    if (MCOCategory.COMFORT_PLUS != mco.getMcoCategory() && MCOCategory.UNESCORTED_MINOR != mco.getMcoCategory() && MCOCategory.ANIMALS != mco.getMcoCategory()) {
                        xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", mco.getIssueDate() == null ? "" : new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(mco.getIssueDate())));
                    }
                    xmlCouponsItem.appendChild(xmlCouponItem);
                }
                xmlTctItem.appendChild(xmlCouponsItem);
            }
            if (!this.isBatchCancel && (conjunctions = mco.getConjunctions()).length > 0) {
                Element xmlConjanctionsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTIONS", null);
                for (int conjTicketNo = 1; conjTicketNo <= conjunctions.length; ++conjTicketNo) {
                    Element xmlConjanctionDocItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTION_DOC", null);
                    xmlConjanctionDocItem.setAttributeNS(null, "NO", Integer.toString(conjTicketNo));
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", mco.getTicketSeries() + " " + conjunctions[conjTicketNo - 1]));
                    if (mco.getConjunctionScns().length > 0) {
                        xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", mco.getConjunctionScns()[conjTicketNo - 1]));
                    }
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponNames(mco, conjTicketNo)));
                    Element xmlConjCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                    int conjCouponNumber = 0;
                    for (Segment segment : this.getConjCoupons(mco, conjTicketNo)) {
                        ++conjCouponNumber;
                        Element xmlConjCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                        xmlConjCouponItem.setAttributeNS(null, "NO", "" + this.getConjRecordNumber(mco.getCouponsCount(), segment.getRecordNumber()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(mco)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", segment.getAirline().getCode()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                        if (segment.getStartDate() != null) {
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                        }
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                        xmlConjCouponsItem.appendChild(xmlConjCouponItem);
                    }
                    xmlConjanctionDocItem.appendChild(xmlConjCouponsItem);
                    xmlConjanctionsItem.appendChild(xmlConjanctionDocItem);
                    xmlTctItem.appendChild(xmlConjanctionsItem);
                }
            }
            String rficCode = this.getRficCode(mco.getMcoCategory());
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RFIC", rficCode));
            if (!TextUtil.isBlank((String)mco.getEndorsement())) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ENRS", mco.getEndorsement()));
            }
            if (!TextUtil.isBlank((String)mco.getFareCalculationData())) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FRCA", mco.getFareCalculationData()));
            }
            if ((xmlTransaction = BaseSuXmlBatchHandler.getChildElement(parent, "TRANSACTION")) != null && !this.isBatchCancel) {
                this.addFopSection(doc, parent, xmlTransaction, mco);
            }
        }
    }

    private String getRficCode(MCOCategory mcoCategory) {
        String code = AirProductHelper.getRficCodeByMcoCategory((MCOCategory)mcoCategory);
        return code != null ? code : "D";
    }

    private String getEmscCode(MCOCategory mcoCategory) {
        if (mcoCategory == null || !this.mcoCategory2emscCode.containsKey(mcoCategory)) {
            return "";
        }
        return this.mcoCategory2emscCode.get(mcoCategory);
    }

    private String getUsageCode(MCOCategory mcoCategory, String blankOwnerCode) {
        if (mcoCategory == null) {
            return null;
        }
        if (blankOwnerCode.equals("SU")) {
            return "\u041f\u0440\u043e\u0447\u0435\u0435";
        }
        return this.mcoCategory2usageCode.get(mcoCategory);
    }

    private String getOtherKind(MCOCategory mcoCategory) {
        if (mcoCategory == null) {
            return null;
        }
        return this.mcoCategory2otherKind.get(mcoCategory);
    }

    private void appendCouponsElement(Element xmlTctItem, SuTicket ticket, Document doc, Element parent) {
        int segmentNo = 0;
        List<Segment> segments = this.getActiveCoupons(ticket);
        if (!segments.isEmpty()) {
            Element xmlCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
            for (Segment segment : segments) {
                ++segmentNo;
                Element xmlCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                xmlCouponItem.setAttributeNS(null, "NO", "" + segment.getRecordNumber());
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(ticket)));
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", ("" + segment.getAirline().getCode()).trim()));
                if (segment.getFlightNo() != null) {
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                } else {
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", "OPEN"));
                }
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                if (segment.getStartDate() != null) {
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                }
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RBKD", !TextUtil.isBlank((String)segment.getClassOfService()) ? segment.getClassOfService() : segment.getClassOfSvcCode()));
                xmlCouponsItem.appendChild(xmlCouponItem);
            }
            xmlTctItem.appendChild(xmlCouponsItem);
        }
    }

    protected void addDocTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) throws Exception {
        Element xmlTctItem = BaseSuXmlBatchHandler.getTicketElement(parent);
        if (xmlTctItem != null) {
            String tourCode;
            if (!this.isBatchCancel) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", ticket.isSticker() ? ticket.getStickerCouponNames() : BaseSuXmlBatchHandler.getFirstBlankCouponsNames(ticket)));
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PXNM", ticket.getPassengerName()));
                Element xmlFareItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
                this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, ticket);
                xmlTctItem.appendChild(xmlFareItem);
                this.appendTaxesElement(xmlTctItem, ticket, doc, parent);
                boolean suExchange = false;
                if ("SU".equals(ticket.getBlankOwnerCode()) && ticket.getPrevTicket() != null && ProductStatus.EXCHANGE.equals((Object)ticket.getPrevTicket().getStatus())) {
                    suExchange = true;
                }
                if (!(suExchange || "FV".equals(ticket.getBlankOwnerCode()) || "5N".equals(ticket.getBlankOwnerCode()))) {
                    xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "IFEXCNG", this.getExchangeMarker()));
                }
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PNRR", !TextUtil.isBlank((String)ticket.getLatinPnr()) ? ticket.getLatinPnr() : ticket.getPnr()));
            }
            if (!TextUtil.isBlank((String)(tourCode = ticket.getTourCode()))) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TOUR", tourCode));
            }
            this.appendCouponsElement(xmlTctItem, ticket, doc, parent);
            Element xmlTransaction = BaseSuXmlBatchHandler.getChildElement(parent, "TRANSACTION");
            if (xmlTransaction != null && !this.isBatchCancel) {
                this.addFopSection(doc, parent, xmlTransaction, ticket);
            }
        }
        if (xmlTctItem != null && !this.isBatchCancel) {
            String[] conjunctions = ticket.getConjunctions();
            if (conjunctions.length > 0) {
                Element xmlConjanctionsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTIONS", null);
                for (int conjTicketNo = 1; conjTicketNo <= conjunctions.length; ++conjTicketNo) {
                    Element xmlConjanctionDocItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTION_DOC", null);
                    xmlConjanctionDocItem.setAttributeNS(null, "NO", Integer.toString(conjTicketNo));
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " " + conjunctions[conjTicketNo - 1]));
                    if (ticket.getConjunctionScns().length > 0) {
                        xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", ticket.getConjunctionScns()[conjTicketNo - 1]));
                    }
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponNames(ticket, conjTicketNo)));
                    Element xmlConjCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                    int conjCouponNumber = 0;
                    for (Segment segment : this.getConjCoupons(ticket, conjTicketNo)) {
                        ++conjCouponNumber;
                        Element xmlConjCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                        xmlConjCouponItem.setAttributeNS(null, "NO", "" + this.getConjRecordNumber(ticket.getCouponsCount(), segment.getRecordNumber()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(ticket)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", segment.getAirline().getCode()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                        if (segment.getStartDate() != null) {
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                        }
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RBKD", !TextUtil.isBlank((String)segment.getClassOfService()) ? segment.getClassOfService() : segment.getClassOfSvcCode()));
                        xmlConjCouponsItem.appendChild(xmlConjCouponItem);
                    }
                    xmlConjanctionDocItem.appendChild(xmlConjCouponsItem);
                    xmlConjanctionsItem.appendChild(xmlConjanctionDocItem);
                    xmlTctItem.appendChild(xmlConjanctionsItem);
                }
            }
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ENRS", ticket.getEndorsement()));
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FRCA", ticket.getFareCalculationData()));
        }
    }

    protected void addAdmTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) throws Exception {
        Element memoElement = BaseSuXmlBatchHandler.getMemoElement(parent);
        if (memoElement != null) {
            String fromTo = null;
            if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ACM) {
                fromTo = "AG";
            } else if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ADM) {
                fromTo = "AL";
            }
            memoElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FROM_TO", fromTo));
            memoElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TRANSPCATE", "PAX"));
            Element amountElement = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
            memoElement.appendChild(amountElement);
            String baseFare = ticket.getBaseFare() != null && ticket.getBaseFare().getValue() != null ? this.decimalFormat.format(ticket.getBaseFare().getValue()) : "0";
            String baseCurrency = ticket.getBaseFare() != null && ticket.getBaseFare().getCurrency() != null ? ticket.getBaseFare().getCurrency() : DictHelper.getLocalCurrency2();
            String equivalentFare = ticket.getEquivalentFare() != null ? this.decimalFormat.format(ticket.getEquivalentFare()) : "0";
            amountElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", baseFare));
            amountElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", baseCurrency == null ? "" : baseCurrency));
            amountElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", ticket.getFareRate() != null ? ticket.getFareRate().doubleValue() : 1.0));
            amountElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", equivalentFare));
            Element itemsElement = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ITEMS", null);
            memoElement.appendChild(itemsElement);
            int counter = 1;
            for (AgencyMemoProductItemGroup agencyMemoProductItemGroup : ticket.getAgencyMemoProductItemGroups()) {
                Element itemElement = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ITEM", "");
                itemElement.setAttributeNS(null, "NO", Integer.toString(counter));
                itemsElement.appendChild(itemElement);
                String agencyMemoItemTitle = null;
                if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.BONUS) {
                    agencyMemoItemTitle = "\u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0435 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0435";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.COMMISSION) {
                    agencyMemoItemTitle = "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0435";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.PENALTY || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.CONTRACT_PENALTY) {
                    agencyMemoItemTitle = "\u0428\u0442\u0440\u0430\u0444\u044b";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TARIFF) {
                    agencyMemoItemTitle = "\u0422\u0430\u0440\u0438\u0444";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_CARRIER || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_FUEL || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_STATE || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_OTHERS) {
                    agencyMemoItemTitle = "\u0422\u0430\u043a\u0441\u044b";
                }
                String agencyMemoItemAmount = agencyMemoProductItemGroup.getAmount() != null && agencyMemoProductItemGroup.getAmount().getValue() != null ? this.decimalFormat.format(agencyMemoProductItemGroup.getAmount().getValue()) : "0";
                itemElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ITEM_TITLE", agencyMemoItemTitle));
                itemElement.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", agencyMemoItemAmount));
                ++counter;
            }
        }
    }

    protected void addFopSection(Document doc, Element parent, Element xmlTransaction, SuTicket ticket) {
        boolean isSuBlankOwner = ticket.getBlankOwnerCode() != null && (ticket.getBlankOwnerCode().equals("SU") || ticket.getBlankOwnerCode().equals("HZ"));
        Element xmlFops = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FOP", null);
        xmlTransaction.appendChild(xmlFops);
        if (xmlFops != null) {
            String fopTypeStr = "";
            String fopPaymentTypeStr = "";
            String fopDocNumber = "";
            int fopNumber = 0;
            boolean blockCharter = false;
            boolean groupTariff = false;
            Object cashFop = null;
            fopTypeStr = "CASH";
            fopPaymentTypeStr = "CA";
            if (TariffType.BLOCKCHARTER.equals((Object)ticket.getTariffType())) {
                blockCharter = true;
            }
            if (TariffType.CHARTER.equals((Object)ticket.getTariffType())) {
                blockCharter = true;
            }
            if (TariffType.GROUP.equals((Object)ticket.getTariffType())) {
                groupTariff = true;
            }
            boolean hasPoFop = false;
            if (ticket.isSticker() && this.hasNeighbourETicketMcoSticker(ticket)) {
                for (ProductFop fop : ticket.getFops()) {
                    if (ticket.getCashValue() == null || fop.getAmount() == null || !ticket.getCashValue().equals(fop.getAmount().getValue())) continue;
                    hasPoFop = true;
                    break;
                }
            }
            if (ticket.getFops().isEmpty() || hasPoFop) {
                Element xmlFopItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), fopTypeStr, null);
                xmlFopItem.setAttributeNS(null, "NO", String.valueOf(++fopNumber));
                xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPTP", fopPaymentTypeStr));
                Element xmlFopAmountItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.decimalFormat.format(cashFop.getAmount().getValue())));
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", DictHelper.getLocalCurrency()));
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", "1"));
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.decimalFormat.format(cashFop.getAmount().getValue())));
                xmlFopItem.appendChild(xmlFopAmountItem);
                xmlFops.appendChild(xmlFopItem);
                return;
            }
            for (ProductFop fop : ticket.getFops()) {
                if (PaymentType.TICKET.equals((Object)fop.getType()) || fop.getAmount() == null || ticket.getCashValue() != null && ticket.getCashValue().compareTo(fop.getAmount().getValue()) == 0 && ticket.isSticker() && this.hasNeighbourETicketMcoSticker(ticket) || blockCharter && ticket.getFops().size() > 1 && fop.getType() == PaymentType.TICKET) continue;
                ++fopNumber;
                if (fop.getType() == null) {
                    return;
                }
                switch (fop.getType()) {
                    case CASH: {
                        fopTypeStr = "CASH";
                        fopPaymentTypeStr = "CA";
                        break;
                    }
                    case INVOICE: {
                        if ((TextUtil.isBlank((String)ticket.getEndorsement()) || !ticket.getEndorsement().contains("RD")) && TextUtil.isBlank((String)ticket.getTelexNumber())) break;
                        fopTypeStr = "INVOICE";
                        fopPaymentTypeStr = "TX";
                        break;
                    }
                    case SERVICE_DEMAND: {
                        fopTypeStr = "INVOICE";
                        fopPaymentTypeStr = "TX";
                        break;
                    }
                    case CREDIT_CARD: {
                        fopTypeStr = "CREDIT_CARD";
                        fopPaymentTypeStr = "CC";
                        break;
                    }
                    case MCO: {
                        fopTypeStr = "EXCHANGE";
                        fopPaymentTypeStr = "MC";
                        break;
                    }
                    case TICKET: {
                        fopTypeStr = "CASH";
                        fopPaymentTypeStr = "CA";
                        if (!ticket.isDuplicate()) break;
                        fopTypeStr = "EXCHANGE";
                        fopPaymentTypeStr = isSuBlankOwner ? "DL" : "DU";
                        break;
                    }
                    case CREDIT: {
                        if (fop.getPassengerStatus() == null || fop.getPassengerStatus() != PassengerStatus.DEP_GD && fop.getPassengerStatus() != PassengerStatus.SOV_FED) break;
                    }
                    case MTD: {
                        fopTypeStr = "INVOICE";
                        fopPaymentTypeStr = "AI";
                        break;
                    }
                }
                if (blockCharter) {
                    fopTypeStr = "INVOICE";
                    fopPaymentTypeStr = fop.getAmount().getValue() != null && fop.getAmount().getValue().doubleValue() != 0.0 ? "BC" : "CH";
                }
                Element xmlFopItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), fopTypeStr, null);
                xmlFopItem.setAttributeNS(null, "NO", String.valueOf(fopNumber));
                xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPTP", fopPaymentTypeStr));
                Element xmlFopAmountItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.getRefundFare(ticket, fop.getAmount().getValue())));
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", fop.getAmount().getCurrency()));
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", "1"));
                xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.getRefundFare(ticket, fop.getAmount().getValue())));
                xmlFopItem.appendChild(xmlFopAmountItem);
                if (blockCharter) {
                    xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", ticket.getBlockCharterContractNo()));
                    xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", ticket.getBlockCharterAgenencyId()));
                } else {
                    switch (fop.getType()) {
                        case CREDIT_CARD: {
                            String cardOwner;
                            String securityCode;
                            if (fop.getCard() == null) break;
                            CardVendor cardVendor = fop.getCard().getVendor();
                            if (cardVendor != null) {
                                String cardVendorCode = null;
                                switch (cardVendor) {
                                    case VISA: {
                                        cardVendorCode = "VI";
                                        break;
                                    }
                                    case MASTERCARD: {
                                        cardVendorCode = "MC";
                                        break;
                                    }
                                    case AMEX: {
                                        cardVendorCode = "AX";
                                        break;
                                    }
                                    case JCB: {
                                        cardVendorCode = "JB";
                                        break;
                                    }
                                    case DINERS_CLUB: {
                                        cardVendorCode = "DC";
                                        break;
                                    }
                                    case AIR_TRAVEL_CARD: {
                                        cardVendorCode = "TP";
                                        break;
                                    }
                                    case MIR: {
                                        cardVendorCode = "MR";
                                    }
                                }
                                if (!TextUtil.isBlank((String)cardVendorCode)) {
                                    xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CCCC", cardVendorCode));
                                }
                            }
                            if (fop.getCard().getNumber() != null) {
                                String cardNumber;
                                fopDocNumber = cardNumber = fop.getCard().getNumber();
                            }
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", fopDocNumber));
                            Date expiration = fop.getCard().getExpiration();
                            if (expiration != null) {
                                xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EXDA", new SimpleDateFormat("yyyy-MM-dd").format(expiration)));
                            }
                            if ((securityCode = fop.getCard().getSecurityCode()) != null) {
                                xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "APLC", securityCode));
                            }
                            if (TextUtil.isBlank((String)(cardOwner = fop.getCard().getNameOnCard()))) break;
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CCHN", cardOwner));
                            break;
                        }
                        case INVOICE: {
                            if (!groupTariff || TextUtil.isBlank((String)ticket.getTelexNumber())) break;
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", ticket.getTelexNumber()));
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", "*"));
                            break;
                        }
                        case SERVICE_DEMAND: {
                            Optional<ProductFop> first = ticket.getFops().stream().filter(f -> f.getType() == PaymentType.SERVICE_DEMAND && f.getRelatedTicketNumber() != null).findFirst();
                            String relatedTicketNumber = null;
                            if (first.isPresent()) {
                                relatedTicketNumber = first.get().getRelatedTicketNumber();
                            }
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", relatedTicketNumber));
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", "*"));
                            break;
                        }
                        case MCO: {
                            fopDocNumber = ticket.getTicketSeries() + " " + fop.getRelatedTicketNumber();
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", fopDocNumber));
                            String coupons = "";
                            if (!TextUtil.isBlank((String)fopDocNumber)) {
                                if (fopDocNumber.matches("[ 0-9]{0,4}401[0-9]{7}")) {
                                    coupons = "R";
                                }
                                if (fopDocNumber.matches("[ 0-9]{0,4}402[0-9]{7}")) {
                                    coupons = "RR";
                                }
                            }
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", coupons));
                            break;
                        }
                        case TICKET: {
                            if (!ticket.isDuplicate()) break;
                            fopDocNumber = ticket.getTicketSeries() + " " + fop.getRelatedTicketNumber();
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", fopDocNumber));
                            String coupons = isSuBlankOwner ? this.getSuRefundedCoupons(ticket) : this.getS7RefundedCoupons(ticket);
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", coupons));
                            break;
                        }
                        case MTD: {
                            String mtdNumber = fop.getRelatedTicketNumber();
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", !TextUtil.isBlank((String)mtdNumber) ? mtdNumber.trim() : "*"));
                            String mtdType = null;
                            PassengerStatus passengerStatus = fop.getPassengerStatus();
                            mtdType = passengerStatus == PassengerStatus.VS_MVD ? "424954" : (passengerStatus == PassengerStatus.DEP_GD || passengerStatus == PassengerStatus.SOV_FED ? (!TextUtil.isBlank((String)mtdNumber) ? mtdNumber.trim() : "*") : "*");
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", mtdType));
                            break;
                        }
                        case CREDIT: {
                            PassengerStatus status = fop.getPassengerStatus();
                            String type = null;
                            if (status == PassengerStatus.DEP_GD) {
                                type = "GD";
                            } else {
                                if (status != PassengerStatus.SOV_FED) break;
                                type = "SF";
                            }
                            String number = fop.getRelatedTicketNumber();
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", !TextUtil.isBlank((String)number) ? number.trim() : "*"));
                            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", type));
                        }
                    }
                }
                xmlFops.appendChild(xmlFopItem);
            }
            if (("5N".equals(ticket.getBlankOwnerCode()) || "FV".equals(ticket.getBlankOwnerCode()) || "SU".equals(ticket.getBlankOwnerCode())) && ProductStatus.SELL.equals((Object)ticket.getStatus()) && ticket.getPrevTicket() != null && ProductStatus.EXCHANGE.equals((Object)ticket.getPrevTicket().getStatus())) {
                ArrayList<String> ticketNumbers = new ArrayList<String>();
                int couponsMax = 4;
                if (ticket.getPrevTicket().getPreviousProduct() != null) {
                    ticketNumbers.add(ticket.getPrevTicket().getPreviousProduct().getBlankOwnerNumber() + " " + ticket.getPrevTicket().getPreviousProduct().getSystemNumber());
                    String[] conjunctions = AirProductHelper.getConjunctions((Product)ticket.getPrevTicket().getPreviousProduct());
                    for (String c : conjunctions) {
                        ticketNumbers.add(ticket.getPrevTicket().getPreviousProduct().getBlankOwnerNumber() + " " + c);
                    }
                    if (ticket.getPrevTicket().getPreviousProduct().getBlankType() != null) {
                        BlankType bt = (BlankType)DictionaryCache.get().resolveReference(ticket.getPrevTicket().getPreviousProduct().getBlankType());
                        couponsMax = bt.getCouponsCount();
                    }
                } else {
                    ticketNumbers.add(ticket.getRelatedTicketNumber());
                }
                StringBuilder coupons = new StringBuilder("               ");
                for (Segment s : ticket.getPrevTicket().getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList())) {
                    if (s.getRecordNumber() - 1 >= coupons.length()) continue;
                    coupons.setCharAt(s.getRecordNumber() - 1, 'R');
                }
                String currency = ticket.getBaseFare() != null && ticket.getBaseFare().getCurrency() != null ? ticket.getBaseFare().getCurrency() : DictHelper.getLocalCurrency();
                List<Element> xmlFopItems = this.createExchangeFopElements(fopNumber, ticketNumbers, coupons.toString(), couponsMax, doc, parent.getNamespaceURI(), currency);
                for (Element xmlFopItem : xmlFopItems) {
                    xmlFops.appendChild(xmlFopItem);
                }
            }
        }
    }

    private List<Element> createExchangeFopElements(int fopNumber, List<String> ticketNumbers, String coupons, int couponsMax, Document doc, String namespaceURI, String currency) {
        ArrayList<Element> res = new ArrayList<Element>();
        int num = 0;
        for (String ticketNumber : ticketNumbers) {
            Element xmlFopItem = BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "EXCHANGE", null);
            xmlFopItem.setAttributeNS(null, "NO", String.valueOf(++fopNumber));
            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "FPTP", "EX"));
            Element xmlFopAmountItem = BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "AMOUNT", null);
            xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "SOURCE", "0"));
            xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "CUTP", currency != null ? currency : ""));
            xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "RATE", "1"));
            xmlFopAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "AMNT", "0"));
            xmlFopItem.appendChild(xmlFopAmountItem);
            Element xmlMainDocTDNR = BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "TDNR", ticketNumber);
            xmlFopItem.appendChild(xmlMainDocTDNR);
            String couponsString = "";
            if (num * couponsMax < coupons.length()) {
                int end = (num + 1) * couponsMax < coupons.length() ? (num + 1) * couponsMax : coupons.length() - 1;
                couponsString = coupons.substring(num * couponsMax, end);
            }
            ++num;
            xmlFopItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "CPUI", couponsString.replaceAll("\\s+$", "")));
            res.add(xmlFopItem);
        }
        return res;
    }

    private boolean hasNeighbourETicketMcoSticker(SuTicket ticket) {
        boolean result = false;
        if (ticket.getProduct() != null && ticket.getProduct().getReservation() != null) {
            String sellProductNumber = ticket.getProduct().getSystemNumber();
            for (BaseProduct p : ticket.getProduct().getReservation().getProducts()) {
                if (!(p instanceof Product) || !MCOCategory.STICKER.equals((Object)((Product)p).getMcoCategory()) || !((Product)p).isEticket()) continue;
                boolean mcoForThatSell = false;
                for (Product p2 : ((Product)p).getRelatedProducts()) {
                    if (!TextUtil.isSame((String)p2.getSystemNumber(), (String)sellProductNumber)) continue;
                    mcoForThatSell = true;
                    break;
                }
                if (!mcoForThatSell) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void appendTaxesElement(Element xmlTctItem, SuTicket ticket, Document doc, Element parent) {
        boolean hasPO = false;
        if (ticket.isSticker() && this.hasNeighbourETicketMcoSticker(ticket)) {
            for (Tax t : ticket.getTaxes()) {
                if (!"PO".equals(t.getCode())) continue;
                hasPO = true;
                break;
            }
        }
        if (ticket.getTaxes() == null || ticket.getTaxes().isEmpty() || hasPO && ticket.getTaxes().size() == 1) {
            return;
        }
        Element xmlTaxesItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TAXES", null);
        int taxNumber = 0;
        List sortedTaxes = ticket.getTaxes().stream().sorted((t1, t2) -> MiscUtil.compare((Comparable)t2.getEquivalentAmount(), (Comparable)t1.getEquivalentAmount())).collect(Collectors.toList());
        BigDecimal refundFareExcess = this.getRefundFareExcess(ticket);
        for (Tax tax : sortedTaxes) {
            BigDecimal taxAmount;
            if (tax.getEquivalentAmount().doubleValue() == 0.0 || tax.getCode() == "PO" && ticket.isSticker() && this.hasNeighbourETicketMcoSticker(ticket)) continue;
            Element xmlTaxTaxesItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TAX", null);
            xmlTaxTaxesItem.setAttributeNS(null, "NO", Integer.toString(++taxNumber));
            Element taxesAmountItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
            if (MiscUtil.compare((Comparable)tax.getEquivalentAmount(), (Comparable)refundFareExcess) == -1) {
                taxAmount = BigDecimal.ZERO;
                refundFareExcess = MiscUtil.sub((BigDecimal)refundFareExcess, (BigDecimal[])new BigDecimal[]{tax.getEquivalentAmount()});
            } else {
                taxAmount = MiscUtil.sub((BigDecimal)tax.getEquivalentAmount(), (BigDecimal[])new BigDecimal[]{refundFareExcess});
                refundFareExcess = BigDecimal.ZERO;
            }
            double taxValue = tax.getEquivalentAmount().doubleValue();
            taxesAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.decimalFormat.format(taxValue)));
            taxesAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", SalesReportHelper.getEquivCurrency(null)));
            taxesAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", "1"));
            taxesAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.decimalFormat.format(taxAmount.doubleValue())));
            xmlTaxTaxesItem.appendChild(taxesAmountItem);
            xmlTaxTaxesItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TMFT", tax.getCode().toUpperCase()));
            xmlTaxesItem.appendChild(xmlTaxTaxesItem);
        }
        if (taxNumber > 0) {
            xmlTctItem.appendChild(xmlTaxesItem);
        }
    }

    protected void addFareItem(Document doc, String namespaceURI, Element xmlFareItem, SuTicket ticket) {
        String commVal;
        String commRate;
        boolean zeroMco = ticket.getMcoCategory() == null && ticket.isSticker() || (ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.STICKER || ticket.getMcoCategory() == MCOCategory.REBOOKING || ticket.getMcoCategory() == MCOCategory.ADDITIONAL_TARIFF || ticket.getMcoCategory() == MCOCategory.UNESCORTED_MINOR || ticket.getMcoCategory() == MCOCategory.INFORMATION || ticket.getMcoCategory() == MCOCategory.COMFORT_PLUS) && !ticket.isEticket();
        Element xmlFareAmountItem = BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "AMOUNT", null);
        xmlFareItem.appendChild(xmlFareAmountItem);
        if (xmlFareAmountItem != null) {
            String curr;
            String baseFare = !zeroMco && ticket.getBaseFare() != null && ticket.getBaseFare().getValue() != null ? this.getRefundFare(ticket, ticket.getBaseFare().getValue()) : "0";
            String equivFare = !zeroMco && ticket.getEquivalentFare() != null ? this.getRefundFare(ticket, ticket.getEquivalentFare()) : "0";
            String string = curr = ticket.getBaseFare() != null && ticket.getBaseFare().getCurrency() != null ? ticket.getBaseFare().getCurrency() : DictHelper.getLocalCurrency();
            if (ticket.getMcoCategory() == MCOCategory.STICKER && ticket.isEticket() && ticket.getCashValue() != null) {
                baseFare = equivFare = this.getRefundFare(ticket, ticket.getCashValue());
                curr = DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            }
            xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "SOURCE", baseFare));
            xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "CUTP", curr == null ? "" : curr));
            if (!zeroMco && ticket.getFareRate() != null) {
                if (("SU".equals(ticket.getBlankOwnerCode()) || "5N".equals(ticket.getBlankOwnerCode())) && ticket.getPrevTicket() != null && ProductStatus.EXCHANGE.equals((Object)ticket.getPrevTicket().getStatus())) {
                    xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "RATE", ticket.getFareRate().doubleValue()));
                } else {
                    xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "RATE", !BigDecimal.ZERO.equals(ticket.getFareRate()) ? ticket.getFareRate().doubleValue() : 1.0));
                }
            } else {
                xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "RATE", 1.0));
            }
            xmlFareAmountItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "AMNT", equivFare));
        }
        Element xmlFareCommissionItem = BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "COMMISSION", null);
        try {
            commRate = this.decimalFormat.format(ticket.getVendorCommissionRate() != null ? ticket.getVendorCommissionRate() : 0.0);
        }
        catch (IllegalArgumentException iae) {
            commRate = "";
        }
        try {
            commVal = this.decimalFormat.format(ticket.getVendorEquivalentCommission());
        }
        catch (IllegalArgumentException iae) {
            commVal = "";
        }
        xmlFareCommissionItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "CORT", commRate));
        xmlFareCommissionItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, namespaceURI, "COAM", commVal));
        xmlFareItem.appendChild(xmlFareCommissionItem);
    }

    protected void addTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) {
        try {
            if (ticket.getReportTicketType() == BaseSalesReportTicket.ReportTicketType.MEMO) {
                this.beginMemoTransaction(doc, parent, ticket, ticketNo);
                this.addAdmTicketTransaction(doc, parent, ticket, ticketNo);
            } else {
                this.beginTicketTransaction(doc, parent, ticket, ticketNo);
                if (ticket.getProductCategory() == ProductCategory.MCO && !this.isMcoTicketReturn && ticket.getStatus() != ProductStatus.VOID) {
                    if (ticket.isEticket() && ("S7".equals(ticket.getBlankOwnerCode()) || "SU".equals(ticket.getBlankOwnerCode()))) {
                        this.addMcoEmdTicketTransaction(doc, parent, ticket, ticketNo);
                    } else {
                        this.addMcoTicketTransaction(doc, parent, ticket, ticketNo);
                    }
                } else if (ticket.getProductCategory() == ProductCategory.EXCESS_BAGAGE) {
                    if (ticket.isEticket() && ("S7".equals(ticket.getBlankOwnerCode()) || "SU".equals(ticket.getBlankOwnerCode()))) {
                        this.addEbtEmdTicketTransaction(doc, parent, ticket, ticketNo);
                    } else {
                        this.addEbtTicketTransaction(doc, parent, ticket, ticketNo);
                    }
                } else {
                    this.addDocTicketTransaction(doc, parent, ticket, ticketNo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void beginTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) {
        Element xmlTransaction = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TRANSACTION", null);
        xmlTransaction.setAttributeNS(null, "NO", Integer.toString(ticketNo));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DAIS", ticket.getIssueDate() == null ? "" : new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(ticket.getIssueDate())));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AGTN", ticket.getValidatorCode()));
        String transactionCode = this.getTransactionType(ticket);
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TRANS_TYPE", transactionCode));
        if ("SALE".equals(transactionCode)) {
            transactionCode = "\u041f\u0440\u043e\u0434\u0430\u0436\u0430";
        } else if ("REFUND".equals(transactionCode)) {
            transactionCode = "\u0412\u043e\u0437\u0432\u0440\u0430\u0442";
        } else if ("CANCEL".equals(transactionCode)) {
            transactionCode = "\u0418\u0441\u043f\u043e\u0440\u0447\u0435\u043d";
        } else if ("STICKER".equals(transactionCode)) {
            transactionCode = "\u0421\u0442\u0438\u043a\u0435\u0440";
        } else if ("ANNUL".equals(transactionCode)) {
            transactionCode = "\u0410\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d";
        }
        ticket.setTransactionCode(transactionCode);
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "VAT", ticket.isVatIncluded() ? "YES" : "NO"));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CURRENCY", doc.getElementsByTagName("CURRENCY").item(0).getTextContent()));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "E_TICKET", ticket.isEticket() ? "YES" : "NO"));
        if (!TextUtil.isBlank((String)ticket.getPcc())) {
            xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AGTA", ticket.getPcc()));
        }
        Element xmlDocItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DOC", null);
        Element xmlTctItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), BaseSuXmlBatchHandler.getTicketElementName(ticket), null);
        if (TextUtil.isBlank((String)ticket.getTicketNumber())) {
            if (!TextUtil.isBlank((String)ticket.getScn())) {
                xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " 05" + ticket.getScn().substring(2)));
            }
        } else {
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " " + ticket.getTicketNumber()));
        }
        if (ticket.getProductCategory() != ProductCategory.MCO && ticket.getProductCategory() != ProductCategory.EXCESS_BAGAGE && !TextUtil.isBlank((String)ticket.getScn()) && !ticket.isEticket()) {
            xmlTctItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", ticket.getScn()));
        }
        xmlDocItem.appendChild(xmlTctItem);
        xmlTransaction.appendChild(xmlDocItem);
        parent.appendChild(xmlTransaction);
    }

    protected void beginMemoTransaction(Document document, Element parent, SuTicket ticket, int ticketNo) {
        Element xmlTransaction = BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "TRANSACTION", null);
        xmlTransaction.setAttributeNS(null, "NO", Integer.toString(ticketNo));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "DAIS", ticket.getIssueDate() == null ? "" : new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(ticket.getIssueDate())));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "AGTN", ticket.getValidatorCode()));
        String transactionCode = this.getTransactionType(ticket);
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "TRANS_TYPE", transactionCode));
        if ("SALE".equals(transactionCode)) {
            transactionCode = "\u041f\u0440\u043e\u0434\u0430\u0436\u0430";
        }
        ticket.setTransactionCode(transactionCode);
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "VAT", ticket.isVatIncluded() ? "YES" : "NO"));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "CURRENCY", document.getElementsByTagName("CURRENCY").item(0).getTextContent()));
        xmlTransaction.appendChild(BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "E_TICKET", ticket.isEticket() ? "YES" : "NO"));
        Element xmlDocItem = BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "DOC", null);
        Element xmlMemoItem = BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), BaseSuXmlBatchHandler.getTicketElementName(ticket), null);
        xmlMemoItem.appendChild(BaseSuXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "TDNR", String.format("%s %s", ticket.getTicketSeries(), ticket.getTicketNumber())));
        xmlDocItem.appendChild(xmlMemoItem);
        xmlTransaction.appendChild(xmlDocItem);
        parent.appendChild(xmlTransaction);
    }

    protected Element getTicketElement(Element parent, SuTicket ticket) {
        Element docElement = BaseSuXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            switch (ticket.getProductCategory()) {
                case AIR: {
                    if (ticket.getStatus() == ProductStatus.VOID) {
                        return BaseSuXmlBatchHandler.getChildElement(docElement, "CANCEL");
                    }
                    return BaseSuXmlBatchHandler.getChildElement(docElement, "TCT");
                }
                case MCO: {
                    if (ticket.isEticket()) {
                        return BaseSuXmlBatchHandler.getChildElement(docElement, "MCO_EMD");
                    }
                    return BaseSuXmlBatchHandler.getChildElement(docElement, "MCO");
                }
            }
        }
        return null;
    }

    protected List<Segment> getConjCoupons(SuTicket ticket, int conjIndex) {
        ArrayList<Segment> activeCoupons = new ArrayList<Segment>();
        int couponsCollected = 0;
        int couponCounter = 0;
        for (Segment segment : ticket.getSegments()) {
            if (segment.getRecordNumber() <= ticket.getCouponsCount() * conjIndex) {
                ++couponCounter;
                continue;
            }
            if (segment.getRecordNumber() > ticket.getCouponsCount() * (conjIndex + 1)) break;
            activeCoupons.add(segment);
            ++couponsCollected;
            ++couponCounter;
        }
        return activeCoupons;
    }

    protected String getExchangeMarker() throws Exception {
        return "\u041d\u0415\u0422";
    }

    private List<Segment> getActiveCoupons(SuTicket ticket) {
        return this.getConjCoupons(ticket, 0);
    }

    private int getConjRecordNumber(int couponsCount, int recordNumber) {
        if (recordNumber > couponsCount) {
            int recNo = recordNumber % couponsCount;
            return recNo == 0 ? couponsCount : recNo;
        }
        return recordNumber;
    }

    protected void addEbtTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) throws Exception {
        Element xmlEbtItem = BaseSuXmlBatchHandler.getBagageElement(parent, ticket);
        if (xmlEbtItem != null) {
            String[] conjunctions;
            Element xmlTransaction;
            xmlEbtItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", ticket.isSticker() ? ticket.getStickerCouponNames() : BaseSuXmlBatchHandler.getFirstBlankCouponsNames(ticket)));
            Element xmlFareItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
            this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, ticket);
            xmlEbtItem.appendChild(xmlFareItem);
            this.appendTaxesElement(xmlEbtItem, ticket, doc, parent);
            if (!TextUtil.isBlank((String)ticket.getMainTicketNumber())) {
                String mainTicketNumber = (!TextUtil.isBlank((String)ticket.getMainTicketSeries()) ? ticket.getMainTicketSeries() : ticket.getTicketSeries()) + " " + ticket.getMainTicketNumber();
                Element xmlMainDocs = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                Element xmlMainDoc = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                Element xmlMainDocTDNR = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", mainTicketNumber);
                xmlMainDoc.appendChild(xmlMainDocTDNR);
                xmlMainDocs.appendChild(xmlMainDoc);
                xmlEbtItem.appendChild(xmlMainDocs);
            }
            Element xmlWeightItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "WEIGHT", Integer.toString((int)ticket.getLuggageWeight()));
            xmlEbtItem.appendChild(xmlWeightItem);
            Element xmlWeightRateItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "WEIGHT_RATE", "0");
            xmlEbtItem.appendChild(xmlWeightRateItem);
            int segmentNo = 0;
            List<Segment> segments = this.getActiveCoupons(ticket);
            if (!segments.isEmpty()) {
                Element xmlCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                for (Segment segment : segments) {
                    ++segmentNo;
                    Element xmlCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                    xmlCouponItem.setAttributeNS(null, "NO", "" + segment.getRecordNumber());
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(ticket)));
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", ("" + segment.getAirline().getCode()).trim()));
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                    xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                    xmlCouponsItem.appendChild(xmlCouponItem);
                }
                xmlEbtItem.appendChild(xmlCouponsItem);
            }
            if ((xmlTransaction = BaseSuXmlBatchHandler.getChildElement(parent, "TRANSACTION")) != null) {
                this.addFopSection(doc, parent, xmlTransaction, ticket);
            }
            if (!this.isBatchCancel && (conjunctions = ticket.getConjunctions()).length > 0) {
                Element xmlConjanctionsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTIONS", null);
                for (int conjTicketNo = 1; conjTicketNo <= conjunctions.length; ++conjTicketNo) {
                    Element xmlConjanctionDocItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTION_DOC", null);
                    xmlConjanctionDocItem.setAttributeNS(null, "NO", Integer.toString(conjTicketNo));
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " " + conjunctions[conjTicketNo - 1]));
                    if (ticket.getConjunctionScns().length > 0) {
                        xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", ticket.getConjunctionScns()[conjTicketNo - 1]));
                    }
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponNames(ticket, conjTicketNo)));
                    Element xmlConjCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                    int conjCouponNumber = 0;
                    for (Segment segment : this.getConjCoupons(ticket, conjTicketNo)) {
                        ++conjCouponNumber;
                        Element xmlConjCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                        xmlConjCouponItem.setAttributeNS(null, "NO", "" + this.getConjRecordNumber(ticket.getCouponsCount(), segment.getRecordNumber()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(ticket)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", segment.getAirline().getCode()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                        if (segment.getStartDate() != null) {
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                        }
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                        xmlConjCouponsItem.appendChild(xmlConjCouponItem);
                    }
                    xmlConjanctionDocItem.appendChild(xmlConjCouponsItem);
                    xmlConjanctionsItem.appendChild(xmlConjanctionDocItem);
                    xmlEbtItem.appendChild(xmlConjanctionsItem);
                }
            }
            Element xmlLuggageUnitsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "XBOA", ticket.getLuggageUnits() == LuggageUnits.WEIGHT_KG ? "K" : "P");
            xmlEbtItem.appendChild(xmlLuggageUnitsItem);
        }
    }

    protected void addEbtEmdTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) throws Exception {
        Element xmlEbtItem = BaseSuXmlBatchHandler.getBagageElement(parent, ticket);
        if (xmlEbtItem != null) {
            String[] conjunctions;
            String emscCode;
            xmlEbtItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", ticket.isSticker() ? ticket.getStickerCouponNames() : BaseSuXmlBatchHandler.getFirstBlankCouponsNames(ticket)));
            xmlEbtItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PXNM", ticket.getPassengerName()));
            Element xmlFareItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
            this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, ticket);
            xmlEbtItem.appendChild(xmlFareItem);
            this.appendTaxesElement(xmlEbtItem, ticket, doc, parent);
            List<Segment> segments = this.getActiveCoupons(ticket);
            Collections.sort(segments, new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.getRecordNumber() - o2.getRecordNumber();
                }
            });
            Segment generalSegment = new Segment();
            generalSegment.setRecordNumber(1);
            for (Segment seg : segments) {
                if (generalSegment.getDepartureLocation() == null) {
                    generalSegment.setDepartureLocation(seg.getDepartureLocation());
                }
                generalSegment.setArriveLocation(seg.getArriveLocation());
                generalSegment.setAirline(seg.getAirline());
                generalSegment.setFareBasis(seg.getFareBasis());
            }
            Element xmlCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
            Element xmlCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
            xmlCouponItem.setAttributeNS(null, "NO", "" + generalSegment.getRecordNumber());
            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(ticket)));
            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", ("" + generalSegment.getAirline().getCode()).trim()));
            if (generalSegment.getDepartureLocation() != null) {
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)generalSegment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
            }
            if (generalSegment.getArriveLocation() != null) {
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)generalSegment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
            }
            if (!TextUtil.isBlank((String)(emscCode = this.getEmscCode(MCOCategory.EXCESS_LUGGAGE)))) {
                xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMSC", emscCode));
            }
            String mainTicketNumber = "";
            if (ticket.getRelatedProducts().length > 0 && ticket.getRelatedProducts()[0] != null) {
                mainTicketNumber = ticket.getRelatedProducts()[0].getCarrierNumber() + " " + ticket.getRelatedProducts()[0].getSystemNumber();
            }
            if (TextUtil.isBlank((String)mainTicketNumber)) {
                mainTicketNumber = ticket.getMainTicketSeries() + " " + (!TextUtil.isBlank((String)ticket.getMainTicketNumber()) ? ticket.getMainTicketNumber() : ticket.getRelatedProductNumber());
            }
            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMRT", mainTicketNumber));
            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EMRC", generalSegment.getRecordNumber()));
            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "XBOA", ticket.getLuggageUnits() == LuggageUnits.WEIGHT_KG ? "K" : "P"));
            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "XBRU", ticket.getBaseFare() != null ? ticket.getBaseFare().getValue() : ""));
            xmlCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "XBNE", ticket.getLuggageWeight()));
            xmlCouponsItem.appendChild(xmlCouponItem);
            xmlEbtItem.appendChild(xmlCouponsItem);
            if (!this.isBatchCancel && (conjunctions = ticket.getConjunctions()).length > 0) {
                Element xmlConjanctionsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTIONS", null);
                for (int conjTicketNo = 1; conjTicketNo <= conjunctions.length; ++conjTicketNo) {
                    Element xmlConjanctionDocItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTION_DOC", null);
                    xmlConjanctionDocItem.setAttributeNS(null, "NO", Integer.toString(conjTicketNo));
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " " + conjunctions[conjTicketNo - 1]));
                    if (ticket.getConjunctionScns().length > 0) {
                        xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", ticket.getConjunctionScns()[conjTicketNo - 1]));
                    }
                    xmlConjanctionDocItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponNames(ticket, conjTicketNo)));
                    Element xmlConjCouponsItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                    int conjCouponNumber = 0;
                    for (Segment segment : this.getConjCoupons(ticket, conjTicketNo)) {
                        ++conjCouponNumber;
                        Element xmlConjCouponItem = BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                        xmlConjCouponItem.setAttributeNS(null, "NO", "" + this.getConjRecordNumber(ticket.getCouponsCount(), segment.getRecordNumber()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", BaseSuXmlBatchHandler.getCouponName(ticket)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", segment.getAirline().getCode()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                        if (segment.getStartDate() != null) {
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                            xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                        }
                        xmlConjCouponItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                        xmlConjCouponsItem.appendChild(xmlConjCouponItem);
                    }
                    xmlConjanctionDocItem.appendChild(xmlConjCouponsItem);
                    xmlConjanctionsItem.appendChild(xmlConjanctionDocItem);
                    xmlEbtItem.appendChild(xmlConjanctionsItem);
                }
            }
            xmlEbtItem.appendChild(BaseSuXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RFIC", "C"));
        }
    }

    private String getSuRefundedCoupons(SuTicket ticket) {
        int couponsCnt = ticket.getCouponsCount();
        int segmentMaxNo = couponsCnt * (ticket.getConjCount() + 1);
        char[] coupons = new char[segmentMaxNo];
        for (int i = 0; i < segmentMaxNo; ++i) {
            coupons[i] = 32;
        }
        for (Segment seg : ticket.getSegments()) {
            if (seg.getRecordNumber() <= 0 || seg.getRecordNumber() > segmentMaxNo) continue;
            coupons[seg.getRecordNumber() - 1] = Character.forDigit(seg.getRecordNumber(), 10);
        }
        return new String(coupons);
    }

    private String getS7RefundedCoupons(SuTicket ticket) {
        int couponsCnt = ticket.getSegments().size();
        char[] coupons = new char[couponsCnt];
        for (Segment seg : ticket.getSegments()) {
            if (seg.getRecordNumber() <= 0 || seg.getRecordNumber() > couponsCnt) continue;
            coupons[seg.getRecordNumber() - 1] = 82;
        }
        return new String(coupons);
    }

    private List<List<SuTicket>> getSubBatches(List<SuTicket> allTickets) {
        Map<Integer, List<SuTicket>> batchNoToTickets = allTickets.stream().collect(Collectors.groupingBy(SuTicket::getBatchNo));
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(batchNoToTickets.keySet());
        Collections.sort(sortedKeys);
        return sortedKeys.stream().map(batchNoToTickets::get).filter(CollectionUtil::isNotEmpty).collect(Collectors.toList());
    }

    private String getRefundFare(SuTicket ticket, BigDecimal fare) {
        if (fare == null || fare.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        if (ticket.getMcoCategory() != MCOCategory.STICKER && ticket.getMcoCategory() != MCOCategory.UNESCORTED_MINOR && ticket.getMcoCategory() != MCOCategory.INFORMATION && ticket.getMcoCategory() != MCOCategory.COMFORT_PLUS && "REFUND".equals(ticket.getBatchType()) && ProductCategory.MCO == ticket.getProductCategory() && BigDecimal.ZERO.compareTo(fare) < 0) {
            fare = MiscUtil.negate((BigDecimal)ticket.getEquivalentFare());
        }
        return fare.compareTo(BigDecimal.ZERO) > 0 ? this.decimalFormat.format(fare) : "0";
    }

    private BigDecimal getRefundFareExcess(SuTicket ticket) {
        if (ticket.getEquivalentFare() != null) {
            return ticket.getEquivalentFare().compareTo(BigDecimal.ZERO) < 0 && this.getRefundFare(ticket, ticket.getEquivalentFare()).equals("0") ? MiscUtil.negate((BigDecimal)ticket.getEquivalentFare()) : BigDecimal.ZERO;
        }
        return BigDecimal.ZERO;
    }
}

