/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.xml;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import java.net.URL;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SuXmlValidator {
    public static String validate(Document doc) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (DOMError error : XmlUtil.validateWithSchema((Document)doc, (URL)SuXmlValidator.class.getResource("suXmlReportSchema.xsd"), s -> s.contains("Invalid content was found starting with element 'XBOA'"))) {
            if (error.getSeverity() == 1) continue;
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            StringBuilder sb2 = new StringBuilder();
            String ticketNumber = null;
            DOMLocator location = error.getLocation();
            Node relatedNode = location.getRelatedNode();
            if (relatedNode != null) {
                ticketNumber = SuXmlValidator.findTicketNumber(relatedNode);
            }
            sb2.append(ticketNumber != null ? L10nResourcesManager.createL10nMessage((String)Messages.SuXmlValidator_errorInTransactionForTicket, (Object[])new Object[]{ticketNumber}).toString() : L10nResourcesManager.createL10nMessage((String)Messages.SuXmlValidator_errorInRootElement, (Object[])new Object[0]).toString());
            if (!TextUtil.isBlank((String)error.getMessage())) {
                sb2.append(" " + L10nResourcesManager.createL10nMessage((String)Messages.SuXmlValidator_details, (Object[])new Object[0]).toString()).append(error.getMessage());
            }
            if (sb.toString().contains(sb2.toString())) continue;
            sb.append(sb2.toString());
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static String findTicketNumber(Node node) {
        Element transactionElm = SuXmlValidator.findParentNode(node, "TRANSACTION");
        if (transactionElm == null) {
            return null;
        }
        String number = XmlUtil.getValue((Element)transactionElm, (String)"DOC/TCT/TDNR");
        if (!TextUtil.isBlank((String)number)) {
            return number;
        }
        number = XmlUtil.getValue((Element)transactionElm, (String)"DOC/EBT/TDNR");
        if (!TextUtil.isBlank((String)number)) {
            return number;
        }
        number = XmlUtil.getValue((Element)transactionElm, (String)"DOC/MCO/TDNR");
        if (!TextUtil.isBlank((String)number)) {
            return number;
        }
        number = XmlUtil.getValue((Element)transactionElm, (String)"DOC/ADM/TDNR");
        if (!TextUtil.isBlank((String)number)) {
            return number;
        }
        number = XmlUtil.getValue((Element)transactionElm, (String)"DOC/ACM/TDNR");
        if (!TextUtil.isBlank((String)number)) {
            return number;
        }
        number = XmlUtil.getValue((Element)transactionElm, (String)"DOC/CHARTER/TDNR");
        if (!TextUtil.isBlank((String)number)) {
            return number;
        }
        number = XmlUtil.getValue((Element)transactionElm, (String)"DOC/CANCEL/TDNR");
        if (!TextUtil.isBlank((String)number)) {
            return number;
        }
        return null;
    }

    private static Element findParentNode(Node node, String nodeName) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1 && nodeName.equals(node.getNodeName())) {
            return (Element)node;
        }
        return SuXmlValidator.findParentNode(node.getParentNode(), nodeName);
    }
}

